/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.admin.GenericServiceTreeNode;
import org.eclipse.aperi.gui.admin.ServicesDDI;
import org.eclipse.aperi.gui.admin.ServicesTreeNode;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.aperi.xmsg.MessageLog;

public class ServicesTreeLabel
extends BaseTreeNode
implements ActionListener {
    public ServicesTreeLabel() {
        this.setUserObject(Util.getString(this.getLabelUIName()));
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(MessageLog.getMessageNoID("ADG0003L"));
        jMenuItem.setToolTipText(MessageLog.getMessageNoID("ADG0004T"));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        this.showPopupMenu(jPopupMenu, mouseEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getServices();
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        this.getServices();
    }

    protected void getServices() {
        Serializable serializable;
        String string = null;
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        if (dataDisplayInfo != null && dataDisplayInfo instanceof ServicesDDI) {
            string = ((GenericServiceTreeNode)dataDisplayInfo.treeNode).getRequestType();
        }
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            serializable = (ServicesTreeNode)enumeration.nextElement();
            if (((ServicesTreeNode)serializable).ddi == null) continue;
            ((ServicesTreeNode)serializable).ddi.remove();
        }
        this.removeAllChildren();
        if (GuiClient.serverStatus() <= 4) {
            ServerStatusResp.Service service;
            serializable = GuiClient.serverStatusResp;
            int n = ((ServerStatusResp)serializable).services.length;
            int n2 = 0;
            while (n2 < n) {
                service = ((ServerStatusResp)serializable).services[n2];
                if (service.requestType == "org.eclipse.aperi.server.svp.ServerSvp") {
                    this.add(new ServicesTreeNode(RequestTypeManager.getExternalName(service.requestType), service.requestType, service.state, service.pendingRequests, service.processedRequests, service.threadsWaiting));
                    break;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                service = ((ServerStatusResp)serializable).services[n2];
                if (service.requestType != "org.eclipse.aperi.server.svp.ServerSvp") {
                    this.add(new ServicesTreeNode(RequestTypeManager.getExternalName(service.requestType), service.requestType, service.state, service.pendingRequests, service.processedRequests, service.threadsWaiting));
                }
                ++n2;
            }
        }
        BaseTree.MyTree.nodeStructureChanged(this);
        if (string != null) {
            enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                serializable = (ServicesTreeNode)enumeration.nextElement();
                if (!((GenericServiceTreeNode)serializable).getRequestType().equals(string)) continue;
                ((GenericServiceTreeNode)serializable).select(null);
                break;
            }
        }
    }

    protected String getLabelUIName() {
        return "DATA_SERVER";
    }
}

