/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.ConfigSectionContainer;

public abstract class ConfigTab
extends JPanel
implements ActionListener {
    private ArrayList sections = null;
    private JButton refreshBtn = null;

    public ConfigTab() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        this.refreshBtn = new JButton(GuiUtil.getString("CONFIG_COMMON_BUTTON_REFRESH"));
        this.refreshBtn.addActionListener(this);
        GuiUtil.setAccessible(this.refreshBtn, this.refreshBtn.getText(), this.refreshBtn.getText());
        jPanel2.add(this.refreshBtn);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel.add(new JSeparator(0));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.initSections();
        int n = 0;
        while (this.sections != null && n < this.sections.size()) {
            ConfigSection configSection = (ConfigSection)this.sections.get(n);
            ConfigSectionContainer configSectionContainer = new ConfigSectionContainer(configSection);
            configSectionContainer.setAlignmentX(0.0f);
            jPanel.add(configSectionContainer);
            ++n;
        }
        this.add((Component)jPanel, "First");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.refreshBtn) {
            this.refresh(true);
        }
    }

    public void refresh(boolean bl) {
        int n = 0;
        while (this.sections != null && n < this.sections.size()) {
            ConfigSection configSection = (ConfigSection)this.sections.get(n);
            configSection.refresh(bl);
            ++n;
        }
    }

    public ArrayList getSections() {
        return this.sections;
    }

    public void addSection(ConfigSection configSection) {
        if (this.sections == null) {
            this.sections = new ArrayList();
        }
        this.sections.add(configSection);
    }

    public abstract void initSections();
}

