/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.reports;

import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.server.guireq.fabric.reports.RespPortConnections;

public class PortConnectionsAdjuster
extends CustomReportDataAdjuster {
    private static final String FABRIC_ID = Util.getString("FabricDetails_FabricID");
    private static final String SWITCH_ID = Util.getString("FabricDetails_switch");
    private static final String SWITCH_PORT = Util.getString("FabricSwitchPort");
    private static final String SWITCH_PORT_STATE = Util.getString("FabricSwitchPortState");
    private static final String CONNECTION_STATE = Util.getString("FabricConnectionState");
    private static final String CONNECTED_PORT = Util.getString("FabricConnectedPort");
    private static final String CONNECTED_PORT_STATE = Util.getString("FabricConnectedPortState");
    private static final String DEVICE = Util.getString("FabricDevice");
    private static final String DEVICE_STATE = Util.getString("FabricDeviceState");
    public String[] colNames = new String[]{FABRIC_ID, SWITCH_ID, SWITCH_PORT, SWITCH_PORT_STATE, CONNECTION_STATE, CONNECTED_PORT, CONNECTED_PORT_STATE, DEVICE, DEVICE_STATE};
    public static final int FABRIC_ID_COL = 0;
    public static final int SWITCH_ID_COL = 1;
    public static final int SWITCH_PORT_COL = 2;
    public static final int SWITCH_PORT_STATE_COL = 3;
    public static final int CONNECTION_STATE_COL = 4;
    public static final int CONNECTED_PORT_COL = 5;
    public static final int CONNECTED_PORT_STATE_COL = 6;
    public static final int DEVICE_COL = 7;
    public static final int DEVICE_STATE_COL = 8;
    private GuiReportReq grr;
    private RespPortConnections[] data;
    private MutableInteger[] mInt;
    private int[] rendererArray;
    private int rows;
    public int frozenRows;
    public int frozenLabels;
    public static final int FROZEN_LABEL_ROWS = 2;
    public static final int FROZEN_ROWS = 2;
    public static final int FROZEN_COLUMNS = 0;
    private boolean batch;
    private ColumnPopulator populator;

    public PortConnectionsAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.populator = null;
        this.frozenColumns = 0;
        int n = 0;
        if (guiReportReq.reportSubtype == 104) {
            this.populator = new Port_Populator();
            this.frozenRows = 0;
            this.frozenLabels = 0;
            this.rendererArray = new int[this.colNames.length];
            n = 0;
            while (n < this.colNames.length) {
                this.rendererArray[n] = 0;
                ++n;
            }
        }
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.data = (RespPortConnections[])objectArray;
        this.rows = this.data.length;
        this.mInt = new MutableInteger[this.rows];
        int n = 0;
        while (n < this.rows) {
            this.mInt[n] = new MutableInteger();
            ++n;
        }
    }

    public void adjustData() {
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
    }

    public Object getArray() {
        return this.data;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int getNumberFrozenRows() {
        return 0;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }

    public int[] getSelectedIDs() {
        int[] nArray = new int[this.data.length];
        int n = 0;
        while (n < this.data.length) {
            RespPortConnections cfr_ignored_0 = this.data[n];
            ++n;
        }
        return nArray;
    }

    public Object getCellData(int n, int n2) {
        return this.populator.getCellData(n, n2);
    }

    private static interface ColumnPopulator {
        public Object getCellData(int var1, int var2);
    }

    private class Port_Populator
    implements ColumnPopulator {
        private Port_Populator() {
        }

        public Object getCellData(int n, int n2) {
            RespPortConnections cfr_ignored_0 = PortConnectionsAdjuster.this.data[n];
            Object object = null;
            switch (n2) {
                case 0: {
                    object = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[n].FabricID;
                    break;
                }
                case 1: {
                    object = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[n].SwitchID;
                    break;
                }
                case 2: {
                    object = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[n].Switch_Port;
                    break;
                }
                case 3: {
                    ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[n].value = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[n].Switch_Port_State;
                    object = FabricGuiUtil.getStatusString(((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[n].value);
                    break;
                }
                case 4: {
                    ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[n].value = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[n].Connection_State;
                    object = FabricGuiUtil.getStatusString(((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[n].value);
                    break;
                }
                case 5: {
                    object = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[n].Connected_Port;
                    break;
                }
                case 6: {
                    ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[n].value = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[n].Connected_Port_State;
                    object = FabricGuiUtil.getStatusString(((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[n].value);
                    break;
                }
                case 7: {
                    object = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[n].Device;
                    break;
                }
                case 8: {
                    ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[n].value = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[n].Device_State;
                    object = FabricGuiUtil.getStatusString(((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[n].value);
                }
            }
            return object;
        }
    }
}

