/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.aperi.gui.TCloseTabPane;
import org.eclipse.aperi.gui.TabCloseListener;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.FabricTablePanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneConfigurationPanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneDDI;
import org.eclipse.aperi.gui.fabric.zone.ZoneDefinitionPanel;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class ZoneControlTabbedPane
extends TCloseTabPane
implements TabCloseListener {
    ZoneDDI zoneDDI = null;
    FabricTablePanel fabricPanel = null;
    public static int fabricPanelInt = 0;
    ZoneConfigurationPanel zc;
    HashMap[] sans = null;
    private HashMap zoneConfigTabs = new HashMap();
    private HashMap zoneDefTabs = new HashMap();
    private HashMap tabCounter = new HashMap();
    private HashMap tabPanelTracker = new HashMap();
    private HashMap tabLabelTracker = new HashMap();

    public ZoneControlTabbedPane(ZoneDDI zoneDDI) {
        this.zoneDDI = zoneDDI;
    }

    public boolean closeTab(int n) {
        this.setTabsCounter();
        String string = this.getTabWWN(n);
        String string2 = string.substring(0, 2);
        String string3 = string.substring(2);
        if (string2.equalsIgnoreCase("D:") && this.zoneDefTabs.containsKey(string3)) {
            ZoneDefinitionPanel zoneDefinitionPanel = (ZoneDefinitionPanel)this.zoneDefTabs.get(string3);
            this.removeZoneDefTab(string3, zoneDefinitionPanel.getSanLabel());
        } else if (string2.equalsIgnoreCase("C:") && this.zoneConfigTabs.containsKey(string3)) {
            ZoneConfigurationPanel zoneConfigurationPanel = (ZoneConfigurationPanel)this.zoneConfigTabs.get(string3);
            this.removeZoneConfigTab(string3, zoneConfigurationPanel.getSanLabel());
        }
        return true;
    }

    public void refreshConfigurationPanel(String string) {
        if (this.zoneConfigTabs.containsKey(string)) {
            ((ZoneConfigurationPanel)this.zoneConfigTabs.get(string)).refreshZoneConfigTab();
        }
    }

    public int getConfigTabIndex(String string, String string2) {
        String string3 = this.getConfigTabLabel(string2);
        this.setTabsCounter();
        return (Integer)this.tabCounter.get(string3);
    }

    public int getDefTabIndex(String string, String string2) {
        String string3 = this.getDefTabLabel(string2);
        this.setTabsCounter();
        return (Integer)this.tabCounter.get(string3);
    }

    public void refreshDefinitionPanel(String string) {
        if (this.zoneDefTabs.containsKey(string)) {
            ((ZoneDefinitionPanel)this.zoneDefTabs.get(string)).refreshDefPanel();
        }
    }

    public boolean isDefinitionPanelOpened(String string) {
        return this.zoneDefTabs.containsKey(string);
    }

    public void bringDefinitionPanelToFront(String string) {
        ZoneCNS zoneCNS = ((ZoneConfigurationPanel)this.zoneConfigTabs.get(string)).getZoneCNS();
        String string2 = this.getDefTabLabel(zoneCNS.getSanLabel());
        Integer n = (Integer)this.tabCounter.get(string2);
        this.setSelectedIndex(n);
    }

    public void addZoneDefTab(String string) {
        Serializable serializable;
        ZoneCNS zoneCNS = ((ZoneConfigurationPanel)this.zoneConfigTabs.get(string)).getZoneCNS();
        String string2 = this.getDefTabLabel(zoneCNS.getSanLabel());
        if (this.zoneConfigTabs.containsKey(string) && !this.zoneDefTabs.containsKey(string)) {
            serializable = new ZoneDefinitionPanel(zoneCNS);
            this.zoneDefTabs.put(string, serializable);
            this.addTab(string2, (Component)serializable, string2, true);
            this.tabLabelTracker.put(string2, "D:" + string);
        } else {
            this.refreshDefinitionPanel(string);
        }
        this.setTabsCounter();
        serializable = (Integer)this.tabCounter.get(string2);
        this.setSelectedIndex((Integer)serializable);
    }

    private void setTabsCounter() {
        int n = this.getTabCount();
        this.tabCounter = new HashMap();
        this.tabPanelTracker = new HashMap();
        int n2 = 0;
        while (n2 < n) {
            String string = this.getTitleAt(n2);
            Integer n3 = new Integer(n2);
            if (this.tabLabelTracker.containsKey(string)) {
                this.tabPanelTracker.put(n3, this.tabLabelTracker.get(string));
            }
            this.tabCounter.put(string, n3);
            ++n2;
        }
    }

    private void showPanel() {
        this.zoneDDI.show();
    }

    public void addZoneConfigTab(String string, String string2) {
        String string3;
        if (this.zoneConfigTabs.containsKey(string)) {
            this.refreshConfigurationPanel(string);
            ZoneCNS zoneCNS = ((ZoneConfigurationPanel)this.zoneConfigTabs.get((Object)string)).zoneCNS;
            string3 = this.getConfigTabLabel(zoneCNS.getSanLabel());
        } else {
            ZoneCNS zoneCNS;
            if (this.zoneDefTabs.containsKey(string)) {
                zoneCNS = ((ZoneDefinitionPanel)this.zoneDefTabs.get((Object)string)).zoneCNS;
                string3 = this.getConfigTabLabel(zoneCNS.getSanLabel());
            } else {
                zoneCNS = new ZoneCNS(this.zoneDDI, string2, string);
                string3 = this.getConfigTabLabel(zoneCNS.getSanLabel());
                zoneCNS.populateZoneDefinition();
                zoneCNS.ping(true);
            }
            ZoneConfigurationPanel zoneConfigurationPanel = new ZoneConfigurationPanel(zoneCNS);
            this.zoneConfigTabs.put(string, zoneConfigurationPanel);
            this.addTab(string3, zoneConfigurationPanel, string3, true);
            this.tabLabelTracker.put(string3, "C:" + string);
        }
        this.setTabsCounter();
        this.setSelectedIndex((Integer)this.tabCounter.get(string3));
    }

    public void removeZoneDefTab(String string, String string2) {
        if (this.zoneDefTabs.containsKey(string)) {
            ZoneDefinitionPanel zoneDefinitionPanel = (ZoneDefinitionPanel)this.zoneDefTabs.get(string);
            zoneDefinitionPanel.cleanOnExit();
            String string3 = this.getDefTabLabel(string2);
            this.setTabsCounter();
            ((Integer)this.tabCounter.get(string3)).intValue();
            this.zoneDefTabs.remove(string);
            this.tabLabelTracker.remove(string3);
            this.setTabsCounter();
        }
    }

    public void removeZoneConfigTab(String string, String string2) {
        if (this.zoneConfigTabs.containsKey(string)) {
            String string3 = this.getConfigTabLabel(string2);
            this.setTabsCounter();
            ((Integer)this.tabCounter.get(string3)).intValue();
            this.zoneConfigTabs.remove(string);
            this.tabLabelTracker.remove(string3);
            this.setTabsCounter();
        }
    }

    private String getConfigTabLabel(String string) {
        return IntlMessageFormat.format(FabricGuiUtil.getString("FabricZone_ZoningTabTitle"), new Object[]{string});
    }

    private String getDefTabLabel(String string) {
        return IntlMessageFormat.format(FabricGuiUtil.getString("FabricZone_DefTabTitle"), new Object[]{string});
    }

    private String getTabWWN(int n) {
        String string = "";
        Integer n2 = new Integer(n);
        if (this.tabPanelTracker.containsKey(n2)) {
            return (String)this.tabPanelTracker.get(n2);
        }
        return string;
    }

    public void enableEditButton(boolean bl, String string) {
        try {
            if (this.zoneConfigTabs.containsKey(string)) {
                ((ZoneConfigurationPanel)this.zoneConfigTabs.get(string)).enableEditButton(bl);
            }
        }
        catch (Exception exception) {}
    }

    public void enableRefreshButton(boolean bl, String string) {
        try {
            if (this.zoneConfigTabs.containsKey(string)) {
                ((ZoneConfigurationPanel)this.zoneConfigTabs.get(string)).enableRefreshButton(bl);
            }
        }
        catch (Exception exception) {}
    }

    public void reinitialize() {
        this.removeAll();
        this.addFirstTab(this.sans);
    }

    public void addFirstTab(HashMap[] hashMapArray) {
        String string = FabricGuiUtil.getString("Fabric_TabTitle");
        this.fabricPanel = new FabricTablePanel(hashMapArray, this);
        this.addTab(string, this.fabricPanel, string, false);
        this.setSelectedIndex(fabricPanelInt);
    }

    public void refreshSanTab(HashMap[] hashMapArray) {
        this.fabricPanel.refreshTable(hashMapArray);
    }

    public void setStatusText(String string, String string2) {
        try {
            if (this.zoneConfigTabs.containsKey(string2)) {
                ((ZoneConfigurationPanel)this.zoneConfigTabs.get(string2)).setStatusText(string);
            }
        }
        catch (Exception exception) {}
    }

    public void closeAllDefinitionTabs() {
        Collection collection = this.zoneDefTabs.values();
        for (ZoneDefinitionPanel zoneDefinitionPanel : collection) {
            this.removeZoneDefTab(zoneDefinitionPanel.getSanWWN(), zoneDefinitionPanel.getSanLabel());
        }
    }
}

