/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.eclipse.aperi.gui.topo.model.GraphEntity;

public class GraphGroupKey
implements Serializable,
Comparable {
    private static final long serialVersionUID = 954179934951093193L;
    protected Vector keyV = new Vector();

    public GraphGroupKey() {
        this(null);
    }

    public GraphGroupKey(GraphGroupKey graphGroupKey) {
        if (graphGroupKey != null) {
            Vector vector = graphGroupKey.getKeys();
            int n = 0;
            while (n < vector.size()) {
                Key key = (Key)vector.elementAt(n);
                this.addKey(key);
                ++n;
            }
        }
    }

    public String getID() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.keyV.size()) {
            if (n != 0) {
                stringBuffer.append("+");
            }
            Key key = (Key)this.keyV.elementAt(n);
            stringBuffer.append(key.getMethodValue());
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.keyV.size()) {
            if (n != 0) {
                stringBuffer.append("+");
            }
            Key key = (Key)this.keyV.elementAt(n);
            stringBuffer.append(key.getMethodValueAlias());
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getFullLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.keyV.size()) {
            if (n != 0) {
                stringBuffer.append("+");
            }
            Key key = (Key)this.keyV.elementAt(n);
            stringBuffer.append(String.valueOf(key.getMethodName()) + ":" + key.getMethodValueAlias());
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GraphGroupKeys{");
        int n = 0;
        while (n < this.keyV.size()) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            Key key = (Key)this.keyV.elementAt(n);
            stringBuffer.append(key);
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new GraphGroupKey(this);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof GraphGroupKey)) {
            return false;
        }
        GraphGroupKey graphGroupKey = (GraphGroupKey)object;
        Vector vector = graphGroupKey.getKeys();
        if (this.keyV.size() != vector.size()) {
            return false;
        }
        int n = 0;
        while (n < this.keyV.size()) {
            Key key;
            Key key2 = (Key)this.keyV.elementAt(n);
            if (!key2.equals(key = (Key)vector.elementAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.keyV.size()) {
            Key key = (Key)this.keyV.elementAt(n2);
            n += key.hashCode();
            ++n2;
        }
        return n;
    }

    public int compareTo(Object object) {
        GraphGroupKey graphGroupKey = (GraphGroupKey)object;
        int n = 0;
        int n2 = 0;
        while (n2 < this.keyV.size()) {
            Key key;
            Key key2 = (Key)this.keyV.elementAt(n2);
            n = key2.compareTo(key = (Key)graphGroupKey.getKeys().elementAt(n2));
            if (n != 0) break;
            ++n2;
        }
        return n;
    }

    public Vector getKeys() {
        return this.keyV;
    }

    public Key getKey(int n) {
        return (Key)this.keyV.elementAt(n);
    }

    public void addKey(Key key) {
        this.keyV.add(key);
    }

    public boolean isEmpty() {
        return this.keyV.isEmpty();
    }

    public static class Key
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 8708454488706893568L;
        protected String methodName;
        protected Comparable methodValue;
        protected String methodValueAlias;
        protected GraphEntity entity;
        protected ImageIcon iconSelected;
        protected ImageIcon iconUnselected;

        public Key(String string, Comparable comparable) {
            this(string, comparable, comparable.toString());
        }

        public Key(String string, Comparable comparable, String string2) {
            this.methodName = string;
            this.methodValue = comparable;
            this.methodValueAlias = string2;
        }

        public String toString() {
            return "(" + this.methodName + "," + this.methodValue + "," + this.entity + ")";
        }

        public Object clone() {
            Key key = new Key(this.methodName, this.methodValue, this.methodValueAlias);
            key.setJumping(this.entity, this.iconSelected, this.iconUnselected);
            return key;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            if (!this.methodName.equals(key.getMethodName())) {
                return false;
            }
            return this.methodValue.equals(key.getMethodValue());
        }

        public int hashCode() {
            return this.methodName.hashCode() + this.methodValue.hashCode();
        }

        public int compareTo(Object object) {
            Key key = (Key)object;
            return this.methodValue.compareTo(key.getMethodValue());
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Comparable getMethodValue() {
            return this.methodValue;
        }

        public String getMethodValueAlias() {
            return this.methodValueAlias;
        }

        public GraphEntity getJumpingEntity() {
            return this.entity;
        }

        public ImageIcon getIconSelected() {
            return this.iconSelected;
        }

        public ImageIcon getIconUnselected() {
            return this.iconUnselected;
        }

        public void setJumping(GraphEntity graphEntity, ImageIcon imageIcon, ImageIcon imageIcon2) {
            this.entity = graphEntity;
            this.iconSelected = imageIcon;
            this.iconUnselected = imageIcon2;
            graphEntity.setCollationKey(null);
        }
    }
}

