/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JLabel;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoUnit;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public abstract class AbstractJTopoSummary
extends AbstractJTopoUnit {
    protected Vector summaryLabelV = new Vector();

    protected AbstractJTopoSummary() {
        this((ITopoGroupModel)null, true);
    }

    protected AbstractJTopoSummary(ITopoGroupModel iTopoGroupModel, boolean bl) {
        super(iTopoGroupModel, bl);
        this.initState();
    }

    private void initState() {
        this.summaryLabelV.clear();
        this.removeAll();
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    protected Object createWidgetModel() {
        return new DefaultTopoGroupModel();
    }

    public void modelChanged() {
        this.modelChanged_setSummary();
        super.modelChanged();
    }

    protected void modelChanged_setSummary() {
        JLabel jLabel;
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        Vector vector = iTopoGroupModel.getSummaries();
        int n = this.summaryLabelV.size();
        int n2 = vector.size();
        int n3 = n;
        while (n3 > n2) {
            jLabel = (JLabel)this.summaryLabelV.remove(n3 - 1);
            this.remove(jLabel);
            --n3;
        }
        n3 = n;
        while (n3 < n2) {
            jLabel = new JLabel();
            jLabel.setFont(TopoResource.FONT_PLAIN);
            this.summaryLabelV.add(jLabel);
            this.add(jLabel);
            ++n3;
        }
        TopoSetting topoSetting = this.canvas.getControllerView().getControllerApp().getTopoSetting();
        int n4 = topoSetting.getFilteringLevel();
        int n5 = 0;
        while (n5 < n2) {
            Object object;
            ITopoGroupModel.Summary summary = (ITopoGroupModel.Summary)vector.elementAt(n5);
            String string = this.modelChanged_setSummary_helper(summary, n4);
            ITopoGroupModel.Summary summary2 = summary.getAuxSummary();
            if (summary2 != null) {
                object = this.modelChanged_setSummary_helper(summary2, n4);
                string = String.valueOf(string) + " (" + (String)object + ")";
            }
            object = (JLabel)this.summaryLabelV.elementAt(n5);
            ((JLabel)object).setText(string);
            ++n5;
        }
    }

    protected String modelChanged_setSummary_helper(ITopoGroupModel.Summary summary, int n) {
        int n2 = summary.getTotal();
        int n3 = summary.getUnfiltered();
        String string = summary.getTypeSingle();
        String string2 = summary.getTypePlural();
        StringBuffer stringBuffer = new StringBuffer();
        if (n != 0) {
            stringBuffer.append(n3);
            stringBuffer.append(" / ");
        }
        stringBuffer.append(n2);
        stringBuffer.append(" ");
        if (n2 == 1) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public Vector getSummaries() {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        return iTopoGroupModel.getSummaries();
    }

    public void setSummaries(Vector vector) {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        iTopoGroupModel.setSummaries(vector);
    }

    public void addSummary(ITopoGroupModel.Summary summary) {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        iTopoGroupModel.addSummary(summary);
    }

    public void removeSummary(ITopoGroupModel.Summary summary) {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        iTopoGroupModel.removeSummary(summary);
    }

    public void removeAllSummaries() {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        iTopoGroupModel.removeAllSummaries();
    }

    public void setOverlayHealthEnabled(boolean bl) {
    }

    public void setOverlayPerfEnabled(boolean bl) {
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord arrangeRecord) {
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    extends TopoLayoutUtilities.VerticalLayout {
        public DefaultLayout() {
            this.setSpacing(5);
            this.setMargin(5);
        }
    }
}

