/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoTableColumnModel;
import org.eclipse.aperi.gui.topo.widget.JCustomRendererTable;

public class DefaultTopoTableModel
extends AbstractTableModel {
    protected DefaultTopoTableColumnModel columnModel;
    protected RootNode rootNode;

    public DefaultTopoTableModel(DefaultTopoTableColumnModel defaultTopoTableColumnModel) {
        this.columnModel = defaultTopoTableColumnModel;
        this.rootNode = new RootNode();
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }

    public int getRowCount() {
        return this.rootNode.getRowCount();
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public Object getValueAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        MemberNode memberNode = this.findMemberNode(n);
        Object var4_4 = null;
        if (memberNode != null) {
            Vector cfr_ignored_0 = memberNode.dataV;
            return memberNode.getData(n2);
        }
        return var4_4;
    }

    public String getColumnName(int n) {
        TableColumn tableColumn = this.columnModel.getColumn(n);
        return tableColumn.getHeaderValue().toString();
    }

    public Class getColumnClass(int n) {
        TableColumn tableColumn = this.columnModel.getColumn(n);
        return tableColumn.getClass();
    }

    public void removeAll() {
        this.rootNode = new RootNode();
    }

    public void setValueAt(Object object, int n, int n2) {
        MemberNode memberNode = this.findMemberNode(n);
        if (memberNode != null) {
            memberNode.setData(n2, object);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void resetRowIndex() {
        this.rootNode.resetRowIndex();
    }

    public void sort(int n, boolean bl) {
        this.rootNode.sort(n, bl);
    }

    public MemberNode findMemberNode(int n) {
        return this.rootNode.findMemberNode(n);
    }

    public MemberNode findMemberNode(GraphEntity.ID iD) {
        if (iD == null) {
            return null;
        }
        return this.rootNode.findMemberNode(iD);
    }

    public Object findData(int n, int n2) {
        MemberNode memberNode = this.findMemberNode(n);
        return memberNode.getData(n2);
    }

    public void setSelectedAllMembers(boolean bl) {
        this.rootNode.setSelectedAllMembers(bl);
    }

    public void collapseAll(boolean bl) {
        this.collapseAll_helper(this.rootNode, bl);
        this.resetRowIndex();
        this.fireTableDataChanged();
    }

    protected void collapseAll_helper(GroupNode groupNode, boolean bl) {
        Vector vector = groupNode.getMemberVector();
        int n = 0;
        while (n < vector.size()) {
            MemberNode memberNode = (MemberNode)vector.elementAt(n);
            if (memberNode instanceof GroupNode) {
                GroupNode groupNode2 = (GroupNode)memberNode;
                groupNode2.setCollapse(bl);
                this.collapseAll_helper(groupNode2, bl);
            }
            ++n;
        }
    }

    public class GroupNode
    extends MemberNode {
        protected boolean isCollapsed;
        protected Vector memberV;

        public GroupNode(GraphEntity.ID iD) {
            super(iD);
            this.isCollapsed = true;
            this.memberV = new Vector();
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        public void setCollapse(boolean bl) {
            this.isCollapsed = bl;
        }

        public int getMemberCount() {
            return this.memberV.size();
        }

        public Vector getMemberVector() {
            return this.memberV;
        }

        public MemberNode getMember(int n) throws ArrayIndexOutOfBoundsException {
            if (n < 0 || n >= this.memberV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return (MemberNode)this.memberV.elementAt(n);
        }

        public void addMember(MemberNode memberNode) {
            memberNode.setParent(this);
            memberNode.setLevel(this.level + 1);
            this.memberV.add(memberNode);
        }

        public void insertMember(int n, MemberNode memberNode) {
            if (n < 0 || n >= this.memberV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            memberNode.setParent(this);
            memberNode.setLevel(this.level + 1);
            this.memberV.insertElementAt(memberNode, n);
        }

        public void removeMember(int n) {
            if (n < 0 || n >= this.memberV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            MemberNode memberNode = (MemberNode)this.memberV.remove(n);
            if (memberNode != null) {
                memberNode.setParent(null);
                memberNode.setLevel(-1);
            }
        }

        public void setMember(int n, MemberNode memberNode) {
            if (n < 0 || n >= this.memberV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            memberNode.setParent(this);
            memberNode.setLevel(this.level + 1);
            this.memberV.setElementAt(memberNode, n);
        }

        public Object getData(int n) {
            if (n < 0 || n >= this.dataV.size()) {
                return null;
            }
            return this.dataV.elementAt(n);
        }

        public void setData(int n, Object object) {
            if (n < 0 || n >= this.dataV.size()) {
                return;
            }
            this.dataV.setElementAt(object, n);
        }

        public int getRowCount() {
            int n = 1;
            if (!this.isCollapsed) {
                int n2 = 0;
                while (n2 < this.memberV.size()) {
                    MemberNode memberNode = (MemberNode)this.memberV.elementAt(n2);
                    n += memberNode.getRowCount();
                    ++n2;
                }
            }
            return n;
        }

        public MemberNode findMemberNode(int n) {
            MemberNode memberNode = null;
            if (this.rowIndex == n) {
                memberNode = this;
            } else {
                int n2 = 0;
                while (n2 < this.memberV.size()) {
                    MemberNode memberNode2 = (MemberNode)this.memberV.elementAt(n2);
                    memberNode = memberNode2.findMemberNode(n);
                    if (memberNode != null) break;
                    ++n2;
                }
            }
            return memberNode;
        }

        public MemberNode findMemberNode(GraphEntity.ID iD) {
            if (iD == null) {
                return null;
            }
            MemberNode memberNode = null;
            if (this.ref != null && this.ref.equals(iD)) {
                memberNode = this;
            } else {
                int n = 0;
                while (n < this.memberV.size()) {
                    MemberNode memberNode2 = (MemberNode)this.memberV.elementAt(n);
                    memberNode = memberNode2.findMemberNode(iD);
                    if (memberNode != null) break;
                    ++n;
                }
            }
            return memberNode;
        }

        public int resetRowIndex(int n) {
            int n2 = n;
            this.setRowIndex(n2++);
            if (n == -1 || this.isCollapsed) {
                int n3 = 0;
                while (n3 < this.memberV.size()) {
                    MemberNode memberNode = (MemberNode)this.memberV.elementAt(n3);
                    if (memberNode instanceof GroupNode) {
                        GroupNode groupNode = (GroupNode)memberNode;
                        groupNode.resetRowIndex(-1);
                    } else {
                        memberNode.setRowIndex(-1);
                    }
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < this.memberV.size()) {
                    MemberNode memberNode = (MemberNode)this.memberV.elementAt(n4);
                    if (memberNode instanceof GroupNode) {
                        GroupNode groupNode = (GroupNode)memberNode;
                        n2 = groupNode.resetRowIndex(n2);
                    } else {
                        memberNode.setRowIndex(n2++);
                    }
                    ++n4;
                }
            }
            return n2;
        }

        public void setSelectedAllMembers(boolean bl) {
            int n = 0;
            while (n < this.memberV.size()) {
                MemberNode memberNode = (MemberNode)this.memberV.elementAt(n);
                memberNode.setSelected(bl);
                if (memberNode instanceof GroupNode) {
                    GroupNode groupNode = (GroupNode)memberNode;
                    groupNode.setSelectedAllMembers(bl);
                }
                ++n;
            }
        }

        public void sort(int n, boolean bl) {
            Collections.sort(this.memberV, new MemberNodeComparator(n, bl));
            int n2 = 0;
            while (n2 < this.memberV.size()) {
                MemberNode memberNode = (MemberNode)this.memberV.elementAt(n2);
                if (memberNode instanceof GroupNode) {
                    GroupNode groupNode = (GroupNode)memberNode;
                    groupNode.sort(n, bl);
                }
                ++n2;
            }
        }

        protected class MemberNodeComparator
        implements Comparator {
            private int sort_col;
            private boolean sort_asc;

            public MemberNodeComparator(int n, boolean bl) {
                this.sort_col = n;
                this.sort_asc = bl;
            }

            public int compare(Object object, Object object2) {
                int n = 0;
                JCustomRendererTable.CustomCell customCell = (JCustomRendererTable.CustomCell)((MemberNode)object).getData(this.sort_col);
                JCustomRendererTable.CustomCell customCell2 = (JCustomRendererTable.CustomCell)((MemberNode)object2).getData(this.sort_col);
                n = customCell != null && customCell2 != null ? customCell.compareTo(customCell2) : (customCell != null ? -1 : (customCell2 != null ? 1 : 0));
                if (!this.sort_asc) {
                    n = -n;
                }
                return n;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object == this) {
                    return true;
                }
                if (!(object instanceof MemberNodeComparator)) {
                    return false;
                }
                MemberNodeComparator memberNodeComparator = (MemberNodeComparator)object;
                return this.sort_col == memberNodeComparator.sort_col && this.sort_asc == memberNodeComparator.sort_asc;
            }
        }
    }

    public class MemberNode {
        protected GraphEntity.ID ref;
        protected boolean selected;
        protected Vector dataV;
        protected GroupNode parent;
        protected int rowIndex;
        protected int level;

        public MemberNode(GraphEntity.ID iD) {
            this.ref = iD;
            this.selected = false;
            this.dataV = new Vector();
            this.parent = null;
            this.rowIndex = -1;
            this.level = -1;
        }

        public GraphEntity.ID getRef() {
            return this.ref;
        }

        public void setRef(GraphEntity.ID iD) {
            this.ref = iD;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public int getDataCount() {
            return this.dataV.size();
        }

        public Vector getDataVector() {
            return this.dataV;
        }

        public Object getData(int n) {
            if (n < 0 || n >= this.dataV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.dataV.elementAt(n);
        }

        public void addData(Object object) {
            this.dataV.add(object);
        }

        public void insertData(int n, Object object) {
            if (n < 0 || n >= this.dataV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.dataV.insertElementAt(object, n);
        }

        public void removeData(int n) {
            if (n < 0 || n >= this.dataV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.dataV.remove(n);
        }

        public void setData(int n, Object object) {
            if (n < 0 || n >= this.dataV.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.dataV.setElementAt(object, n);
        }

        public GroupNode getParent() {
            return this.parent;
        }

        public void setParent(GroupNode groupNode) {
            this.parent = groupNode;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void setRowIndex(int n) {
            this.rowIndex = n;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int n) {
            this.level = n;
        }

        public int getRowCount() {
            return 1;
        }

        public boolean expand() {
            boolean bl = false;
            GroupNode groupNode = this.parent;
            while (groupNode != null) {
                if (groupNode.isCollapsed()) {
                    groupNode.setCollapse(false);
                    bl = true;
                }
                groupNode = groupNode.getParent();
            }
            return bl;
        }

        public MemberNode findMemberNode(int n) {
            return this.rowIndex == n ? this : null;
        }

        public MemberNode findMemberNode(GraphEntity.ID iD) {
            if (iD == null) {
                return null;
            }
            if (this.ref == null) {
                return null;
            }
            return this.ref.equals(iD) ? this : null;
        }
    }

    public class RootNode
    extends GroupNode {
        public RootNode() {
            super(null);
            this.isCollapsed = false;
            this.level = 0;
        }

        public int getRowCount() {
            return super.getRowCount() - 1;
        }

        public void resetRowIndex() {
            this.setRowIndex(-1);
            int n = 0;
            int n2 = 0;
            while (n2 < this.memberV.size()) {
                MemberNode memberNode = (MemberNode)this.memberV.elementAt(n2);
                if (memberNode instanceof GroupNode) {
                    GroupNode groupNode = (GroupNode)memberNode;
                    n = groupNode.resetRowIndex(n);
                } else {
                    memberNode.setRowIndex(n++);
                }
                ++n2;
            }
        }
    }
}

