/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewComputerL2Device;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSubview;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxLunGroup;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxVolumeGroup;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoSubviewComputerL2Device
extends AbstractJTopoSubview {
    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphSubviewComputerL2Device graphSubviewComputerL2Device = (GraphSubviewComputerL2Device)this.focusEntity;
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        iTopoGroupModel.setType(graphSubviewComputerL2Device.getDisplayName());
        iTopoGroupModel.setLabel(graphSubviewComputerL2Device.getDisplayName());
        iTopoGroupModel.setHealth(graphSubviewComputerL2Device.getHealthStatus());
        iTopoGroupModel.setIconSelected(TopoResource.ICON_VOLUMEGROUP_16_SELECTED);
        iTopoGroupModel.setIconUnselected(TopoResource.ICON_VOLUMEGROUP_16_UNSELECTED);
        iTopoGroupModel.setIconMissing(TopoResource.ICON_VOLUMEGROUP_16_MISSING);
        iTopoGroupModel.removeAllSummaries();
        int n = graphSubviewComputerL2Device.getNumOfLuns();
        int n2 = graphSubviewComputerL2Device.getNumOfAbnormalLuns();
        ITopoGroupModel.Summary summary = new ITopoGroupModel.Summary(n, n2, GuiUtil.getString("TOPO_LABEL_ENTITY_LUN"), GuiUtil.getString("TOPO_LABEL_ENTITY_LUNS"));
        iTopoGroupModel.addSummary(summary);
        int n3 = graphSubviewComputerL2Device.getNumOfVolumes();
        int n4 = graphSubviewComputerL2Device.getNumOfAbnormalVolumes();
        iTopoGroupModel.addSummary(new ITopoGroupModel.Summary(n3, n4, GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUME"), GuiUtil.getString("TOPO_LABEL_ENTITY_VOLUMES")));
        int n5 = n + n3;
        int n6 = n2 + n4;
        iTopoGroupModel.setTotalCount(n5);
        iTopoGroupModel.setUnfilteredCount(n6);
        iTopoGroupModel.setGroupKey(graphSubviewComputerL2Device.getGroupKey());
        iTopoGroupModel.fireModelChanged();
    }

    protected AbstractJTopoBox.ContainerPanel createContainerPanel(ITopoGroupModel iTopoGroupModel) {
        return new ContainerPanel((ITopoUnitModel)iTopoGroupModel);
    }

    protected class ContainerPanel
    extends AbstractJTopoBox.ContainerPanel {
        protected JPanel lunGroupPanel;
        protected JPanel volumeGroupPanel;

        public ContainerPanel(ITopoUnitModel iTopoUnitModel) {
            super(iTopoUnitModel);
            this.lunGroupPanel = new JPanel();
            this.lunGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            TopoLayoutUtilities.HorizontalLayout horizontalLayout = new TopoLayoutUtilities.HorizontalLayout();
            this.lunGroupPanel.setLayout(horizontalLayout);
            this.volumeGroupPanel = new JPanel();
            this.volumeGroupPanel.setBackground(TopoResource.COLOR_BACKGROUND);
            horizontalLayout = new TopoLayoutUtilities.HorizontalLayout();
            this.volumeGroupPanel.setLayout(horizontalLayout);
            this.initState();
        }

        private void initState() {
            this.add(this.lunGroupPanel);
            this.add(this.volumeGroupPanel);
            this.removeAllEntities();
        }

        public void resetState() {
            super.resetState();
            this.initState();
        }

        public void addEntity(AbstractJTopoEntity abstractJTopoEntity) {
            this.entityV.add(abstractJTopoEntity);
            if (abstractJTopoEntity instanceof JTopoBoxLunGroup) {
                this.lunGroupPanel.setVisible(true);
                this.lunGroupPanel.add(abstractJTopoEntity);
            } else if (abstractJTopoEntity instanceof JTopoBoxVolumeGroup) {
                this.volumeGroupPanel.setVisible(true);
                this.volumeGroupPanel.add(abstractJTopoEntity);
            }
        }

        public void removeEntity(AbstractJTopoEntity abstractJTopoEntity) {
            this.entityV.remove(abstractJTopoEntity);
            if (abstractJTopoEntity instanceof JTopoBoxLunGroup) {
                this.lunGroupPanel.remove(abstractJTopoEntity);
                this.lunGroupPanel.setVisible(this.lunGroupPanel.getComponentCount() > 0);
            } else if (abstractJTopoEntity instanceof JTopoBoxVolumeGroup) {
                this.volumeGroupPanel.remove(abstractJTopoEntity);
                this.volumeGroupPanel.setVisible(this.volumeGroupPanel.getComponentCount() > 0);
            }
        }

        public void removeAllEntities() {
            this.entityV.clear();
            this.lunGroupPanel.removeAll();
            this.lunGroupPanel.setVisible(false);
            this.volumeGroupPanel.removeAll();
            this.volumeGroupPanel.setVisible(false);
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        extends TopoLayoutUtilities.VerticalLayout {
            public DefaultLayout() {
                this.setMargin(15);
                this.setSpacing(10);
                this.setAlignment(0);
            }
        }
    }
}

