/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.JClosableTabbedPane;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.JTopoMiniMap;
import org.eclipse.aperi.gui.topo.widget.JTopoView;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoViewGroup
extends JClosableTabbedPane {
    protected JTopoApp topoApp;

    public JTopoViewGroup(JTopoApp jTopoApp) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoViewGroup, constructor");
        }
        this.topoApp = jTopoApp;
        this.addChangeListener(new CL_TabSelected());
        this.addPropertyChangeListener(new PCL_TabRemoveIconClicked());
    }

    public JTopoView getFocusedTopoView() {
        return (JTopoView)this.getSelectedComponent();
    }

    public void setFocusedTopoView(JTopoView jTopoView) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoViewGroup, setFocusedTopoView, topoView=" + jTopoView);
        }
        this.setSelectedComponent(jTopoView);
        this.reattachFocusedView();
    }

    protected void reattachFocusedView() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoViewGroup, reattachFocusedView");
        }
        JTopoView jTopoView = this.getFocusedTopoView();
        this.requestFocus();
        JInternalFrame jInternalFrame = this.topoApp.getMiniMapFrame();
        Container container = jInternalFrame.getContentPane();
        JTopoMiniMap jTopoMiniMap = jTopoView.getMiniMap();
        container.removeAll();
        container.add(jTopoMiniMap);
        String string = jTopoView.getTitle();
        this.setViewTitle(jTopoView, string);
        Integer n = jTopoView.getStatus();
        this.setViewStatus(jTopoView, n);
        jInternalFrame.validate();
        jInternalFrame.repaint();
    }

    public void addTopoView(JTopoView jTopoView) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoViewGroup, addTopoView, topoView=" + jTopoView);
        }
        this.add(jTopoView);
    }

    public void removeTopoView(JTopoView jTopoView) {
        int n;
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoViewGroup, removeTopoView, topoView=" + jTopoView);
        }
        if ((n = this.indexOfComponent(jTopoView)) != -1) {
            if (n == this.getTabCount() - 1) {
                --n;
            }
            this.remove(jTopoView);
            this.setSelectedIndex(n);
            this.reattachFocusedView();
        }
    }

    public void setViewTitle(JTopoView jTopoView, String string) {
        int n = this.indexOfComponent(jTopoView);
        if (n != -1) {
            this.setTitleAt(n, string);
            this.setToolTipTextAt(n, string);
            if ((JTopoView)this.getSelectedComponent() == jTopoView) {
                this.topoApp.getMiniMapFrame().setTitle(string);
            }
        }
    }

    public void setViewStatus(JTopoView jTopoView, Integer n) {
        ImageIcon imageIcon = TopoResource.getIconHealth(n);
        int n2 = this.indexOfComponent(jTopoView);
        if (n2 != -1) {
            this.setIconAt(n2, imageIcon);
            if ((JTopoView)this.getSelectedComponent() == jTopoView) {
                this.topoApp.getMiniMapFrame().setFrameIcon(imageIcon);
            }
        }
    }

    protected class CL_TabSelected
    implements ChangeListener {
        protected CL_TabSelected() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            GraphDebug.trace("JTopoViewGroup, CL_TabSelected, stateChanged()");
            JTopoViewGroup.this.reattachFocusedView();
        }
    }

    protected class PCL_TabRemoveIconClicked
    implements PropertyChangeListener {
        protected PCL_TabRemoveIconClicked() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(JClosableTabbedPane.PCL_TABREMOVEICONCLICKED)) {
                GraphDebug.trace("JTopoViewGroup, PCL_TabRemoveIconClicked, propertyChange(), propName=" + propertyChangeEvent.getPropertyName());
                int n = (Integer)propertyChangeEvent.getOldValue();
                JTopoView jTopoView = (JTopoView)JTopoViewGroup.this.getComponentAt(n);
                GraphModel.ID iD = jTopoView.getControllerView().getModelID();
                JTopoViewGroup.this.topoApp.getControllerApp().closeView(iD);
            }
        }
    }
}

