/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelPinList;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ControllerView;

public class PinList {
    private ControllerApp controllerApp;
    private GraphModelPinList dataModel = new GraphModelPinList();

    public void destruct() {
        this.dataModel = null;
    }

    public ControllerApp getControllerApp() {
        return this.controllerApp;
    }

    public GraphModel getModel() {
        return this.dataModel;
    }

    public void setSessionModel(ControllerApp controllerApp, GraphModelPinList graphModelPinList) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("PinList, setModel(), dataModel=" + graphModelPinList.toString());
        }
        this.controllerApp = controllerApp;
        this.dataModel = graphModelPinList;
        Enumeration enumeration = controllerApp.getControllerViews();
        while (enumeration.hasMoreElements()) {
            ControllerView controllerView = (ControllerView)enumeration.nextElement();
            controllerView.setPinList(this);
        }
    }

    public Vector getPins() {
        GraphModelPinList.ID iD = (GraphModelPinList.ID)this.dataModel.getModelID();
        Vector vector = iD.getChildFocusEntityIDs();
        return vector;
    }

    public boolean isInPinList(GraphEntity.ID iD) {
        GraphModelPinList.ID iD2 = (GraphModelPinList.ID)this.dataModel.getModelID();
        Vector vector = iD2.getChildFocusEntityIDs();
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            GraphEntity.ID iD3 = (GraphEntity.ID)vector.elementAt(n);
            if (iD3.equals(iD)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void addPins(Vector vector) {
        GraphModelPinList.ID iD = (GraphModelPinList.ID)this.dataModel.getModelID();
        iD.setPinsToBeAdded(vector);
        this.controllerApp.refreshView(iD);
    }

    public void removePins(Vector vector) {
        GraphModelPinList.ID iD = (GraphModelPinList.ID)this.dataModel.getModelID();
        iD.setPinsToBeRemoved(vector);
        this.controllerApp.refreshView(iD);
    }

    public void clearPinList() {
        GraphModelPinList.ID iD = (GraphModelPinList.ID)this.dataModel.getModelID();
        iD.setPinsToBeRemoved(iD.getChildFocusEntityIDs());
        this.controllerApp.refreshView(iD);
    }
}

