/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.guid.impl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.UUID;

public class GUIDImpl
implements Serializable {
    static final long serialVersionUID = -1100099098385751265L;
    private UUID jguid;

    public static GUIDImpl readGUID() {
        GUIDImpl gUIDImpl = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("../guid.txt"));
            String string = bufferedReader.readLine();
            gUIDImpl = new GUIDImpl(string);
        }
        catch (Exception exception) {
            gUIDImpl = null;
        }
        return gUIDImpl;
    }

    public GUIDImpl(UUID uUID) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String string = uUID.toString();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != '-') {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        String string3 = this.noDotsToJava15(string2);
        this.jguid = UUID.fromString(string3);
    }

    public GUIDImpl(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 47) {
            if ((n + 1) % 3 != 0) {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        String string2 = new String(stringBuffer);
        String string3 = this.noDotsToJava15(string2);
        this.jguid = UUID.fromString(string3);
    }

    public GUIDImpl(String string, int n) {
        String string2 = this.noDotsToJava15(string);
        this.jguid = UUID.fromString(string2);
    }

    public String toString() {
        String string = this.toNoDotString();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(string.charAt(n));
            if ((n + 1) % 2 == 0 && n != string.length() - 1) {
                stringBuffer.append('.');
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public String toNoDotString() {
        String string = this.jguid.toString();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '-') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public String toJava15String() {
        return this.jguid.toString();
    }

    public byte[] toByteArray() {
        String string = this.toNoDotString();
        byte[] byArray = new byte[16];
        int n = 0;
        while (n < 16) {
            byArray[n] = (byte)Integer.parseInt(string.substring(n * 2, n * 2 + 2), 16);
            ++n;
        }
        return byArray;
    }

    String noDotsToJava15(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 32) {
            stringBuffer.append(string.charAt(n));
            if (n == 7 || n == 11 || n == 15 || n == 19) {
                stringBuffer.append('-');
            }
            ++n;
        }
        return new String(stringBuffer);
    }
}

