/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DBPreparedStatement {
    DBConnection connection = null;
    PreparedStatement preparedStatement = null;
    ResultSetMetaData rsmd = null;
    private String sql;
    private static String className = DBPreparedStatement.class.getName();
    public static final int EXECUTE_FAILED = -3;
    public static final int SUCCESS_NO_INFO = -2;

    public DBPreparedStatement(PreparedStatement preparedStatement, DBConnection dBConnection) throws SQLException {
        if (preparedStatement == null || dBConnection == null) {
            throw new SQLException("DBPreparedStatement constructor called with null PreparedStatement or DBConnection");
        }
        this.preparedStatement = preparedStatement;
        this.connection = dBConnection;
    }

    public void close() throws SQLException {
        this.connection.removeFromPsCache(this);
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
    }

    public void addBatch() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.addBatch();
        }
    }

    public int[] executeBatch() throws SQLException {
        int[] nArray = null;
        String string = "executeBatch";
        String string2 = this.preparedStatement.toString();
        ILogger iLogger = DBConstants.getLogger();
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.entry(IRecordType.TYPE_INFO, string, string2);
        }
        if (this.preparedStatement != null) {
            this.connection.setTransactionActive(this.sql);
            nArray = this.preparedStatement.executeBatch();
        }
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return nArray;
    }

    public void clearBatch() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.clearBatch();
        }
    }

    public DBResultSet executeQuery() throws SQLException {
        DBResultSet dBResultSet = null;
        String string = "executeQuery";
        String string2 = String.valueOf(this.preparedStatement.toString()) + (this.sql != null ? ", " + this.sql : "");
        ILogger iLogger = DBConstants.getLogger();
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.entry(IRecordType.TYPE_INFO, string, string2);
        }
        this.connection.setTransactionActive(this.sql);
        ResultSet resultSet = this.preparedStatement.executeQuery();
        dBResultSet = new DBResultSet(resultSet, this);
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return dBResultSet;
    }

    public int executeUpdate() throws SQLException {
        int n = 0;
        String string = "executeUpdate";
        String string2 = String.valueOf(this.preparedStatement.toString()) + (this.sql != null ? ", " + this.sql : "");
        ILogger iLogger = DBConstants.getLogger();
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.entry(IRecordType.TYPE_INFO, string, string2);
        }
        this.connection.setTransactionActive(this.sql);
        n = this.preparedStatement.executeUpdate();
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return n;
    }

    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.preparedStatement.setNull(n, n2);
    }

    public void setShort(int n, short s) throws SQLException {
        this.preparedStatement.setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.preparedStatement.setInt(n, n2);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.preparedStatement.setDouble(n, d);
    }

    public void setLong(int n, long l) throws SQLException {
        this.preparedStatement.setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.preparedStatement.setFloat(n, f);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.preparedStatement.setBoolean(n, bl);
    }

    public void setString(int n, String string) throws SQLException {
        this.preparedStatement.setString(n, string);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.preparedStatement.setByte(n, by);
    }

    public void setByteArray(int n, byte[] byArray) throws SQLException {
        this.preparedStatement.setBytes(n, byArray);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.preparedStatement.setTimestamp(n, timestamp);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.preparedStatement.setDate(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.preparedStatement.setTime(n, time);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.preparedStatement.setClob(n, clob);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.preparedStatement.setBigDecimal(n, bigDecimal);
    }

    private ResultSetMetaData getMetaData() throws SQLException {
        if (this.rsmd == null) {
            this.rsmd = this.preparedStatement.getMetaData();
        }
        return this.rsmd;
    }

    public DBResultSet getGeneratedKeys() throws SQLException {
        ResultSet resultSet = null;
        DBResultSet dBResultSet = null;
        resultSet = this.preparedStatement.getGeneratedKeys();
        dBResultSet = new DBResultSet(resultSet, this);
        return dBResultSet;
    }

    protected void setSql(String string) {
        this.sql = string;
    }
}

