/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.eclipse.aperi.infrastructure.database.DBConnection;

public class SQLExceptionHelper {
    public static final String SQLSTATE_ROW_NOT_FOUND = "2000";

    public static boolean isDuplicateKeyViolation(DBConnection dBConnection, SQLException sQLException) throws SQLException {
        if (dBConnection == null) {
            throw new SQLException("Null connection provided to isDuplicateKeyViolation");
        }
        if (sQLException == null) {
            throw new SQLException("Null exception provided to isDuplicateKeyViolation");
        }
        String string = sQLException.getSQLState();
        return string != null && string.length() == 5 && string.charAt(0) == '2' && string.charAt(1) == '3';
    }

    public static boolean isRowNotFound(DBConnection dBConnection, SQLException sQLException) throws SQLException {
        if (dBConnection == null) {
            throw new SQLException("Null connection provided to isRowNotFound");
        }
        if (sQLException == null) {
            throw new SQLException("Null exception provided to isRowNotFound");
        }
        String string = sQLException.getSQLState();
        return string != null && string.equals(SQLSTATE_ROW_NOT_FOUND);
    }

    public static boolean isDeadlock(DBConnection dBConnection, SQLException sQLException) throws SQLException {
        if (dBConnection == null) {
            throw new SQLException("Null connection provided to isDeadlock");
        }
        if (sQLException == null) {
            throw new SQLException("Null exception provided to isDeadlock");
        }
        if (dBConnection.getConnection() == null) {
            throw new SQLException("Null SQL connection provided to isDeadlock");
        }
        DatabaseMetaData databaseMetaData = dBConnection.getConnection().getMetaData();
        if (databaseMetaData == null) {
            throw new SQLException("Invalid metadata returned for isDeadlock");
        }
        String string = databaseMetaData.getDatabaseProductName();
        int n = sQLException.getErrorCode();
        String string2 = sQLException.getSQLState();
        return string != null && (string.startsWith("Microsoft SQL Server") && n == 1205 || string.startsWith("DB2") && n == -911 || string.startsWith("Apache Derby") && string2 != null && string2.equals("40001") || string.startsWith("Oracle") && n == 60);
    }

    public static boolean isOutOfSpace(DBConnection dBConnection, SQLException sQLException) throws SQLException {
        if (dBConnection == null) {
            throw new SQLException("Null connection provided to isOutOfSpace");
        }
        if (sQLException == null) {
            throw new SQLException("Null exception provided to isOutOfSpace");
        }
        if (dBConnection.getConnection() == null) {
            throw new SQLException("Null SQL connection provided to isOutOfSpace");
        }
        DatabaseMetaData databaseMetaData = dBConnection.getConnection().getMetaData();
        if (databaseMetaData == null) {
            throw new SQLException("Invalid metadata returned for isOutOfSpace");
        }
        String string = databaseMetaData.getDatabaseProductName();
        String string2 = sQLException.getSQLState();
        int n = sQLException.getErrorCode();
        return string != null && (string.startsWith("DB2") && string2 != null && (string2.equals("57011") || string2.equals("58004")) || string.startsWith("Oracle") && string2 != null && string2.equals("72000") && n == 1653 || string.startsWith("Apache Derby") && string2 != null && string2.equals("XSDG1") || string.startsWith("Microsoft SQL Server") && string2 != null && string2.equals("01000") && n == 1105);
    }

    public static boolean isTransactionLogFull(DBConnection dBConnection, SQLException sQLException) throws SQLException {
        if (dBConnection == null) {
            throw new SQLException("Null connection provided to isTransactionLogFull");
        }
        if (sQLException == null) {
            throw new SQLException("Null exception provided to isTransactionLogFull");
        }
        if (dBConnection.getConnection() == null) {
            throw new SQLException("Null SQL connection provided to isTransactionLogFull");
        }
        DatabaseMetaData databaseMetaData = dBConnection.getConnection().getMetaData();
        if (databaseMetaData == null) {
            throw new SQLException("Invalid metadata returned for isTransactionLogFull");
        }
        String string = databaseMetaData.getDatabaseProductName();
        String string2 = sQLException.getSQLState();
        int n = sQLException.getErrorCode();
        return string != null && (string.startsWith("DB2") && string2 != null && string2.equals("57011") || string.startsWith("Oracle") && string2 != null && string2.equals("99999") && n == 30036 || string.startsWith("Apache Derby") && string2 != null && string2.equals("XSLA4") || string.startsWith("Microsoft SQL Server") && string2 != null && string2.equals("01000") && n == 9002);
    }

    public static boolean isDatabaseDown(DBConnection dBConnection, SQLException sQLException) throws SQLException {
        if (dBConnection == null) {
            throw new SQLException("Null connection provided to isDatabaseDown");
        }
        if (sQLException == null) {
            throw new SQLException("Null exception provided to isDatabaseDown");
        }
        if (dBConnection.getConnection() == null) {
            throw new SQLException("Null SQL connection provided to isDatabaseDown");
        }
        DatabaseMetaData databaseMetaData = dBConnection.getConnection().getMetaData();
        if (databaseMetaData == null) {
            throw new SQLException("Invalid metadata returned for isDatabaseDown");
        }
        String string = databaseMetaData.getDatabaseProductName();
        String string2 = sQLException.getSQLState();
        int n = sQLException.getErrorCode();
        return string != null && (string.startsWith("DB2") && string2 != null && string2.equals("55032") || string.startsWith("Oracle") && string2 == null && n == 0 || string.startsWith("Apache Derby") && string2 != null && string2.equals("XJ015") || string.startsWith("Microsoft SQL Server") && string2 != null && string2.equals("08S01") && n == 0);
    }

    public static boolean isConnectionLost(DBConnection dBConnection, SQLException sQLException) throws SQLException {
        if (dBConnection == null) {
            throw new SQLException("Null connection provided to isDatabaseDown");
        }
        if (sQLException == null) {
            throw new SQLException("Null exception provided to isDatabaseDown");
        }
        if (dBConnection.getConnection() == null) {
            throw new SQLException("Null SQL connection provided to isDatabaseDown");
        }
        DatabaseMetaData databaseMetaData = dBConnection.getConnection().getMetaData();
        if (databaseMetaData == null) {
            throw new SQLException("Invalid metadata returned for isDatabaseDown");
        }
        String string = databaseMetaData.getDatabaseProductName();
        String string2 = sQLException.getSQLState();
        int n = sQLException.getErrorCode();
        return string != null && (string.startsWith("Apache Derby") && string2 != null && string2.startsWith("0800") || string.startsWith("DB2") && n == -999999);
    }
}

