/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatDiskHistTable;

public class DiskHist
extends TStatDiskHistTable {
    public static DiskHistCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new DiskHistCursor(dBConnection, hashtable, vector);
    }

    public DiskHist() {
        this.clear();
    }

    public DiskHist(int n, Timestamp timestamp, String string, int n2, int n3, int n4, int n5, double d, int n6, int n7, double d2, int n8, int n9, int n10, double d3, double d4, short s) {
        this.clear();
        this.m_DiskId = n;
        this.m_StatisticTime = timestamp;
        this.m_StatisticType = string;
        this.m_PrimaryDefects = n2;
        this.m_GrownDefects = n3;
        this.m_RecovrdWrtErrs = n4;
        this.m_UnrecovrdWrtErrs = n5;
        this.m_BytesWritten = d;
        this.m_RecovrdRdErrs = n6;
        this.m_UnrecovrdRdErrs = n7;
        this.m_BytesRead = d2;
        this.m_RecovrdVfyErrs = n8;
        this.m_UnrecovrdVfyErrs = n9;
        this.m_NonMediumErrs = n10;
        this.m_Capacity = d3;
        this.m_FreeSpace = d4;
        this.m_Temperature = s;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_DiskId != Integer.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("DISK_ID"), String.valueOf(this.m_DiskId));
        }
        if (this.m_StatisticTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("STATISTIC_TIME"), this.m_StatisticTime);
        }
        if (this.m_StatisticType != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("STATISTIC_TYPE"), this.m_StatisticType);
        }
        if (this.m_PrimaryDefects != Integer.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("PRIMARY_DEFECTS"), String.valueOf(this.m_PrimaryDefects));
        }
        if (this.m_GrownDefects != Integer.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("GROWN_DEFECTS"), String.valueOf(this.m_GrownDefects));
        }
        if (this.m_RecovrdWrtErrs != Integer.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("RECOVRD_WRT_ERRS"), String.valueOf(this.m_RecovrdWrtErrs));
        }
        if (this.m_UnrecovrdWrtErrs != Integer.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("UNRECOVRD_WRT_ERRS"), String.valueOf(this.m_UnrecovrdWrtErrs));
        }
        if (this.m_BytesWritten != Double.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("BYTES_WRITTEN"), String.valueOf(this.m_BytesWritten));
        }
        if (this.m_RecovrdRdErrs != Integer.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("RECOVRD_RD_ERRS"), String.valueOf(this.m_RecovrdRdErrs));
        }
        if (this.m_UnrecovrdRdErrs != Integer.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("UNRECOVRD_RD_ERRS"), String.valueOf(this.m_UnrecovrdRdErrs));
        }
        if (this.m_BytesRead != Double.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("BYTES_READ"), String.valueOf(this.m_BytesRead));
        }
        if (this.m_RecovrdVfyErrs != Integer.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("RECOVRD_VFY_ERRS"), String.valueOf(this.m_RecovrdVfyErrs));
        }
        if (this.m_UnrecovrdVfyErrs != Integer.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("UNRECOVRD_VFY_ERRS"), String.valueOf(this.m_UnrecovrdVfyErrs));
        }
        if (this.m_NonMediumErrs != Integer.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("NON_MEDIUM_ERRS"), String.valueOf(this.m_NonMediumErrs));
        }
        if (this.m_Capacity != Double.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_FreeSpace != Double.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("FREE_SPACE"), String.valueOf(this.m_FreeSpace));
        }
        if (this.m_Temperature != Short.MIN_VALUE) {
            hashtable.put(DiskHist.getColumnInfo("TEMPERATURE"), String.valueOf(this.m_Temperature));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_DISK_HIST", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_DISK_HIST", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_DISK_HIST", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_DISK_HIST", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_DISK_HIST", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_DISK_HIST", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_STAT_DISK_HIST", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static DiskHist retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        DiskHist diskHist = null;
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_STAT_DISK_HIST", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                diskHist = new DiskHist();
                diskHist.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return diskHist;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_DISK_HIST", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_DISK_HIST", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setDiskId(dBResultSet.getInt("DISK_ID"));
        this.setStatisticTime(dBResultSet.getTimestamp("STATISTIC_TIME"));
        this.setStatisticType(dBResultSet.getString("STATISTIC_TYPE"));
        this.setPrimaryDefects(dBResultSet.getInt("PRIMARY_DEFECTS"));
        this.setGrownDefects(dBResultSet.getInt("GROWN_DEFECTS"));
        this.setRecovrdWrtErrs(dBResultSet.getInt("RECOVRD_WRT_ERRS"));
        this.setUnrecovrdWrtErrs(dBResultSet.getInt("UNRECOVRD_WRT_ERRS"));
        this.setBytesWritten(dBResultSet.getDouble("BYTES_WRITTEN"));
        this.setRecovrdRdErrs(dBResultSet.getInt("RECOVRD_RD_ERRS"));
        this.setUnrecovrdRdErrs(dBResultSet.getInt("UNRECOVRD_RD_ERRS"));
        this.setBytesRead(dBResultSet.getDouble("BYTES_READ"));
        this.setRecovrdVfyErrs(dBResultSet.getInt("RECOVRD_VFY_ERRS"));
        this.setUnrecovrdVfyErrs(dBResultSet.getInt("UNRECOVRD_VFY_ERRS"));
        this.setNonMediumErrs(dBResultSet.getInt("NON_MEDIUM_ERRS"));
        this.setCapacity(dBResultSet.getDouble("CAPACITY"));
        this.setFreeSpace(dBResultSet.getDouble("FREE_SPACE"));
        this.setTemperature(dBResultSet.getShort("TEMPERATURE"));
    }

    public static class DiskHistCursor
    extends DBCursor {
        private DiskHist element = new DiskHist();
        private DBConnection con;

        public DiskHistCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_STAT_DISK_HIST", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public DiskHist getObject() throws SQLException {
            DiskHist diskHist = null;
            if (this.DBrs != null) {
                diskHist = new DiskHist();
                diskHist.setFields(this.con, this.DBrs);
            }
            return diskHist;
        }

        public DiskHist getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

