/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResHbaTable;

public class Hba
extends TResHbaTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String string) {
        this.m_VendorId_str = string;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String string) {
        this.m_ModelId_str = string;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static HbaCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new HbaCursor(dBConnection, hashtable, vector);
    }

    public Hba() {
        this.clear();
    }

    public Hba(short s, short s2, short s3, String string, int n, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n2, int n3, int n4, short s4, int n5, short s5, short s6, Timestamp timestamp) {
        this.clear();
        this.m_VendorId = s;
        this.m_ModelId = s2;
        this.m_ApiVersion = s3;
        this.m_HbaWwn = string;
        this.m_HbaId = n;
        this.m_Name = string2;
        this.m_SerialNumber = string3;
        this.m_DriverVersion = string4;
        this.m_DriverName = string5;
        this.m_RomVersion = string6;
        this.m_HwVersion = string7;
        this.m_FirmwareVersion = string8;
        this.m_HostId = n2;
        this.m_LparId = n3;
        this.m_IoEnclosureId = n4;
        this.m_Detectable = s4;
        this.m_OperationalStatus = n5;
        this.m_ConsolidatedStatus = s5;
        this.m_PropagatedStatus = s6;
        this.m_UpdateTimestamp = timestamp;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_VendorId != Short.MIN_VALUE) {
            hashtable.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            hashtable.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_ApiVersion != Short.MIN_VALUE) {
            hashtable.put(Hba.getColumnInfo("API_VERSION"), String.valueOf(this.m_ApiVersion));
        }
        if (this.m_HbaId != Integer.MIN_VALUE) {
            hashtable.put(Hba.getColumnInfo("HBA_ID"), String.valueOf(this.m_HbaId));
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Hba.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_DriverVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Hba.getColumnInfo("DRIVER_VERSION"), this.m_DriverVersion);
        }
        if (this.m_DriverName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Hba.getColumnInfo("DRIVER_NAME"), this.m_DriverName);
        }
        if (this.m_RomVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Hba.getColumnInfo("ROM_VERSION"), this.m_RomVersion);
        }
        if (this.m_HwVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Hba.getColumnInfo("HW_VERSION"), this.m_HwVersion);
        }
        if (this.m_FirmwareVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Hba.getColumnInfo("FIRMWARE_VERSION"), this.m_FirmwareVersion);
        }
        if (this.m_LparId != Integer.MIN_VALUE) {
            hashtable.put(Hba.getColumnInfo("LPAR_ID"), String.valueOf(this.m_LparId));
        }
        if (this.m_IoEnclosureId != Integer.MIN_VALUE) {
            hashtable.put(Hba.getColumnInfo("IO_ENCLOSURE_ID"), String.valueOf(this.m_IoEnclosureId));
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(Hba.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(Hba.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            hashtable.put(Hba.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            hashtable.put(Hba.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Hba.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_HbaWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key HBA_WWN not found");
        }
        this.htColsAndValues.put(Hba.getColumnInfo("HBA_WWN"), this.m_HbaWwn);
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htColsAndValues.put(Hba.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htColsAndValues.put(Hba.getColumnInfo("NAME"), this.m_Name);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_HBA", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(Hba.getColumnInfo("HBA_WWN")) == null) {
            throw new SQLException(" ERROR: key HBA_WWN not found");
        }
        if (hashtable.get(Hba.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        if (hashtable.get(Hba.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_HBA", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_HbaWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key HBA_WWN not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), this.m_HbaWwn);
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("NAME"), this.m_Name);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_HBA", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(Hba.getColumnInfo("HBA_WWN")) == null) {
            throw new SQLException(" ERROR: key HBA_WWN not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), hashtable.get(Hba.getColumnInfo("HBA_WWN")));
        if (hashtable.get(Hba.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HOST_ID"), hashtable.get(Hba.getColumnInfo("HOST_ID")));
        if (hashtable.get(Hba.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("NAME"), hashtable.get(Hba.getColumnInfo("NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_HBA", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_HbaWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key HBA_WWN not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), this.m_HbaWwn);
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("NAME"), this.m_Name);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_HBA", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(Hba.getColumnInfo("HBA_WWN")) == null) {
            throw new SQLException(" ERROR: key HBA_WWN not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), hashtable.get(Hba.getColumnInfo("HBA_WWN")));
        if (hashtable.get(Hba.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HOST_ID"), hashtable.get(Hba.getColumnInfo("HOST_ID")));
        if (hashtable.get(Hba.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("NAME"), hashtable.get(Hba.getColumnInfo("NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_HBA", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_HbaWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key HBA_WWN not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HBA_WWN"), this.m_HbaWwn);
        if (this.m_HostId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HOST_ID not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        if (this.m_Name == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key NAME not found");
        }
        this.htWhereClause.put(Hba.getColumnInfo("NAME"), this.m_Name);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_HBA", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Hba retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Hba hba = null;
        if (hashtable.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(Hba.getColumnInfo("HBA_WWN")) == null) {
            throw new SQLException(" ERROR: key HBA_WWN not found");
        }
        hashtable2.put(Hba.getColumnInfo("HBA_WWN"), hashtable.get(Hba.getColumnInfo("HBA_WWN")));
        if (hashtable.get(Hba.getColumnInfo("HOST_ID")) == null) {
            throw new SQLException(" ERROR: key HOST_ID not found");
        }
        hashtable2.put(Hba.getColumnInfo("HOST_ID"), hashtable.get(Hba.getColumnInfo("HOST_ID")));
        if (hashtable.get(Hba.getColumnInfo("NAME")) == null) {
            throw new SQLException(" ERROR: key NAME not found");
        }
        hashtable2.put(Hba.getColumnInfo("NAME"), hashtable.get(Hba.getColumnInfo("NAME")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_HBA", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                hba = new Hba();
                hba.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return hba;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable2.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            hashtable2.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable2.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable2.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            hashtable2.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable2.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_HBA", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(Hba.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_HBA", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setVendorId(dBResultSet.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(dBConnection, this.m_VendorId));
        this.setModelId(dBResultSet.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(dBConnection, this.m_ModelId));
        this.setApiVersion(dBResultSet.getShort("API_VERSION"));
        this.setHbaWwn(dBResultSet.getString("HBA_WWN"));
        this.setHbaId(dBResultSet.getInt("HBA_ID"));
        this.setName(dBResultSet.getString("NAME"));
        this.setSerialNumber(dBResultSet.getString("SERIAL_NUMBER"));
        this.setDriverVersion(dBResultSet.getString("DRIVER_VERSION"));
        this.setDriverName(dBResultSet.getString("DRIVER_NAME"));
        this.setRomVersion(dBResultSet.getString("ROM_VERSION"));
        this.setHwVersion(dBResultSet.getString("HW_VERSION"));
        this.setFirmwareVersion(dBResultSet.getString("FIRMWARE_VERSION"));
        this.setHostId(dBResultSet.getInt("HOST_ID"));
        this.setLparId(dBResultSet.getInt("LPAR_ID"));
        this.setIoEnclosureId(dBResultSet.getInt("IO_ENCLOSURE_ID"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(dBResultSet.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(dBResultSet.getShort("PROPAGATED_STATUS"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class HbaCursor
    extends DBCursor {
        private Hba element = new Hba();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(Hba.getColumnInfo("VENDOR_ID")) != null) {
                hashtable.put(Hba.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("VENDOR_ID")))));
            }
            if (hashtable.get(Hba.getColumnInfo("MODEL_ID")) != null) {
                hashtable.put(Hba.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(Hba.getColumnInfo("MODEL_ID")))));
            }
            return hashtable;
        }

        public HbaCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_HBA", dBConnection, HbaCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public Hba getObject() throws SQLException {
            Hba hba = null;
            if (this.DBrs != null) {
                hba = new Hba();
                hba.setFields(this.con, this.DBrs);
            }
            return hba;
        }

        public Hba getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

