/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResModelTable;

public class Model
extends TResModelTable {
    public static ModelCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new ModelCursor(dBConnection, hashtable, vector);
    }

    public Model() {
        this.clear();
    }

    public Model(short s, String string, String string2) {
        this.clear();
        this.m_ModelId = s;
        this.m_ModelName = string;
        this.m_ModelDescription = string2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_ModelId != Short.MIN_VALUE) {
            hashtable.put(Model.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_ModelDescription != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Model.getColumnInfo("MODEL_DESCRIPTION"), this.m_ModelDescription);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htColsAndValues.put(Model.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_MODEL", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Model.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_MODEL", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Model.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), hashtable.get(Model.getColumnInfo("MODEL_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Model.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), hashtable.get(Model.getColumnInfo("MODEL_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ModelName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key MODEL_NAME not found");
        }
        this.htWhereClause.put(Model.getColumnInfo("MODEL_NAME"), this.m_ModelName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_MODEL", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Model retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Model model = null;
        if (hashtable.get(Model.getColumnInfo("MODEL_NAME")) == null) {
            throw new SQLException(" ERROR: key MODEL_NAME not found");
        }
        hashtable2.put(Model.getColumnInfo("MODEL_NAME"), hashtable.get(Model.getColumnInfo("MODEL_NAME")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_MODEL", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                model = new Model();
                model.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return model;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_MODEL", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_MODEL", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setModelId(dBResultSet.getShort("MODEL_ID"));
        this.setModelName(dBResultSet.getString("MODEL_NAME"));
        this.setModelDescription(dBResultSet.getString("MODEL_DESCRIPTION"));
    }

    public static class ModelCursor
    extends DBCursor {
        private Model element = new Model();
        private DBConnection con;

        public ModelCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_MODEL", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public Model getObject() throws SQLException {
            Model model = null;
            if (this.DBrs != null) {
                model = new Model();
                model.setFields(this.con, this.DBrs);
            }
            return model;
        }

        public Model getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

