/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResPhyPeTable;

public class PhyPe
extends TResPhyPeTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String string) {
        this.m_VendorId_str = string;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String string) {
        this.m_ModelId_str = string;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static PhyPeCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new PhyPeCursor(dBConnection, hashtable, vector);
    }

    public PhyPe() {
        this.clear();
    }

    public PhyPe(int n, String string, String string2, short s, short s2, String string3, String string4, String string5, String string6, short s3, short s4, short s5, short s6, String string7, Timestamp timestamp, short s7) {
        this.clear();
        this.m_PhyPeId = n;
        this.m_PeName = string;
        this.m_SerialNumber = string2;
        this.m_VendorId = s;
        this.m_ModelId = s2;
        this.m_FirmwareRevision = string3;
        this.m_MgmtTelAddr = string4;
        this.m_MgmtSnmpAddr = string5;
        this.m_MgmtUrlAddr = string6;
        this.m_ScsiType = s3;
        this.m_PlatformType = s4;
        this.m_RnidType = s5;
        this.m_ScsiSupport = s6;
        this.m_DisplayName = string7;
        this.m_UpdateTimestamp = timestamp;
        this.m_Detectable = s7;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_PhyPeId != Integer.MIN_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("PHY_PE_ID"), String.valueOf(this.m_PhyPeId));
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_FirmwareRevision != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("FIRMWARE_REVISION"), this.m_FirmwareRevision);
        }
        if (this.m_MgmtTelAddr != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("MGMT_TEL_ADDR"), this.m_MgmtTelAddr);
        }
        if (this.m_MgmtSnmpAddr != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("MGMT_SNMP_ADDR"), this.m_MgmtSnmpAddr);
        }
        if (this.m_MgmtUrlAddr != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("MGMT_URL_ADDR"), this.m_MgmtUrlAddr);
        }
        if (this.m_ScsiType != Short.MIN_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("SCSI_TYPE"), String.valueOf(this.m_ScsiType));
        }
        if (this.m_PlatformType != Short.MIN_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("PLATFORM_TYPE"), String.valueOf(this.m_PlatformType));
        }
        if (this.m_RnidType != Short.MIN_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("RNID_TYPE"), String.valueOf(this.m_RnidType));
        }
        if (this.m_ScsiSupport != Short.MIN_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("SCSI_SUPPORT"), String.valueOf(this.m_ScsiSupport));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(PhyPe.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_PeName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key PE_NAME not found");
        }
        this.htColsAndValues.put(PhyPe.getColumnInfo("PE_NAME"), this.m_PeName);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_PHY_PE", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhyPe.getColumnInfo("PE_NAME")) == null) {
            throw new SQLException(" ERROR: key PE_NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_PHY_PE", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_PeName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key PE_NAME not found");
        }
        this.htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), this.m_PeName);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHY_PE", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhyPe.getColumnInfo("PE_NAME")) == null) {
            throw new SQLException(" ERROR: key PE_NAME not found");
        }
        this.htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), hashtable.get(PhyPe.getColumnInfo("PE_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHY_PE", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_PeName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key PE_NAME not found");
        }
        this.htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), this.m_PeName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHY_PE", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhyPe.getColumnInfo("PE_NAME")) == null) {
            throw new SQLException(" ERROR: key PE_NAME not found");
        }
        this.htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), hashtable.get(PhyPe.getColumnInfo("PE_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHY_PE", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_PeName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key PE_NAME not found");
        }
        this.htWhereClause.put(PhyPe.getColumnInfo("PE_NAME"), this.m_PeName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_PHY_PE", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static PhyPe retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        PhyPe phyPe = null;
        if (hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhyPe.getColumnInfo("PE_NAME")) == null) {
            throw new SQLException(" ERROR: key PE_NAME not found");
        }
        hashtable2.put(PhyPe.getColumnInfo("PE_NAME"), hashtable.get(PhyPe.getColumnInfo("PE_NAME")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_PHY_PE", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                phyPe = new PhyPe();
                phyPe.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return phyPe;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable2.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            hashtable2.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable2.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable2.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            hashtable2.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable2.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_PHY_PE", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_PHY_PE", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setPhyPeId(dBResultSet.getInt("PHY_PE_ID"));
        this.setPeName(dBResultSet.getString("PE_NAME"));
        this.setSerialNumber(dBResultSet.getString("SERIAL_NUMBER"));
        this.setVendorId(dBResultSet.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(dBConnection, this.m_VendorId));
        this.setModelId(dBResultSet.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(dBConnection, this.m_ModelId));
        this.setFirmwareRevision(dBResultSet.getString("FIRMWARE_REVISION"));
        this.setMgmtTelAddr(dBResultSet.getString("MGMT_TEL_ADDR"));
        this.setMgmtSnmpAddr(dBResultSet.getString("MGMT_SNMP_ADDR"));
        this.setMgmtUrlAddr(dBResultSet.getString("MGMT_URL_ADDR"));
        this.setScsiType(dBResultSet.getShort("SCSI_TYPE"));
        this.setPlatformType(dBResultSet.getShort("PLATFORM_TYPE"));
        this.setRnidType(dBResultSet.getShort("RNID_TYPE"));
        this.setScsiSupport(dBResultSet.getShort("SCSI_SUPPORT"));
        this.setDisplayName(dBResultSet.getString("DISPLAY_NAME"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
    }

    public static class PhyPeCursor
    extends DBCursor {
        private PhyPe element = new PhyPe();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")) != null) {
                hashtable.put(PhyPe.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("VENDOR_ID")))));
            }
            if (hashtable.get(PhyPe.getColumnInfo("MODEL_ID")) != null) {
                hashtable.put(PhyPe.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhyPe.getColumnInfo("MODEL_ID")))));
            }
            return hashtable;
        }

        public PhyPeCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_PHY_PE", dBConnection, PhyPeCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public PhyPe getObject() throws SQLException {
            PhyPe phyPe = null;
            if (this.DBrs != null) {
                phyPe = new PhyPe();
                phyPe.setFields(this.con, this.DBrs);
            }
            return phyPe;
        }

        public PhyPe getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

