/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;

public class PhysicalVolume
extends TResPhysicalVolumeTable {
    private String m_VendorId_str;
    private String m_ModelId_str;
    private String m_SystemCreationClassNameId_str;
    private String m_CreationClassNameId_str;
    private String m_SystemNamesId_str;

    public void setVendor(String string) {
        this.m_VendorId_str = string;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String string) {
        this.m_ModelId_str = string;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public void setSystemCreationClassName(String string) {
        this.m_SystemCreationClassNameId_str = string;
    }

    public String getSystemCreationClassName() {
        return this.m_SystemCreationClassNameId_str;
    }

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setSystemNames(String string) {
        this.m_SystemNamesId_str = string;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public static PhysicalVolumeCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new PhysicalVolumeCursor(dBConnection, hashtable, vector);
    }

    public PhysicalVolume() {
        this.clear();
    }

    public PhysicalVolume(int n, short s, short s2, String string, String string2, Timestamp timestamp, short s3, short s4, String string3, short s5, String string4, String string5, Timestamp timestamp2, short s6, int n2, Timestamp timestamp3, short s7, short s8, short s9, int n3, String string6, String string7, String string8, String string9, long l, String string10, short s10, int n4, short s11, String string11) {
        this.clear();
        this.m_PhysicalVolumeId = n;
        this.m_VendorId = s;
        this.m_ModelId = s2;
        this.m_SerialNumber = string;
        this.m_FirmwareRev = string2;
        this.m_ManufactureDate = timestamp;
        this.m_UseCount = s3;
        this.m_DeviceType = s4;
        this.m_UnsupportedModel = string3;
        this.m_Flags = s5;
        this.m_RemovableMedium = string4;
        this.m_MultiPort = string5;
        this.m_DiscoveredTime = timestamp2;
        this.m_StorageSystemType = s6;
        this.m_DiskGroupId = n2;
        this.m_UpdateTimestamp = timestamp3;
        this.m_SystemCreationClassNameId = s7;
        this.m_CreationClassNameId = s8;
        this.m_SystemNamesId = s9;
        this.m_SubsystemId = n3;
        this.m_DeviceId = string6;
        this.m_Name = string7;
        this.m_Tag = string8;
        this.m_DisplayName = string9;
        this.m_Capacity = l;
        this.m_SubsystemSerialNumber = string10;
        this.m_Detectable = s10;
        this.m_OperationalStatus = n4;
        this.m_ConsolidatedStatus = s11;
        this.m_Lunssid = string11;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_PhysicalVolumeId != Integer.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID"), String.valueOf(this.m_PhysicalVolumeId));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_FirmwareRev != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("FIRMWARE_REV"), this.m_FirmwareRev);
        }
        if (this.m_ManufactureDate != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("MANUFACTURE_DATE"), this.m_ManufactureDate);
        }
        if (this.m_UseCount != Short.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("USE_COUNT"), String.valueOf(this.m_UseCount));
        }
        if (this.m_DeviceType != Short.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("DEVICE_TYPE"), String.valueOf(this.m_DeviceType));
        }
        if (this.m_UnsupportedModel != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("UNSUPPORTED_MODEL"), this.m_UnsupportedModel);
        }
        if (this.m_Flags != Short.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("FLAGS"), String.valueOf(this.m_Flags));
        }
        if (this.m_RemovableMedium != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("REMOVABLE_MEDIUM"), this.m_RemovableMedium);
        }
        if (this.m_MultiPort != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("MULTI_PORT"), this.m_MultiPort);
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
        if (this.m_StorageSystemType != Short.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("STORAGE_SYSTEM_TYPE"), String.valueOf(this.m_StorageSystemType));
        }
        if (this.m_DiskGroupId != Integer.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("DISK_GROUP_ID"), String.valueOf(this.m_DiskGroupId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_SystemCreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(this.m_SystemCreationClassNameId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_Tag != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("TAG"), this.m_Tag);
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_Capacity != Long.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_SubsystemSerialNumber != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("SUBSYSTEM_SERIAL_NUMBER"), this.m_SubsystemSerialNumber);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_Lunssid != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(PhysicalVolume.getColumnInfo("LUNSSID"), this.m_Lunssid);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htColsAndValues.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htColsAndValues.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_PHYSICAL_VOLUME", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_PHYSICAL_VOLUME", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_VOLUME", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), hashtable.get(PhysicalVolume.getColumnInfo("DEVICE_ID")));
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_VOLUME", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_VOLUME", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), hashtable.get(PhysicalVolume.getColumnInfo("DEVICE_ID")));
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_VOLUME", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.m_SystemNamesId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key SYSTEM_NAMES_ID not found");
        }
        this.htWhereClause.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_PHYSICAL_VOLUME", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static PhysicalVolume retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        PhysicalVolume physicalVolume = null;
        if (hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        hashtable2.put(PhysicalVolume.getColumnInfo("DEVICE_ID"), hashtable.get(PhysicalVolume.getColumnInfo("DEVICE_ID")));
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) == null) {
            throw new SQLException(" ERROR: key SYSTEM_NAMES_ID not found");
        }
        hashtable2.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_PHYSICAL_VOLUME", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                physicalVolume = new PhysicalVolume();
                physicalVolume.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return physicalVolume;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable2.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            hashtable2.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable2.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable2.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            hashtable2.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable2.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable2.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable2.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable2.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable2.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_PHYSICAL_VOLUME", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_PHYSICAL_VOLUME", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setPhysicalVolumeId(dBResultSet.getInt("PHYSICAL_VOLUME_ID"));
        this.setVendorId(dBResultSet.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(dBConnection, this.m_VendorId));
        this.setModelId(dBResultSet.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(dBConnection, this.m_ModelId));
        this.setSerialNumber(dBResultSet.getString("SERIAL_NUMBER"));
        this.setFirmwareRev(dBResultSet.getString("FIRMWARE_REV"));
        this.setManufactureDate(dBResultSet.getTimestamp("MANUFACTURE_DATE"));
        this.setUseCount(dBResultSet.getShort("USE_COUNT"));
        this.setDeviceType(dBResultSet.getShort("DEVICE_TYPE"));
        this.setUnsupportedModel(dBResultSet.getString("UNSUPPORTED_MODEL"));
        this.setFlags(dBResultSet.getShort("FLAGS"));
        this.setRemovableMedium(dBResultSet.getString("REMOVABLE_MEDIUM"));
        this.setMultiPort(dBResultSet.getString("MULTI_PORT"));
        this.setDiscoveredTime(dBResultSet.getTimestamp("DISCOVERED_TIME"));
        this.setStorageSystemType(dBResultSet.getShort("STORAGE_SYSTEM_TYPE"));
        this.setDiskGroupId(dBResultSet.getInt("DISK_GROUP_ID"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setSystemCreationClassNameId(dBResultSet.getShort("SYSTEM_CREATION_CLASS_NAME_ID"));
        this.setSystemCreationClassName(Normalizer.SystemCreationClassNameGetName(dBConnection, this.m_SystemCreationClassNameId));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setSystemNamesId(dBResultSet.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(dBConnection, this.m_SystemNamesId));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
        this.setDeviceId(dBResultSet.getString("DEVICE_ID"));
        this.setName(dBResultSet.getString("NAME"));
        this.setTag(dBResultSet.getString("TAG"));
        this.setDisplayName(dBResultSet.getString("DISPLAY_NAME"));
        this.setCapacity(dBResultSet.getLong("CAPACITY"));
        this.setSubsystemSerialNumber(dBResultSet.getString("SUBSYSTEM_SERIAL_NUMBER"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(dBResultSet.getShort("CONSOLIDATED_STATUS"));
        this.setLunssid(dBResultSet.getString("LUNSSID"));
    }

    public static class PhysicalVolumeCursor
    extends DBCursor {
        private PhysicalVolume element = new PhysicalVolume();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")) != null) {
                hashtable.put(PhysicalVolume.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("VENDOR_ID")))));
            }
            if (hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")) != null) {
                hashtable.put(PhysicalVolume.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("MODEL_ID")))));
            }
            if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
            }
            if (hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                hashtable.put(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            return hashtable;
        }

        public PhysicalVolumeCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_PHYSICAL_VOLUME", dBConnection, PhysicalVolumeCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public PhysicalVolume getObject() throws SQLException {
            PhysicalVolume physicalVolume = null;
            if (this.DBrs != null) {
                physicalVolume = new PhysicalVolume();
                physicalVolume.setFields(this.con, this.DBrs);
            }
            return physicalVolume;
        }

        public PhysicalVolume getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

