/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchBladeTable;

public class SwitchBlade
extends TResSwitchBladeTable {
    private String m_VendorId_str;
    private String m_ModelId_str;

    public void setVendor(String string) {
        this.m_VendorId_str = string;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public void setModel(String string) {
        this.m_ModelId_str = string;
    }

    public String getModel() {
        return this.m_ModelId_str;
    }

    public static SwitchBladeCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new SwitchBladeCursor(dBConnection, hashtable, vector);
    }

    public SwitchBlade() {
        this.clear();
    }

    public SwitchBlade(int n, short s, String string, String string2, short s2, short s3, String string3, String string4, Timestamp timestamp, short s4, int n2, short s5, short s6) {
        this.clear();
        this.m_SwitchBladeId = n;
        this.m_VendorId = s;
        this.m_SerialNumber = string;
        this.m_Slot = string2;
        this.m_SwitchBladeTypeId = s2;
        this.m_ModelId = s3;
        this.m_SwitchWwn = string3;
        this.m_FirmwareRevision = string4;
        this.m_UpdateTimestamp = timestamp;
        this.m_Detectable = s4;
        this.m_OperationalStatus = n2;
        this.m_ConsolidatedStatus = s5;
        this.m_PropagatedStatus = s6;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_SwitchBladeId != Integer.MIN_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("SWITCH_BLADE_ID"), String.valueOf(this.m_SwitchBladeId));
        }
        if (this.m_Slot != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("SLOT"), this.m_Slot);
        }
        if (this.m_SwitchBladeTypeId != Short.MIN_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("SWITCH_BLADE_TYPE_ID"), String.valueOf(this.m_SwitchBladeTypeId));
        }
        if (this.m_ModelId != Short.MIN_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(this.m_ModelId));
        }
        if (this.m_SwitchWwn != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        }
        if (this.m_FirmwareRevision != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("FIRMWARE_REVISION"), this.m_FirmwareRevision);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            hashtable.put(SwitchBlade.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_VendorId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key VENDOR_ID not found");
        }
        this.htColsAndValues.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        if (this.m_SerialNumber == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SERIAL_NUMBER not found");
        }
        this.htColsAndValues.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SWITCH_BLADE", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) == null) {
            throw new SQLException(" ERROR: key VENDOR_ID not found");
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")) == null) {
            throw new SQLException(" ERROR: key SERIAL_NUMBER not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SWITCH_BLADE", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_VendorId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key VENDOR_ID not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        if (this.m_SerialNumber == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SERIAL_NUMBER not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_BLADE", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) == null) {
            throw new SQLException(" ERROR: key VENDOR_ID not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")));
        if (hashtable.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")) == null) {
            throw new SQLException(" ERROR: key SERIAL_NUMBER not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), hashtable.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_BLADE", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_VendorId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key VENDOR_ID not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        if (this.m_SerialNumber == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SERIAL_NUMBER not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_BLADE", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) == null) {
            throw new SQLException(" ERROR: key VENDOR_ID not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")));
        if (hashtable.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")) == null) {
            throw new SQLException(" ERROR: key SERIAL_NUMBER not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), hashtable.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_BLADE", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_ModelId_str != null) {
            this.m_ModelId = Normalizer.ModelGetID(dBConnection, this.m_ModelId_str);
        }
        if (this.m_VendorId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key VENDOR_ID not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        if (this.m_SerialNumber == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SERIAL_NUMBER not found");
        }
        this.htWhereClause.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SWITCH_BLADE", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static SwitchBlade retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        SwitchBlade switchBlade = null;
        if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) == null) {
            throw new SQLException(" ERROR: key VENDOR_ID not found");
        }
        hashtable2.put(SwitchBlade.getColumnInfo("VENDOR_ID"), hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")));
        if (hashtable.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")) == null) {
            throw new SQLException(" ERROR: key SERIAL_NUMBER not found");
        }
        hashtable2.put(SwitchBlade.getColumnInfo("SERIAL_NUMBER"), hashtable.get(SwitchBlade.getColumnInfo("SERIAL_NUMBER")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SWITCH_BLADE", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                switchBlade = new SwitchBlade();
                switchBlade.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return switchBlade;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        if (hashtable2.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            hashtable2.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable2.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable2.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            hashtable2.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable2.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_BLADE", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
            hashtable.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_BLADE", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSwitchBladeId(dBResultSet.getInt("SWITCH_BLADE_ID"));
        this.setVendorId(dBResultSet.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(dBConnection, this.m_VendorId));
        this.setSerialNumber(dBResultSet.getString("SERIAL_NUMBER"));
        this.setSlot(dBResultSet.getString("SLOT"));
        this.setSwitchBladeTypeId(dBResultSet.getShort("SWITCH_BLADE_TYPE_ID"));
        this.setModelId(dBResultSet.getShort("MODEL_ID"));
        this.setModel(Normalizer.ModelGetName(dBConnection, this.m_ModelId));
        this.setSwitchWwn(dBResultSet.getString("SWITCH_WWN"));
        this.setFirmwareRevision(dBResultSet.getString("FIRMWARE_REVISION"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(dBResultSet.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(dBResultSet.getShort("PROPAGATED_STATUS"));
    }

    public static class SwitchBladeCursor
    extends DBCursor {
        private SwitchBlade element = new SwitchBlade();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")) != null) {
                hashtable.put(SwitchBlade.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("VENDOR_ID")))));
            }
            if (hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")) != null) {
                hashtable.put(SwitchBlade.getColumnInfo("MODEL_ID"), String.valueOf(Normalizer.ModelGetID(dBConnection, (String)hashtable.get(SwitchBlade.getColumnInfo("MODEL_ID")))));
            }
            return hashtable;
        }

        public SwitchBladeCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_SWITCH_BLADE", dBConnection, SwitchBladeCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public SwitchBlade getObject() throws SQLException {
            SwitchBlade switchBlade = null;
            if (this.DBrs != null) {
                switchBlade = new SwitchBlade();
                switchBlade.setFields(this.con, this.DBrs);
            }
            return switchBlade;
        }

        public SwitchBlade getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

