/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeDriveTable;

public class TapeDrive
extends TResTapeDriveTable {
    private String m_SystemCreationClassNameId_str;
    private String m_CreationClassNameId_str;
    private String m_SystemNamesId_str;

    public void setSystemCreationClassName(String string) {
        this.m_SystemCreationClassNameId_str = string;
    }

    public String getSystemCreationClassName() {
        return this.m_SystemCreationClassNameId_str;
    }

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setSystemNames(String string) {
        this.m_SystemNamesId_str = string;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public static TapeDriveCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new TapeDriveCursor(dBConnection, hashtable, vector);
    }

    public TapeDrive() {
        this.clear();
    }

    public TapeDrive(int n, short s, short s2, short s3, String string, int n2, short s4, long l, short s5, long l2, long l3, int n3, String string2, int n4, String string3, int n5, Timestamp timestamp, short s6, short s7, String string4, short s8, String string5, String string6, String string7) {
        this.clear();
        this.m_TapeDriveId = n;
        this.m_SystemCreationClassNameId = s;
        this.m_CreationClassNameId = s2;
        this.m_SystemNamesId = s3;
        this.m_DeviceId = string;
        this.m_OperationalStatus = n2;
        this.m_NeedsCleaning = s4;
        this.m_MountCount = l;
        this.m_Availability = s5;
        this.m_PowerOnHours = l2;
        this.m_TotalPowerOnHours = l3;
        this.m_TapeLibraryId = n3;
        this.m_ElementName = string2;
        this.m_NodeId = n4;
        this.m_FirmwareVersion = string3;
        this.m_LocationId = n5;
        this.m_UpdateTimestamp = timestamp;
        this.m_ConsolidatedStatus = s6;
        this.m_Detectable = s7;
        this.m_DisplayName = string4;
        this.m_PropagatedStatus = s8;
        this.m_UserAttrib1 = string5;
        this.m_UserAttrib2 = string6;
        this.m_UserAttrib3 = string7;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_TapeDriveId != Integer.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("TAPE_DRIVE_ID"), String.valueOf(this.m_TapeDriveId));
        }
        if (this.m_SystemCreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(this.m_SystemCreationClassNameId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_SystemNamesId != Short.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_NeedsCleaning != Short.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("NEEDS_CLEANING"), String.valueOf(this.m_NeedsCleaning));
        }
        if (this.m_MountCount != Long.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("MOUNT_COUNT"), String.valueOf(this.m_MountCount));
        }
        if (this.m_Availability != Short.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("AVAILABILITY"), String.valueOf(this.m_Availability));
        }
        if (this.m_PowerOnHours != Long.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("POWER_ON_HOURS"), String.valueOf(this.m_PowerOnHours));
        }
        if (this.m_TotalPowerOnHours != Long.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("TOTAL_POWER_ON_HOURS"), String.valueOf(this.m_TotalPowerOnHours));
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_NodeId != Integer.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("NODE_ID"), String.valueOf(this.m_NodeId));
        }
        if (this.m_FirmwareVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("FIRMWARE_VERSION"), this.m_FirmwareVersion);
        }
        if (this.m_LocationId != Integer.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("LOCATION_ID"), String.valueOf(this.m_LocationId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeDrive.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htColsAndValues.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htColsAndValues.put(TapeDrive.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_DRIVE", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        if (hashtable.get(TapeDrive.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_DRIVE", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_DRIVE", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), hashtable.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")));
        if (hashtable.get(TapeDrive.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), hashtable.get(TapeDrive.getColumnInfo("DEVICE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_DRIVE", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_DRIVE", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), hashtable.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")));
        if (hashtable.get(TapeDrive.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), hashtable.get(TapeDrive.getColumnInfo("DEVICE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_DRIVE", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_TapeLibraryId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_LIBRARY_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        if (this.m_DeviceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key DEVICE_ID not found");
        }
        this.htWhereClause.put(TapeDrive.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TAPE_DRIVE", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static TapeDrive retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        TapeDrive tapeDrive = null;
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_LIBRARY_ID not found");
        }
        hashtable2.put(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID"), hashtable.get(TapeDrive.getColumnInfo("TAPE_LIBRARY_ID")));
        if (hashtable.get(TapeDrive.getColumnInfo("DEVICE_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_ID not found");
        }
        hashtable2.put(TapeDrive.getColumnInfo("DEVICE_ID"), hashtable.get(TapeDrive.getColumnInfo("DEVICE_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TAPE_DRIVE", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                tapeDrive = new TapeDrive();
                tapeDrive.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return tapeDrive;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable2.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable2.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable2.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable2.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_DRIVE", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_DRIVE", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setTapeDriveId(dBResultSet.getInt("TAPE_DRIVE_ID"));
        this.setSystemCreationClassNameId(dBResultSet.getShort("SYSTEM_CREATION_CLASS_NAME_ID"));
        this.setSystemCreationClassName(Normalizer.SystemCreationClassNameGetName(dBConnection, this.m_SystemCreationClassNameId));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setSystemNamesId(dBResultSet.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(dBConnection, this.m_SystemNamesId));
        this.setDeviceId(dBResultSet.getString("DEVICE_ID"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setNeedsCleaning(dBResultSet.getShort("NEEDS_CLEANING"));
        this.setMountCount(dBResultSet.getLong("MOUNT_COUNT"));
        this.setAvailability(dBResultSet.getShort("AVAILABILITY"));
        this.setPowerOnHours(dBResultSet.getLong("POWER_ON_HOURS"));
        this.setTotalPowerOnHours(dBResultSet.getLong("TOTAL_POWER_ON_HOURS"));
        this.setTapeLibraryId(dBResultSet.getInt("TAPE_LIBRARY_ID"));
        this.setElementName(dBResultSet.getString("ELEMENT_NAME"));
        this.setNodeId(dBResultSet.getInt("NODE_ID"));
        this.setFirmwareVersion(dBResultSet.getString("FIRMWARE_VERSION"));
        this.setLocationId(dBResultSet.getInt("LOCATION_ID"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setConsolidatedStatus(dBResultSet.getShort("CONSOLIDATED_STATUS"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setDisplayName(dBResultSet.getString("DISPLAY_NAME"));
        this.setPropagatedStatus(dBResultSet.getShort("PROPAGATED_STATUS"));
        this.setUserAttrib1(dBResultSet.getString("USER_ATTRIB1"));
        this.setUserAttrib2(dBResultSet.getString("USER_ATTRIB2"));
        this.setUserAttrib3(dBResultSet.getString("USER_ATTRIB3"));
    }

    public static class TapeDriveCursor
    extends DBCursor {
        private TapeDrive element = new TapeDrive();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
            }
            if (hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                hashtable.put(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(TapeDrive.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            return hashtable;
        }

        public TapeDriveCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_TAPE_DRIVE", dBConnection, TapeDriveCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public TapeDrive getObject() throws SQLException {
            TapeDrive tapeDrive = null;
            if (this.DBrs != null) {
                tapeDrive = new TapeDrive();
                tapeDrive.setFields(this.con, this.DBrs);
            }
            return tapeDrive;
        }

        public TapeDrive getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

