/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentTable;

public class Volume2extent
extends TResVolume2extentTable {
    public static Volume2extentCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new Volume2extentCursor(dBConnection, hashtable, vector);
    }

    public Volume2extent() {
        this.clear();
    }

    public Volume2extent(int n, int n2, int n3, Timestamp timestamp) {
        this.clear();
        this.m_VolumeId = n;
        this.m_StorageExtentId = n2;
        this.m_TotalNumExtents = n3;
        this.m_UpdateTimestamp = timestamp;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_TotalNumExtents != Integer.MIN_VALUE) {
            hashtable.put(Volume2extent.getColumnInfo("TOTAL_NUM_EXTENTS"), String.valueOf(this.m_TotalNumExtents));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Volume2extent.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htColsAndValues.put(Volume2extent.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_StorageExtentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htColsAndValues.put(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_VOLUME2EXTENT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Volume2extent.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        if (hashtable.get(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID")) == null) {
            throw new SQLException(" ERROR: key STORAGE_EXTENT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_VOLUME2EXTENT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(Volume2extent.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_StorageExtentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htWhereClause.put(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_VOLUME2EXTENT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Volume2extent.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(Volume2extent.getColumnInfo("VOLUME_ID"), hashtable.get(Volume2extent.getColumnInfo("VOLUME_ID")));
        if (hashtable.get(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID")) == null) {
            throw new SQLException(" ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htWhereClause.put(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), hashtable.get(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_VOLUME2EXTENT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(Volume2extent.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_StorageExtentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htWhereClause.put(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_VOLUME2EXTENT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Volume2extent.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(Volume2extent.getColumnInfo("VOLUME_ID"), hashtable.get(Volume2extent.getColumnInfo("VOLUME_ID")));
        if (hashtable.get(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID")) == null) {
            throw new SQLException(" ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htWhereClause.put(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), hashtable.get(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_VOLUME2EXTENT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(Volume2extent.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_StorageExtentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key STORAGE_EXTENT_ID not found");
        }
        this.htWhereClause.put(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_VOLUME2EXTENT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Volume2extent retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Volume2extent volume2extent = null;
        if (hashtable.get(Volume2extent.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        hashtable2.put(Volume2extent.getColumnInfo("VOLUME_ID"), hashtable.get(Volume2extent.getColumnInfo("VOLUME_ID")));
        if (hashtable.get(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID")) == null) {
            throw new SQLException(" ERROR: key STORAGE_EXTENT_ID not found");
        }
        hashtable2.put(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID"), hashtable.get(Volume2extent.getColumnInfo("STORAGE_EXTENT_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_VOLUME2EXTENT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                volume2extent = new Volume2extent();
                volume2extent.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return volume2extent;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_VOLUME2EXTENT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_VOLUME2EXTENT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setVolumeId(dBResultSet.getInt("VOLUME_ID"));
        this.setStorageExtentId(dBResultSet.getInt("STORAGE_EXTENT_ID"));
        this.setTotalNumExtents(dBResultSet.getInt("TOTAL_NUM_EXTENTS"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class Volume2extentCursor
    extends DBCursor {
        private Volume2extent element = new Volume2extent();
        private DBConnection con;

        public Volume2extentCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_VOLUME2EXTENT", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public Volume2extent getObject() throws SQLException {
            Volume2extent volume2extent = null;
            if (this.DBrs != null) {
                volume2extent = new Volume2extent();
                volume2extent.setFields(this.con, this.DBrs);
            }
            return volume2extent;
        }

        public Volume2extent getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

