/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class FcNodeXmlToDBMapper
extends DBAttributeMapper {
    private static final String INTERFACESTATUS = "Interface Status";
    private static final String CONSOLIDATEDSTATUS = "conStatus";
    private static final String PLATFORMTYPE = "Platform Type";
    private static final String RNIDTYPE = "RNID Type";
    private static final String SCSISUPPORT = "SCSI Support";
    private static final String MGMTTELNETADDRESS = "Management Telnet Address";
    private static final String MGMTSNMPADDRESS = "Management Snmp Address";
    private static final String MGMTURLADDRESS = "Management URL Address";
    private static final String NAMEFORMAT = "Name Format";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "FcNodeXml";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public FcNodeXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml", ":", 2);
        this.m_dataConverter.addSimpleDataConversion(PLATFORMTYPE.toLowerCase(), "Node_Type");
        this.m_dataConverter.addSimpleDataConversion(RNIDTYPE.toLowerCase(), "Node_Type");
        this.m_htAttribToMapperInfo.put(SCSISUPPORT.toLowerCase(), new MapperInfo(Node.getColumnInfo("SCSI_SUPPORT")));
        this.m_htAttribToMapperInfo.put(PLATFORMTYPE.toLowerCase(), new MapperInfo(Node.getColumnInfo("PLATFORM_TYPE")));
        this.m_htAttribToMapperInfo.put(RNIDTYPE.toLowerCase(), new MapperInfo(Node.getColumnInfo("RNID_TYPE")));
        this.m_htAttribToMapperInfo.put("name", new MapperInfo(Node.getColumnInfo("OTHER_NAME")));
        this.m_htAttribToMapperInfo.put(MGMTURLADDRESS.toLowerCase(), new MapperInfo(Node.getColumnInfo("MGMT_URL_ADDR")));
        this.m_htAttribToMapperInfo.put(MGMTTELNETADDRESS.toLowerCase(), new MapperInfo(Node.getColumnInfo("MGMT_TEL_ADDR")));
        this.m_htAttribToMapperInfo.put(MGMTSNMPADDRESS.toLowerCase(), new MapperInfo(Node.getColumnInfo("MGMT_SNMP_ADDR")));
        this.m_htAttribToMapperInfo.put(INTERFACESTATUS.toLowerCase(), new MapperInfo(Node.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(CONSOLIDATEDSTATUS.toLowerCase(), new MapperInfo(Node.getColumnInfo("CONSOLIDATED_STATUS")));
        ColumnInfo columnInfo = Node.getColumnInfo("NAME");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        ColumnInfo columnInfo2 = Node.getColumnInfo("NODE_ID");
        columnInfo2.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), mapperInfo);
        ColumnInfo columnInfo3 = Node.getColumnInfo("NAME_FORMAT");
        columnInfo3.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put(NAMEFORMAT.toLowerCase(), new MapperInfo(columnInfo3));
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        Object object2;
        String string2 = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, string2, new Object[]{dBConnection, hashtable, string});
        String string3 = (String)hashtable.get(INTERFACESTATUS);
        if (string3 != null) {
            object2 = this.convertSNIAOPStatToBitArrValue(string3);
            hashtable.put(INTERFACESTATUS, object2[0]);
            object = new Vector<Object>();
            ((Vector)object).add(object2[1]);
            String string4 = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)object);
            if (string4 != null) {
                hashtable.put(CONSOLIDATEDSTATUS, string4);
            }
        }
        if (hashtable.get(NAMEFORMAT.toLowerCase()) == null) {
            object2 = DBConstants.getValueFromKey("Name_Format", "FC_WWN");
            hashtable.put(NAMEFORMAT.toLowerCase(), object2);
        }
        if ((object2 = (String)hashtable.get(MGMTURLADDRESS)) != null && ((String)object2).indexOf("0.0.0.0") != -1) {
            hashtable.remove(MGMTURLADDRESS);
        }
        object = super.persist(dBConnection, hashtable, string);
        this.logExit(this.myClassname, string2, object);
        return object;
    }
}

