/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.report.bulk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.aperi.report.bulk.BulkDefinitions;

public class BulkLoader {
    static Connection connection;
    static ZipFile zipIn;
    static String descr;

    public static void main(String[] stringArray) {
        try {
            BulkDefinitions.processArgs("Loader", stringArray);
        }
        catch (Exception exception) {
            System.err.println("Could not process args: " + exception.getLocalizedMessage());
        }
        try {
            Class.forName(BulkDefinitions.jdbcDriver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.print("Could not find JDBC driver class: " + classNotFoundException.getLocalizedMessage());
            return;
        }
        try {
            connection = DriverManager.getConnection(BulkDefinitions.jdbcUrl, BulkDefinitions.jdbcUser, BulkDefinitions.jdbcPassword);
            BulkDefinitions.setSchema("Aperi", connection);
        }
        catch (SQLException sQLException) {
            System.err.print(sQLException.getLocalizedMessage());
            return;
        }
        try {
            BulkLoader.cleanReportTable();
        }
        catch (SQLException sQLException) {
            System.err.print("Error cleaning out report table: " + sQLException.getLocalizedMessage());
            return;
        }
        try {
            BulkLoader.cleanRepositoryDirectory(BulkDefinitions.repository);
        }
        catch (Exception exception) {
            System.err.print("Error cleaning out repository: " + exception.getLocalizedMessage());
            return;
        }
        try {
            File file = new File(BulkDefinitions.zip);
            if (!file.exists()) {
                System.err.print("File " + BulkDefinitions.zip + " does not exist or is unreadable.");
                return;
            }
            zipIn = new ZipFile(BulkDefinitions.zip);
        }
        catch (Exception exception) {
            System.err.print(exception.getLocalizedMessage());
            return;
        }
        try {
            BulkLoader.zipItOut(BulkDefinitions.repository, zipIn, connection);
        }
        catch (Exception exception) {
            System.err.print("Bulk unload failed: " + exception.getLocalizedMessage());
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {}
        BulkDefinitions.postProcessing();
    }

    private static void zipItOut(String string, ZipFile zipFile, Connection connection) throws IOException, SQLException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.getName().matches(".*\\.properties")) {
                BulkLoader.handleProps(string, zipEntry, connection);
                continue;
            }
            if (zipEntry.getName().matches(".*\\.rptdesign")) {
                BulkLoader.handleReport(string, zipEntry);
                continue;
            }
            throw new RuntimeException("Unexpected content in zip file: " + zipEntry.getName());
        }
    }

    private static void handleReport(String string, ZipEntry zipEntry) throws IOException {
        int n;
        File file = new File(zipEntry.getName());
        System.out.println("Processing Report: " + string + File.separator + file.getPath() + "\t" + file.length() + " bytes");
        ++BulkDefinitions.reportsProcessed;
        File file2 = new File(String.valueOf(string) + File.separator + file.getPath().substring(0, file.getPath().lastIndexOf(file.getName())));
        file2.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string) + File.separator + file.getPath());
        InputStream inputStream = zipIn.getInputStream(zipEntry);
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
            BulkDefinitions.bytesProcessed += n;
        }
        inputStream.close();
        fileOutputStream.close();
    }

    private static void handleProps(String string, ZipEntry zipEntry, Connection connection) throws IOException, SQLException {
        Properties properties = new Properties();
        properties.load(zipIn.getInputStream(zipEntry));
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT into T_BIRT_DESCR (NAME, PATH, TITLE, ROLES, DESCRIPTION, CREATOR, CREATION_DATE, EDITOR, EDIT_DATE) values (?,?,?,?,?,?,?,?,?)");
            preparedStatement.setString(1, properties.getProperty("name"));
            preparedStatement.setString(2, properties.getProperty("path"));
            preparedStatement.setString(3, properties.getProperty("title"));
            preparedStatement.setLong(4, Long.parseLong((String)properties.get("roles")));
            preparedStatement.setString(5, properties.getProperty("description"));
            preparedStatement.setString(6, properties.getProperty("creator"));
            preparedStatement.setLong(7, System.currentTimeMillis());
            preparedStatement.setString(8, properties.getProperty("editor"));
            preparedStatement.setLong(9, System.currentTimeMillis());
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Throwable throwable) {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (Exception exception) {}
    }

    private static void cleanReportTable() throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM T_BIRT_DESCR");
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Throwable throwable) {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (Exception exception) {}
    }

    private static void cleanRepositoryDirectory(String string) {
        File file = new File(string);
        if (!(file.isDirectory() && file.canRead() || file.mkdirs())) {
            throw new RuntimeException("Report repository directory " + string + " cannot be scanned.");
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(String.valueOf(file.getPath()) + File.separator + stringArray[n]);
            if (file2.isDirectory() && !stringArray[n].matches("documents")) {
                BulkLoader.cleanRepositoryDirectory(file2.getPath());
                if (!file2.delete()) {
                    throw new RuntimeException("Could not delete directory: " + file2.getPath());
                }
            } else if (file2.isFile() && stringArray[n].matches(".*\\.rptdesign") && !file2.delete()) {
                throw new RuntimeException("Could not delete report file: " + file2.getPath());
            }
            ++n;
        }
    }
}

