/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphAssociation;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL1;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;

public class ViewerServerL1
extends ViewerServerL0 {
    private static final boolean debug = false;
    public static final String SELECT_HOST = "SELECT \t\tT_RES_HOST.PREFIX_ID, \t    CASE WHEN T_RES_HOST.HOST_NAME IS NOT NULL THEN T_RES_HOST.HOST_NAME \t\t\t WHEN T_RES_HOST.HOST_URL IS NOT NULL THEN T_RES_HOST.HOST_URL \t\t\t ELSE CAST(T_RES_HOST.COMPUTER_ID as CHAR(10)) \t\tEND  DISPLAY_NAME,        T_RES_HOST.DEV_STATUS DEV_STATUS,        T_RES_HOST.DAT_STATUS DAT_STATUS, \t\tT_RES_HOST.HOST_NAME HOST_NAME, \t\tT_RES_HOST.COMPUTER_ID HOST_ID, \t\tT_RES_HOST.GUID GUID, \t\tT_RES_HOST.OS_TYPE OS_TYPE,\t\tT_RES_HOST.OS_VERSION OS_VERSION,\t\tT_RES_HOST.TIME_ZONE TIME_ZONE,\t\tT_RES_HOST.IP_ADDRESS IP_ADDRESS,\t\tT_RES_HOST.DETECTABLE DETECTABLE, \t\tT_RES_HOST.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_HOST.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HOST.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HOST.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_HOST.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_HOST.USER_ATTRIB3 USER_ATTRIB3  FROM \tT_VIEW_VHOST T_RES_HOST,\tT_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tT_RES_HOST.PREFIX_ID = TMP.PREFIX_ID and \tT_RES_HOST.COMPUTER_ID = TMP.ENTITY_ID and  \tTMP.ID = ?";
    public static final String SELECT_SWITCH_FROM_HOST = "SELECT \tTMP.PREFIX_ID HOST_PREFIX_ID, \tTMP.ENTITY_ID HOST_ID, \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 ,\t SWITCH2HOST.SWITCH_PORT_ID PORT_ID FROM T_VIEW_VSWITCH2HOST SWITCH2HOST,     T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on     T_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID =? and \t TMP.PREFIX_ID = SWITCH2HOST.HOST_PREFIX_ID and \t TMP.ENTITY_ID = SWITCH2HOST.HOST_ID and     SWITCH2HOST.SWITCH_ID = T_RES_SWITCH.SWITCH_ID ";
    public static final String SELECT_SWITCH2HOST_FROM_HOST = "SELECT distinct \t SWITCH2HOST.HOST_PREFIX_ID, \t SWITCH2HOST.HOST_ID, \t SWITCH2HOST.SWITCH_PREFIX_ID SWITCH_PREFIX_ID, \t SWITCH2HOST.SWITCH_ID,\t SWITCH2HOST.PORT2PORT_ID PORT2PORT_ID,\t SWITCH2HOST.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2HOST SWITCH2HOST, T_RES_TMP_TOPOLOGY_ENTITY TMP where     TMP.ID = ? and \t TMP.PREFIX_ID = SWITCH2HOST.HOST_PREFIX_ID and \t TMP.ENTITY_ID = SWITCH2HOST.HOST_ID ";
    public static final String SELECT_HOST2SUBSYSTEM_FROM_HOST = "SELECT     TMP.PREFIX_ID HOST_PREFIX_ID, \t TMP.ENTITY_ID HOST_ID, \t T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID, \t HOST2SUBSYSTEM.PORT2PORT_ID PORT2PORT_ID, \t HOST2SUBSYSTEM.DETECTABLE DETECTABLE, \t HOST2SUBSYSTEM.SUBSYSTEM_PORT_ID PORT_ID FROM T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM,    T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on     T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t TMP.PREFIX_ID = HOST2SUBSYSTEM.HOST_PREFIX_ID and \t TMP.ENTITY_ID = HOST2SUBSYSTEM.HOST_ID and     HOST2SUBSYSTEM.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID ";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_HOST = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VHOST2PORT HOST2PORT,     T_VIEW_PORT2ZONE PORT2ZONE,  \t T_RES_ZONE, T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    TMP.ID = ? and \tTMP.PREFIX_ID = HOST2PORT.PREFIX_ID and    TMP.ENTITY_ID = HOST2PORT.HOST_ID and \tHOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and \tPORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \tT_RES_ZONE.FABRIC_WWN = T_RES_FABRIC.FABRIC_WWN";
    public static final String SELECT_ZONES_FROM_HOST = "SELECT DISTINCT    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VHOST2PORT HOST2PORT,T_VIEW_PORT2ZONE PORT2ZONE,    T_RES_ZONE, T_RES_FABRIC FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t TMP.PREFIX_ID = HOST2PORT.PREFIX_ID and \t TMP.ENTITY_ID = HOST2PORT.HOST_ID and     HOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \t T_RES_ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_ZONE2MEMBER_FROM_HOST = "SELECT DISTINCT     PORT2ZONE2.ZONE_ID ZONE_ID,     ENTITY_TO_PORT.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE2.MEMBER_NAME, \t PORT2ZONE2.ZONE_MEMBER_ID,     PORT.PORT_NUMBER FROM T_VIEW_VHOST2PORT HOST2PORT,T_VIEW_PORT2ZONE PORT2ZONE1,T_VIEW_PORT2ZONE PORT2ZONE2 left outer join \t T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE2.PORT_ID = ENTITY_TO_PORT.PORT_ID left outer join T_RES_PORT PORT on  \t PORT2ZONE2.PORT_ID = PORT.PORT_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t TMP.PREFIX_ID = HOST2PORT.PREFIX_ID and \t TMP.ENTITY_ID = HOST2PORT.HOST_ID and     HOST2PORT.PORT_ID = PORT2ZONE1.PORT_ID and \t PORT2ZONE1.ZONE_ID = PORT2ZONE2.ZONE_ID  ";
    public static final String SELECT_ZSET2ZONE_FROM_HOST = "SELECT DISTINCT     PORT2ZONE.ZONE_ID ZONE_ID,     ZSET2ZONE.ZSET_ID ZSET_ID FROM T_VIEW_VHOST2PORT HOST2PORT, T_VIEW_PORT2ZONE PORT2ZONE, \tT_RES_ZSET2ZONE ZSET2ZONE, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t TMP.PREFIX_ID = HOST2PORT.PREFIX_ID and \t TMP.ENTITY_ID = HOST2PORT.HOST_ID and     HOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID";
    public static final String SELECT_ZSET_FROM_HOST = "SELECT DISTINCT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VHOST2PORT HOST2PORT, T_VIEW_PORT2ZSET PORT2ZSET,     T_RES_ZSET, T_RES_FABRIC FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t TMP.PREFIX_ID = HOST2PORT.PREFIX_ID and \t TMP.ENTITY_ID = HOST2PORT.HOST_ID and     HOST2PORT.PORT_ID = PORT2ZSET.PORT_ID and     PORT2ZSET.ZSET_ID = T_RES_ZSET.ZSET_ID and \t T_RES_ZSET.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static String SELECT_SANS_FOR_HOST = "SELECT\t\tHOST2FABRIC.PREFIX_ID PREFIX_ID,\t\tHOST2FABRIC.HOST_ID HOST_ID,\t    HOST2FABRIC.FABRIC_ID FABRIC_ID FROM T_VIEW_VHOST2FABRIC HOST2FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t    TMP.ID = ? and \t\tTMP.PREFIX_ID = HOST2FABRIC.PREFIX_ID and \t    TMP.ENTITY_ID = HOST2FABRIC.HOST_ID ";
    public static final String SELECT_SANS_FROM_SWITCH_FROM_HOST = "SELECT \tSWITCH2FABRIC.PREFIX_ID, \tSWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3  FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2HOST SWITCH2HOST, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tT_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID and \tSWITCH2FABRIC.SWITCH_ID = SWITCH2HOST.SWITCH_ID and    TMP.PREFIX_ID = SWITCH2HOST.HOST_PREFIX_ID and \tTMP.ENTITY_ID = SWITCH2HOST.HOST_ID and \tTMP.ID = ?";
    public static final String SELECT_SANS_FROM_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST = "SELECT \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID SUBSYSTEM_ID,\t SUBSYSTEM2FABRIC.FABRIC_ID FABRIC_ID FROM  T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM, T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tSUBSYSTEM2FABRIC.SUBSYSTEM_ID = HOST2SUBSYSTEM.SUBSYSTEM_ID and    HOST2SUBSYSTEM.HOST_ID = TMP.ENTITY_ID and \tTMP.PREFIX_ID = 'server:' and \tTMP.ID = ?";
    public static final String SELECT_FILESYSTEM_SIMPLE_FROM_LUN = "SELECT distinct \tTMP.PREFIX_ID,\tTMP.ENTITY_ID HOST_ID, \tfs.filesystem_id, \tda.LUN, \tssluncmp.SVID volume_id, \tfs.logical_disk_id, \tsd.disk_id, \tc.host_name,  \tvendor.vendor_name, \tfs.mount_point, \tfs.capacity,  \tfs.free_space, \tfs.filesystem_id, \tda.path, ss.os_type,  \tcase \t\twhen ss.user_provided_name is not null and ss.user_provided_name not in '' then ss.user_provided_name    \t\telse ss.display_name \tend display_name, \tshare.name, \tssluncmp.lun_id,  \tsd.capacity, \tsv.display_name, \tcimv.device_id   FROM \tt_res_host c, t_res_storage_subsystem ss, t_res_dev_access da, t_stat_disk sd, \tt_res_filesystem fs, t_res_chunk chunk, t_res_share share, t_res_vendor vendor, \tt_res_view_ssluncmp ssluncmp, t_res_storage_volume sv, t_res_cimkey_volume cimv,   \tT_RES_TMP_TOPOLOGY_ENTITY TMP WHERE  \tTMP.ID = ? and \tTMP.PREFIX_ID = 'server:' and \tTMP.ENTITY_ID = ssluncmp.computer_id and \tssluncmp.computer_id = c.computer_id and  \tssluncmp.svid = sv.svid and  \tsv.svid = cimv.volume_id and  \tssluncmp.subsystem_id = ss.subsystem_id and  \tss.vendor_id = vendor.vendor_id and  \tssluncmp.physical_volume_id = sd.disk_id and  \tsd.disk_id = chunk.disk_id and  \tssluncmp.physical_volume_id = da.device_id and  \tc.computer_id = fs.computer_id and  \tfs.logical_disk_id = chunk.logical_disk_id and  \tshare.resource_id = chunk.logical_disk_id ";
    public static final String SELECT_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST = "SELECT \tTMP.PREFIX_ID HOST_PREFIX_ID,\tTMP.ENTITY_ID HOST_ID, \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 ,\t HOST2SUBSYSTEM.SUBSYSTEM_PORT_ID PORT_ID FROM T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM,     T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on     T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t TMP.PREFIX_ID = HOST2SUBSYSTEM.HOST_PREFIX_ID and \t TMP.ENTITY_ID = HOST2SUBSYSTEM.HOST_ID and     HOST2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = T_RES_STORAGE_SUBSYSTEM.PREFIX_ID and \t HOST2SUBSYSTEM.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID ";
    public static final String SELECT_LUN_FROM_HOST = "SELECT distinct     LUN2HOST.PREFIX_ID,     LUN2HOST.HOST_ID HOST_ID,     LUN2HOST.HOST_LUN_ID HOST_LUN_ID,     LUN2HOST.VOLUME_ID VOLUME_ID, \tLUN2HOST.PATH,   \tLUN2HOST.DEVICE_ID FROM (SELECT DISTINCT \t 'server:' PREFIX_ID, \t COMPUTER.COMPUTER_ID HOST_ID,     ACCESS.LUN HOST_LUN_ID, \t VOLUME.SVID VOLUME_ID, \t ACCESS.PATH PATH,   \t ACCESS.DEVICE_ID FROM \tT_RES_HOST COMPUTER,    T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME \tleft outer join T_RES_STORAGE_VOLUME VOLUME on    PHYSICAL_VOLUME.LUNSSID = VOLUME.UNIQUE_ID,    T_RES_DEV_ACCESS ACCESS,    T_RES_CONTROLLER CONTROLLER WHERE     PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION (SELECT DISTINCT   \t HOST.PREFIX_ID,   \t HOST.COMPUTER_ID HOST_ID,   \t DATA_PATH.HOST_LUN_ID,   \t DATA_PATH.VOLUME_ID VOLUME_ID,   \t CAST('n/a' as VARCHAR(255)) PATH,  \t CAST(NULL as INTEGER) DEVICE_ID FROM   \tT_RES_DATA_PATH DATA_PATH,     \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT, (SELECT DISTINCT   \tHOST.PREFIX_ID,  \tHOST.COMPUTER_ID HOST_ID,   \tDATA_PATH.VOLUME_ID VOLUME_ID FROM   \tT_RES_DATA_PATH DATA_PATH,     \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT WHERE   \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and   \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and   \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID EXCEPT SELECT DISTINCT                   'server:' PREFIX_ID, \tCOMPUTER.COMPUTER_ID HOST_ID, \t VOLUME.SVID VOLUME_ID FROM   \tT_RES_HOST COMPUTER,     T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME   \tleft outer join T_RES_STORAGE_VOLUME VOLUME on      PHYSICAL_VOLUME.LUNSSID = VOLUME.UNIQUE_ID,    T_RES_DEV_ACCESS ACCESS,     T_RES_CONTROLLER CONTROLLER WHERE       PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND     CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID) HOST2DATAPATH_IN WHERE   \tHOST2DATAPATH_IN.PREFIX_ID = HOST.PREFIX_ID and \tHOST2DATAPATH_IN.HOST_ID = HOST.COMPUTER_ID and  \tHOST2DATAPATH_IN.VOLUME_ID = DATA_PATH.VOLUME_ID and \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and   \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and   \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID )) LUN2HOST, \tT_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t TMP.PREFIX_ID = LUN2HOST.PREFIX_ID and \t TMP.ENTITY_ID = LUN2HOST.HOST_ID";
    public static final String SELECT_ARRAYS_FROM_VOLUMES_FROM_HOST = "SELECT distinct \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 ,\tSUBSYSTEM2HOST.VOLUME_ID VOLUME_ID, \tSUBSYSTEM2HOST.PREFIX_ID HOST_PREFIX_ID, \tSUBSYSTEM2HOST.HOST_ID FROM (SELECT DISTINCT \t'server:' PREFIX_ID, \tCOMPUTER.COMPUTER_ID HOST_ID,  \tVOLUME.SVID VOLUME_ID, \tSUBSYSTEM.SUBSYSTEM_ID FROM \tT_RES_HOST COMPUTER,    T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME,    T_RES_DEV_ACCESS ACCESS,    T_RES_CONTROLLER CONTROLLER, \tT_RES_STORAGE_VOLUME VOLUME,\tT_RES_STORAGE_SUBSYSTEM SUBSYSTEM  WHERE  \tSUBSYSTEM.SUBSYSTEM_ID = VOLUME.SUBSYSTEM_ID and    PHYSICAL_VOLUME.LUNSSID = VOLUME.UNIQUE_ID and    PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION SELECT DISTINCT \t HOST.PREFIX_ID, \t HOST.COMPUTER_ID HOST_ID, \t DATA_PATH.VOLUME_ID, \t DATA_PATH.SUBSYSTEM_ID FROM \tT_RES_DATA_PATH DATA_PATH, T_RES_STORAGE_VOLUME VOLUME,  \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT WHERE \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID ) SUBSYSTEM2HOST, T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on  \tT_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID, \tT_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t TMP.PREFIX_ID = SUBSYSTEM2HOST.PREFIX_ID and \t TMP.ENTITY_ID = SUBSYSTEM2HOST.HOST_ID and \t SUBSYSTEM2HOST.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID";
    public static final String SELECT_VOLUMES_FROM_HOST = "SELECT distinct     VOLUMES2HOST.PREFIX_ID, \t VOLUMES2HOST.HOST_ID HOST_ID,     CASE WHEN T_RES_STORAGE_VOLUME.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_STORAGE_VOLUME.DISPLAY_NAME) != '' THEN T_RES_STORAGE_VOLUME.DISPLAY_NAME \t\t  WHEN T_RES_STORAGE_VOLUME.SVID IS NOT NULL THEN CAST(T_RES_STORAGE_VOLUME.SVID as CHAR) \t END DISPLAY_NAME, T_RES_STORAGE_VOLUME.SVID SVID, T_RES_STORAGE_VOLUME.NAME || '+' || CAST(T_RES_STORAGE_VOLUME.NAME_FORMAT as CHAR) NATURAL_KEY, (T_RES_STORAGE_VOLUME.CAPACITY*512) CAPACITY, T_RES_STORAGE_VOLUME.POOL_ID POOL_ID, T_RES_STORAGE_VOLUME.FORMAT FORMAT, T_RES_STORAGE_VOLUME.IS_ASSIGNED IS_ASSIGNED, T_RES_STORAGE_VOLUME.USER_ATTRIB1 USER_ATTRIB1, T_RES_STORAGE_VOLUME.USER_ATTRIB2 USER_ATTRIB2, T_RES_STORAGE_VOLUME.USER_ATTRIB3 USER_ATTRIB3, T_RES_STORAGE_VOLUME.DETECTABLE DETECTABLE, T_RES_STORAGE_VOLUME.OPERATIONAL_STATUS OPERATIONAL_STATUS, T_RES_STORAGE_VOLUME.CONSOLIDATED_STATUS CONSOLIDATED_STATUS  FROM (SELECT DISTINCT \t 'server:' PREFIX_ID, \t COMPUTER.COMPUTER_ID HOST_ID,     VOLUME.SVID VOLUME_ID FROM \tT_RES_HOST COMPUTER,    T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME,    T_RES_DEV_ACCESS ACCESS,    T_RES_CONTROLLER CONTROLLER, \tT_RES_STORAGE_VOLUME VOLUME  WHERE     PHYSICAL_VOLUME.LUNSSID = VOLUME.UNIQUE_ID and    PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION SELECT DISTINCT \tHOST.PREFIX_ID, \tHOST.COMPUTER_ID HOST_ID, \tDATA_PATH.VOLUME_ID VOLUME_ID FROM \tT_RES_DATA_PATH DATA_PATH, T_RES_STORAGE_VOLUME VOLUME,  \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT WHERE \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID ) VOLUMES2HOST,     T_RES_STORAGE_VOLUME, \t T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t TMP.PREFIX_ID = VOLUMES2HOST.PREFIX_ID and \t TMP.ENTITY_ID = VOLUMES2HOST.HOST_ID and \t T_RES_STORAGE_VOLUME.SVID = VOLUMES2HOST.VOLUME_ID";

    public GraphComputer getHost(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphComputer graphComputer = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("HOST_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "Host ID is NULL");
                    continue;
                }
                String string2 = String.valueOf(string) + n2;
                if (hashMap == null || hashMap.get(string2) == null) {
                    graphComputer = new GraphComputer(string2);
                    this.populator.populateHost(resultSet, graphComputer);
                    if (graphModel != null) {
                        graphModel.put(graphComputer);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string2, graphComputer);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "Duplicated Host entry:" + string2);
            }
        }
        finally {
            block19: {
                block18: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block18;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block19;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        return graphComputer;
    }

    public void getZonesFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(connection, graphModel, hashMap, new Object[]{new Integer(n)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_HOST, SELECT_ZONES_FROM_HOST, SELECT_ZSET_FROM_HOST, SELECT_ZSET2ZONE_FROM_HOST, SELECT_ZONE2MEMBER_FROM_HOST});
    }

    public void getSwitch2HostFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "");
        }
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2HOST_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("HOST_PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("HOST_ID");
                String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n4 = (Integer)resultSet.getObject("PORT2PORT_ID");
                GraphComputer graphComputer = (GraphComputer)hashMap.get(String.valueOf(string) + n2);
                if (graphComputer == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "host not found:" + n);
                    continue;
                }
                if (n3 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String string3 = String.valueOf(string2) + n3;
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(string3);
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "Switch not found:" + string3);
                    continue;
                }
                String string4 = "port2port:" + string + n2 + ',' + string2 + n3 + ',' + n4;
                if (hashMap.get(string4) == null) {
                    GraphSwitch2Computer graphSwitch2Computer = new GraphSwitch2Computer(string4);
                    graphSwitch2Computer.setComputerID((GraphComputer.ID)graphComputer.getEntityID());
                    graphSwitch2Computer.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                    this.populator.populatePort2Port(resultSet, graphSwitch2Computer);
                    graphModel.put(graphSwitch2Computer);
                    hashMap.put(string4, graphSwitch2Computer);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "Duplicated :" + string4);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2HostFromHost", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2HostFromHost", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getSwitch2HostFromHost", "");
        }
    }

    public void getHost2VolumeFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        GraphEntity graphEntity;
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Integer n2;
        Integer n3;
        String string2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_VOLUMES_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = (String)resultSet.getObject("PREFIX_ID");
                n3 = (Integer)resultSet.getObject("HOST_ID");
                n2 = (Integer)resultSet.getObject("SVID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                object4 = String.valueOf(string2) + n3;
                object3 = (GraphComputer)hashMap.get(object4);
                if (object3 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "host not found:" + (String)object4);
                    continue;
                }
                object2 = "volume:" + n2;
                object = (GraphVolume)hashMap.get(object2);
                if (object == null) {
                    object = new GraphVolume((String)object2);
                    this.populator.populateStorageVolume(resultSet, (GraphVolume)object);
                    hashMap.put(object2, object);
                    graphModel.put((GraphEntity)object);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + (String)object2);
                }
                string = "server2volume:" + n3 + ',' + n2;
                if (hashMap.get(string) == null) {
                    graphEntity = new GraphComputer2Volume(string);
                    ((GraphComputer2Volume)graphEntity).setComputerID((GraphComputer.ID)((GraphEntity)object3).getEntityID());
                    ((GraphComputer2Volume)graphEntity).setVolumeID((GraphVolume.ID)((GraphEntity)object).getEntityID());
                    graphModel.put(graphEntity);
                    hashMap.put(string, graphEntity);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + string);
            }
        }
        finally {
            block45: {
                block44: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block44;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block45;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", sQLException);
                }
            }
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_ARRAYS_FROM_VOLUMES_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                GraphAssociation graphAssociation;
                String string3;
                GraphVolume graphVolume;
                string2 = (String)resultSet.getObject("HOST_PREFIX_ID");
                n3 = (Integer)resultSet.getObject("HOST_ID");
                n2 = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                object4 = (Integer)resultSet.getObject("VOLUME_ID");
                object3 = String.valueOf(string2.toString()) + n3;
                object2 = (GraphComputer)hashMap.get(object3);
                if (object2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "host not found:" + (String)object3);
                    continue;
                }
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                object = "subsystem:" + n2;
                string = "volume:" + object4;
                graphEntity = (GraphSubsystem)hashMap.get(object);
                if (graphEntity == null) {
                    graphEntity = new GraphSubsystem((String)object);
                    this.populator.populateSubsystem(resultSet, (GraphSubsystem)graphEntity);
                    hashMap.put(object, graphEntity);
                    graphModel.put(graphEntity);
                }
                if ((graphVolume = (GraphVolume)hashMap.get(string)) != null) {
                    string3 = "subsystem2volume:" + n2 + ',' + object4;
                    graphAssociation = new GraphSubsystem2Volume(string3);
                    ((GraphSubsystem2Volume)graphAssociation).setSubsystemID((GraphSubsystem.ID)graphEntity.getEntityID());
                    ((GraphSubsystem2Volume)graphAssociation).setVolumeID((GraphVolume.ID)graphVolume.getEntityID());
                    hashMap.put(string3, graphAssociation);
                    graphModel.put(graphAssociation);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + (String)object);
                }
                string3 = "server2volume:" + n3 + ',' + object4;
                if (hashMap.get(string3) == null) {
                    graphAssociation = new GraphComputer2Volume(string3);
                    ((GraphComputer2Volume)graphAssociation).setComputerID((GraphComputer.ID)((GraphEntity)object2).getEntityID());
                    ((GraphComputer2Volume)graphAssociation).setVolumeID((GraphVolume.ID)graphVolume.getEntityID());
                    graphModel.put(graphAssociation);
                    hashMap.put(string3, graphAssociation);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + string3);
            }
        }
        finally {
            block48: {
                block47: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block47;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block48;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
    }

    public void getSwitchFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSwitch graphSwitch = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("HOST_PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("HOST_ID");
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                GraphComputer graphComputer = (GraphComputer)hashMap.get(String.valueOf(string) + n2);
                if (graphComputer == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromHost", "MIssing host");
                    continue;
                }
                if (n3 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromHost", "SWITCH_WWN is NULL");
                    continue;
                }
                String string3 = String.valueOf(string2) + n3;
                if (hashMap == null || hashMap.get(string3) == null) {
                    graphSwitch = new GraphSwitch(string3);
                    this.populator.populateSwitch(resultSet, graphSwitch, true);
                    if (graphModel != null) {
                        graphModel.put(graphSwitch);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string3, graphSwitch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitch", "Duplicated Switch entry:" + string3);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                }
            }
        }
    }

    public void getSubsystemFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSubsystem graphSubsystem = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("HOST_PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("HOST_ID");
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                GraphComputer graphComputer = (GraphComputer)hashMap.get(String.valueOf(string) + n2);
                if (graphComputer == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystemFromHost", "Host not found server:" + n2);
                    continue;
                }
                if (n3 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystemFromHost", "SUBSYSTEM_ID is NULL");
                    continue;
                }
                String string3 = String.valueOf(string2) + n3;
                if (hashMap == null || hashMap.get(string3) == null) {
                    graphSubsystem = new GraphSubsystem(string3);
                    this.populator.populateSubsystem(resultSet, graphSubsystem);
                    if (graphModel != null) {
                        graphModel.put(graphSubsystem);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string3, graphSubsystem);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystemFromHost", "Duplicated Subsystem entry:" + string3);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
    }

    public void getHost2SubsystemFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL1.class.getName(), "commit", sQLException);
            }
        }
    }

    public void getSansFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromHost(connection, graphModel, hashMap, string, new Integer(n), SELECT_SANS_FOR_HOST);
    }

    public void getSansFromSubsystem(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromSubsystem(connection, graphModel, hashMap, string, new Integer(n), SELECT_SANS_FROM_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST);
    }

    public void getSansFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        this.getSansFromSwitch(connection, graphModel, hashMap, new Object[]{new Integer(n)}, SELECT_SANS_FROM_SWITCH_FROM_HOST);
    }

    public void getLUN(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        GraphEntity graphEntity;
        Object object;
        GraphEntity graphEntity2;
        String string;
        Object object2;
        Object object3;
        Object object4;
        Integer n2;
        Integer n3;
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        System.currentTimeMillis();
        try {
            preparedStatement = connection.prepareStatement(SELECT_LUN_FROM_HOST);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n3 = (Integer)resultSet.getObject("VOLUME_ID");
                n2 = (Integer)resultSet.getObject("HOST_ID");
                object4 = (Integer)resultSet.getObject("DEVICE_ID");
                object3 = (Integer)resultSet.getObject("HOST_LUN_ID");
                object2 = (String)resultSet.getObject("PATH");
                string = "lun:" + object4;
                graphEntity2 = new GraphLun(string);
                if (object3 != null) {
                    try {
                        ((GraphLun)graphEntity2).setLunID(new Integer((Integer)object3));
                    }
                    catch (Exception exception) {}
                }
                graphEntity2.setDisplayName((String)object2);
                graphEntity2.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                object = (GraphComputer)hashMap.get("server:" + n2);
                if (object == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "Host not found: server:" + n2);
                    continue;
                }
                graphEntity = (GraphVolume)hashMap.get("volume:" + n3);
                if (graphEntity == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "Volume not found: volume:" + n3);
                    continue;
                }
                graphModel.put(graphEntity2);
                hashMap.put(string, graphEntity2);
                String string2 = "server2lun:" + n2 + ',' + object4;
                GraphComputer2Lun graphComputer2Lun = new GraphComputer2Lun(string2);
                graphComputer2Lun.setLunID((GraphLun.ID)graphEntity2.getEntityID());
                graphComputer2Lun.setComputerID((GraphComputer.ID)((GraphEntity)object).getEntityID());
                graphModel.put(graphComputer2Lun);
                hashMap.put(string2, graphComputer2Lun);
                String string3 = "lun2volume:" + n3 + ',' + object4;
                GraphVolume2Lun graphVolume2Lun = new GraphVolume2Lun(string3);
                graphVolume2Lun.setLunID((GraphLun.ID)graphEntity2.getEntityID());
                graphVolume2Lun.setVolumeID((GraphVolume.ID)graphEntity.getEntityID());
                graphModel.put(graphVolume2Lun);
                hashMap.put(string3, graphVolume2Lun);
            }
        }
        finally {
            block35: {
                block34: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block34;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block35;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                }
            }
        }
        System.currentTimeMillis();
        try {
            preparedStatement = connection.prepareStatement(SELECT_FILESYSTEM_SIMPLE_FROM_LUN);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer cfr_ignored_0 = (Integer)resultSet.getObject("HOST_ID");
                n3 = (Integer)resultSet.getObject("FILESYSTEM_ID");
                Integer cfr_ignored_1 = (Integer)resultSet.getObject("VOLUME_ID");
                n2 = (Integer)resultSet.getObject("DEVICE_ID");
                Integer cfr_ignored_2 = (Integer)resultSet.getObject("LUN");
                object4 = (String)resultSet.getObject("MOUNT_POINT");
                object3 = "lun:" + n2;
                object2 = (GraphLun)hashMap.get(object3);
                if (object2 == null) continue;
                string = "filesystem:" + n3;
                graphEntity2 = new GraphFilesystem(string);
                graphEntity2.setDisplayName((String)object4);
                graphModel.put(graphEntity2);
                hashMap.put(string, graphEntity2);
                object = "fs2lun:" + n3 + ',' + n2;
                graphEntity = new GraphFilesystem2Lun((String)object);
                ((GraphFilesystem2Lun)graphEntity).setFilesystemID((GraphFilesystem)graphEntity2);
                ((GraphFilesystem2Lun)graphEntity).setLunID((GraphLun)object2);
                graphModel.put(graphEntity);
                hashMap.put(object, graphEntity);
            }
        }
        finally {
            block38: {
                block37: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block37;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block38;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", sQLException);
                }
            }
        }
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getView", "");
        }
        GraphModelComputerL1 graphModelComputerL1 = null;
        GraphModel.MultiEntityID multiEntityID = (GraphModel.MultiEntityID)viewerRequest.getModelID();
        this.removeTmpHosts(connection, n);
        try {
            this.setTmpEntity(connection, multiEntityID.getChildFocusEntityIDs(), n);
            HashMap hashMap = new HashMap();
            Timestamp timestamp = viewerRequest.getTimestamp();
            Timestamp timestamp2 = null;
            if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
                graphModelComputerL1 = new GraphModelComputerL1((GraphModelComputerL1.ID)viewerRequest.getModelID());
                if (this.getHost(connection, graphModelComputerL1, hashMap, n) != null) {
                    this.getSwitchFromHost(connection, graphModelComputerL1, hashMap, n);
                    this.getSwitch2HostFromHost(connection, graphModelComputerL1, hashMap, n);
                    this.getSubsystemFromHost(connection, graphModelComputerL1, hashMap, n);
                    this.getHost2SubsystemFromHost(connection, graphModelComputerL1, hashMap, n);
                    this.commit(connection);
                    this.getHost2VolumeFromHost(connection, graphModelComputerL1, hashMap, n);
                    this.getSansFromSwitch(connection, graphModelComputerL1, hashMap, n);
                    this.commit(connection);
                    if (viewerRequest.getModelID().isNeedZoneData()) {
                        this.getZonesFromHost(connection, graphModelComputerL1, hashMap, n);
                    }
                    this.commit(connection);
                    graphModelComputerL1.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
                }
                graphModelComputerL1.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
                viewerResponse.addResponse(0, graphModelComputerL1);
            } else {
                viewerResponse.addResponse(0, null);
            }
        }
        finally {
            this.removeTmpHosts(connection, n);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getView", "");
        }
    }
}

