/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL1;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL2;

public class ViewerSwitchL1
extends ViewerSwitchL2 {
    private static final boolean debug = false;
    public static final String SELECT_SWITCH = "SELECT \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 FROM \tT_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_MODEL MODEL on \tT_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    T_RES_SWITCH.PREFIX_ID = TMP.PREFIX_ID and    T_RES_SWITCH.SWITCH_ID = TMP.ENTITY_ID and    TMP.ID = ?";
    public static final String SELECT_HOST_FROM_SWITCH = "SELECT \tTMP.PREFIX_ID SWITCH_PREFIX_ID, \tTMP.ENTITY_ID SWITCH_ID, \t\tT_RES_HOST.PREFIX_ID, \t    CASE WHEN T_RES_HOST.HOST_NAME IS NOT NULL THEN T_RES_HOST.HOST_NAME \t\t\t WHEN T_RES_HOST.HOST_URL IS NOT NULL THEN T_RES_HOST.HOST_URL \t\t\t ELSE CAST(T_RES_HOST.COMPUTER_ID as CHAR(10)) \t\tEND  DISPLAY_NAME,        T_RES_HOST.DEV_STATUS DEV_STATUS,        T_RES_HOST.DAT_STATUS DAT_STATUS, \t\tT_RES_HOST.HOST_NAME HOST_NAME, \t\tT_RES_HOST.COMPUTER_ID HOST_ID, \t\tT_RES_HOST.GUID GUID, \t\tT_RES_HOST.OS_TYPE OS_TYPE,\t\tT_RES_HOST.OS_VERSION OS_VERSION,\t\tT_RES_HOST.TIME_ZONE TIME_ZONE,\t\tT_RES_HOST.IP_ADDRESS IP_ADDRESS,\t\tT_RES_HOST.DETECTABLE DETECTABLE, \t\tT_RES_HOST.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_HOST.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HOST.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HOST.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_HOST.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_HOST.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VSWITCH2HOST SWITCH2HOST, \tT_VIEW_VHOST T_RES_HOST, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    T_RES_HOST.PREFIX_ID = SWITCH2HOST.HOST_PREFIX_ID and \tT_RES_HOST.COMPUTER_ID = SWITCH2HOST.HOST_ID and \tTMP.PREFIX_ID = SWITCH2HOST.SWITCH_PREFIX_ID and \tTMP.ENTITY_ID = SWITCH2HOST.SWITCH_ID and \tTMP.ID = ?";
    public static final String SELECT_SWITCH2HOST_FROM_SWITCH = "SELECT distinct \t SWITCH2HOST.HOST_PREFIX_ID PREFIX_ID, \t SWITCH2HOST.HOST_ID HOST_ID,\t SWITCH2HOST.PORT2PORT_ID PORT2PORT_ID,\t SWITCH2HOST.DETECTABLE DETECTABLE, \t SWITCH2HOST.SWITCH_PREFIX_ID SWITCH_PREFIX_ID, \t SWITCH2HOST.SWITCH_ID SWITCH_ID FROM T_VIEW_VSWITCH2HOST SWITCH2HOST, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.PREFIX_ID = SWITCH2HOST.SWITCH_PREFIX_ID and \t TMP.ENTITY_ID = SWITCH2HOST.SWITCH_ID and     TMP.ID = ?";
    public static final String SELECT_ARRAY_FROM_SWITCH = "SELECT \tTMP.PREFIX_ID SWITCH_PREFIX_ID, \tTMP.ENTITY_ID SWITCH_ID, \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM,\tT_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on \tT_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\tT_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    SWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = T_RES_STORAGE_SUBSYSTEM.PREFIX_ID and \tSWITCH2SUBSYSTEM.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and \tTMP.PREFIX_ID = SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID and \tTMP.ENTITY_ID = SWITCH2SUBSYSTEM.SWITCH_ID and \tTMP.ID = ?";
    public static final String SELECT_SWITCH2SUBSYSTEM_FROM_SWITCH = "SELECT DISTINCT \tSWITCH2SUBSYSTEM.PORT2PORT_ID PORT2PORT_ID, \tSWITCH2SUBSYSTEM.SUBSYSTEM_PORT_ID PORT_ID, \tSWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID PREFIX_ID,\tSWITCH2SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID,    SWITCH2SUBSYSTEM.DETECTABLE DETECTABLE, \tSWITCH2SUBSYSTEM.SWITCH_ID SWITCH_ID, \tSWITCH2SUBSYSTEM.SWITCH_PREFIX_ID SWITCH_PREFIX_ID FROM T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID = TMP.PREFIX_ID and  \tSWITCH2SUBSYSTEM.SWITCH_ID = TMP.ENTITY_ID and \tTMP.ID = ?";
    public static final String SELECT_TAPE_FROM_SWITCH = "SELECT \tTMP.PREFIX_ID SWITCH_PREFIX_ID, \tTMP.ENTITY_ID SWITCH_ID, \t\tT_RES_TAPE_LIBRARY.PREFIX_ID, \t\tT_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID TAPE_LIBRARY_ID, \t\tCASE WHEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME)\t\t!= '' THEN T_RES_TAPE_LIBRARY.USER_PROVIDED_NAME \t\t\t WHEN T_RES_TAPE_LIBRARY.DISPLAY_NAME IS NOT NULL THEN T_RES_TAPE_LIBRARY.DISPLAY_NAME \t\t\t ELSE T_RES_TAPE_LIBRARY.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_TAPE_LIBRARY.FIRMWARE_VERSION FIRMWARE_VERSION, \t\tT_RES_TAPE_LIBRARY.MAX_CARTRIDGES MAX_CARTRIDGES, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_TAPE_LIBRARY.SERIAL_NUMBER SERIAL_NUMBER, \t\tT_RES_TAPE_LIBRARY.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_TAPE_LIBRARY.DETECTABLE DETECTABLE, \t\tT_RES_TAPE_LIBRARY.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_TAPE_LIBRARY.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_TAPE_LIBRARY.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_TAPE_LIBRARY.TOTAL_DRIVES, \t\tT_RES_TAPE_LIBRARY.TOTAL_CARTRIDGES, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_TAPE_LIBRARY.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VSWITCH2TAPE SWITCH2TAPE,\t T_VIEW_VTAPE_LIBRARY T_RES_TAPE_LIBRARY left outer join T_RES_TAPE_FRAME on \t T_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID = T_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID left outer join T_RES_VENDOR VENDOR on \t T_RES_TAPE_LIBRARY.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\t T_RES_TAPE_LIBRARY.MODEL_ID = MODEL.MODEL_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP  WHERE     SWITCH2TAPE.SWITCH_PREFIX_ID = TMP.PREFIX_ID and \t SWITCH2TAPE.SWITCH_ID = TMP.ENTITY_ID and     SWITCH2TAPE.TAPE_PREFIX_ID = T_RES_TAPE_LIBRARY.PREFIX_ID and \t SWITCH2TAPE.TAPE_LIBRARY_ID = T_RES_TAPE_LIBRARY.TAPE_LIBRARY_ID and \t TMP.ID = ?";
    public static final String SELECT_SWITCH2TAPE_FROM_SWITCH = "SELECT DISTINCT \tSWITCH2TAPE.PORT2PORT_ID PORT2PORT_ID, \tSWITCH2TAPE.TAPE_PORT_ID PORT_ID, \tSWITCH2TAPE.TAPE_PREFIX_ID PREFIX_ID, \tSWITCH2TAPE.TAPE_LIBRARY_ID TAPE_LIBRARY_ID,    SWITCH2TAPE.DETECTABLE DETECTABLE, \tSWITCH2TAPE.SWITCH_ID SWITCH_ID, \tSWITCH2TAPE.SWITCH_PREFIX_ID SWITCH_PREFIX_ID FROM T_VIEW_VSWITCH2TAPE SWITCH2TAPE, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    SWITCH2TAPE.SWITCH_PREFIX_ID = TMP.PREFIX_ID and \tSWITCH2TAPE.SWITCH_ID = TMP.ENTITY_ID and \tTMP.ID = ?";
    public static final String SELECT_OTHER_FROM_SWITCH = "SELECT \tTMP.PREFIX_ID SWITCH_PREFIX_ID, \tTMP.ENTITY_ID SWITCH_ID, \tOTHER.PREFIX_ID PREFIX_ID, \tOTHER.OTHER_ID OTHER_ID, \tOTHER.DISPLAY_NAME DISPLAY_NAME, \tOTHER.PROPAGATED_STATUS PROPAGATED_STATUS, \tOTHER.DETECTABLE DETECTABLE, \tMODEL.MODEL_NAME MODEL, \tVENDOR.VENDOR_NAME VENDOR, \tOTHER.SERIAL_NUMBER SERIAL_NUMBER, \tOTHER.OTHER_TYPE DISPLAY_TYPE ,  \tSWITCH2OTHER.PORT2PORT_ID PORT2PORT_ID FROM T_VIEW_VOTHER OTHER left outer join T_RES_MODEL MODEL on\tOTHER.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on    OTHER.VENDOR_ID = VENDOR.VENDOR_ID, T_VIEW_VSWITCH2OTHER SWITCH2OTHER, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    SWITCH2OTHER.SWITCH_PREFIX_ID = TMP.PREFIX_ID and \tSWITCH2OTHER.SWITCH_ID = TMP.ENTITY_ID and    SWITCH2OTHER.OTHER_ID = OTHER.OTHER_ID and    SWITCH2OTHER.OTHER_PREFIX_ID = OTHER.PREFIX_ID and    TMP.ID = ?";
    public static final String SELECT_SWITCH2OTHER_FROM_SWITCH = "SELECT DISTINCT \tSWITCH2OTHER.PORT2PORT_ID, \tSWITCH2OTHER.OTHER_PREFIX_ID PREFIX_ID, \tSWITCH2OTHER.OTHER_ID OTHER_ID,    SWITCH2OTHER.OTHER_PORT_ID PORT_ID,    SWITCH2OTHER.DETECTABLE DETECTABLE, \tSWITCH2OTHER.SWITCH_ID SWITCH_ID, \tSWITCH2OTHER.SWITCH_PREFIX_ID SWITCH_PREFIX_ID FROM T_VIEW_VSWITCH2OTHER SWITCH2OTHER, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    SWITCH2OTHER.SWITCH_PREFIX_ID = TMP.PREFIX_ID and \tSWITCH2OTHER.SWITCH_ID = TMP.ENTITY_ID and \tTMP.ID = ?";
    public static final String SELECT_SWITCH_FROM_SWITCH = "SELECT \tTMP.PREFIX_ID FROM_SWITCH_PREFIX_ID, \tTMP.ENTITY_ID FROM_SWITCH_ID, \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3  \t,SWITCH2SWITCH.SWITCH2_PORT_ID PORT_ID, \tSWITCH2SWITCH.PORT2PORT_ID PORT2PORT_ID FROM (select \n\t  SWITCH1.PREFIX_ID SWITCH_PREFIX_ID1, \n     SWITCH1.SWITCH_ID SWITCH_ID1, \n     SWITCH2PORT1.PORT_ID SWITCH1_PORT_ID, \n\t  SWITCH2.PREFIX_ID SWITCH_PREFIX_ID2, \n     SWITCH2.SWITCH_ID SWITCH_ID2,\n     SWITCH2PORT2.PORT_ID SWITCH2_PORT_ID, \n\t  PORT2PORT.PORT2PORT_ID PORT2PORT_ID,\n\t  PORT2PORT.DETECTABLE DETECTABLE \nFROM \nT_VIEW_PORT2PORT PORT2PORT, \n     T_VIEW_VSWITCH SWITCH2, T_VIEW_VSWITCH2PORT SWITCH2PORT1, T_VIEW_VSWITCH2PORT SWITCH2PORT2, \n\t  T_VIEW_VSWITCH SWITCH1 left outer join T_VIEW_VSWITCH SWITCH3 on \n     SWITCH1.SWITCH_WWN = SWITCH3.PARENT_SWITCH_WWN \nWHERE \n     SWITCH3.SWITCH_WWN is NULL and \n\t  SWITCH1.PREFIX_ID = SWITCH2PORT1.PREFIX_ID and \n\t  SWITCH1.SWITCH_ID = SWITCH2PORT1.SWITCH_ID and \n     SWITCH2PORT1.PORT_ID = PORT2PORT.PORT_ID1 and \n     PORT2PORT.PORT_ID2 = SWITCH2PORT2.PORT_ID and \n     SWITCH2PORT2.PREFIX_ID = SWITCH2.PREFIX_ID and \n\t  SWITCH2PORT2.SWITCH_ID = SWITCH2.SWITCH_ID \n) SWITCH2SWITCH, \tT_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\tT_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tT_RES_SWITCH.PREFIX_ID = SWITCH2SWITCH.SWITCH_PREFIX_ID2 and \tT_RES_SWITCH.SWITCH_ID = SWITCH2SWITCH.SWITCH_ID2 and    SWITCH2SWITCH.SWITCH_PREFIX_ID1 = TMP.PREFIX_ID and \tSWITCH2SWITCH.SWITCH_ID1 = TMP.ENTITY_ID and \tTMP.ID = ?";
    public static final String SELECT_SANS_FROM_SWITCH = "SELECT DISTINCT    SWITCH2FABRIC.PREFIX_ID PREFIX_ID,    SWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3  FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t T_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID and \t SWITCH2FABRIC.PREFIX_ID = TMP.PREFIX_ID and \t SWITCH2FABRIC.SWITCH_ID = TMP.ENTITY_ID and \t TMP.ID = ?";

    public GraphSwitch getSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSwitch graphSwitch = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SWITCH_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch", "Switch ID is NULL");
                    continue;
                }
                String string2 = String.valueOf(string) + n2;
                graphSwitch = (GraphSwitch)hashMap.get(string2);
                if (hashMap == null || graphSwitch == null) {
                    graphSwitch = new GraphSwitch(string2);
                    this.populator.populateSwitch(resultSet, graphSwitch, true);
                    if (graphModel != null) {
                        graphModel.put(graphSwitch);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string2, graphSwitch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch", "Duplicated Switch entry:" + string2);
            }
        }
        finally {
            block19: {
                block18: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block18;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block19;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch", sQLException);
                }
            }
        }
        return graphSwitch;
    }

    public void getSwitch2HostFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "");
        }
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2HOST_FROM_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("HOST_ID");
                String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n4 = (Integer)resultSet.getObject("PORT2PORT_ID");
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string2) + n3);
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "switch not found:server:" + n3);
                    continue;
                }
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "NULL column field HOST_ID from host");
                    continue;
                }
                String string3 = String.valueOf(string) + n2;
                GraphComputer graphComputer = (GraphComputer)hashMap.get(string3);
                if (graphComputer == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "Host not found:" + string3);
                    continue;
                }
                String string4 = "port2port:" + string + n2 + ',' + string2 + n3 + ',' + n4;
                if (hashMap.get(string4) == null) {
                    GraphSwitch2Computer graphSwitch2Computer = new GraphSwitch2Computer(string4);
                    graphSwitch2Computer.setComputerID((GraphComputer.ID)graphComputer.getEntityID());
                    graphSwitch2Computer.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                    this.populator.populatePort2Port(resultSet, graphSwitch2Computer);
                    graphModel.put(graphSwitch2Computer);
                    hashMap.put(string4, graphSwitch2Computer);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "Duplicated :" + string4);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSwitchL1.class.getName(), "getSwitch2HostFromSwitch", "");
        }
    }

    public void getHostFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphComputer graphComputer = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_HOST_FROM_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SWITCH_ID");
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("HOST_ID");
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string) + n2);
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getHostFromSwitch", "Missing switch");
                    continue;
                }
                if (n3 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getHostFromSwitch", "HOST_ID is NULL");
                    continue;
                }
                String string3 = String.valueOf(string2) + n3;
                if (hashMap == null || hashMap.get(string3) == null) {
                    graphComputer = new GraphComputer(string3);
                    this.populator.populateHost(resultSet, graphComputer);
                    if (graphModel != null) {
                        graphModel.put(graphComputer);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string3, graphComputer);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getHost", "Duplicated Host entry:" + string3);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getHost", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getHost", sQLException);
                }
            }
        }
    }

    public void getSubsystemFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSubsystem graphSubsystem = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_ARRAY_FROM_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string2) + n3);
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSubsystemFromSwitch", "Missing switch");
                    continue;
                }
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSubsystemFromSwitch", "SUBSYSTEM_ID is NULL");
                    continue;
                }
                String string3 = String.valueOf(string) + n2;
                if (hashMap == null || hashMap.get(string3) == null) {
                    graphSubsystem = new GraphSubsystem(string3);
                    this.populator.populateSubsystem(resultSet, graphSubsystem);
                    if (graphModel != null) {
                        graphModel.put(graphSubsystem);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string3, graphSubsystem);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSubsystemFromSwitch", "Duplicated Subsystem entry:" + string3);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSubsystem", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
    }

    public void getSwitch2SubsystemFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSubsystem graphSubsystem = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2SUBSYSTEM_FROM_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    String string = (String)resultSet.getObject("PREFIX_ID");
                    Integer n2 = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                    Integer n3 = (Integer)resultSet.getObject("PORT2PORT_ID");
                    String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                    Integer n4 = (Integer)resultSet.getObject("SWITCH_ID");
                    GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string2) + n4);
                    if (graphSwitch == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SubsystemFromSwitch", "Missing switch");
                        continue;
                    }
                    if (n2 == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SubsystemFromSwitch", "SUBSYSTEM_ID is NULL");
                        continue;
                    }
                    String string3 = String.valueOf(string) + n2;
                    graphSubsystem = (GraphSubsystem)hashMap.get(string3);
                    if (graphSubsystem != null) {
                        String string4 = "port2port:" + n3;
                        GraphSwitch2Subsystem graphSwitch2Subsystem = (GraphSwitch2Subsystem)hashMap.get(string4);
                        if (string4 == null) continue;
                        graphSwitch2Subsystem = new GraphSwitch2Subsystem(string4);
                        graphSwitch2Subsystem.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                        graphSwitch2Subsystem.setSubsystemID((GraphSubsystem.ID)graphSubsystem.getEntityID());
                        this.populator.populatePort2Port(resultSet, graphSwitch2Subsystem);
                        graphModel.put(graphSwitch2Subsystem);
                        hashMap.put(string4, graphSwitch2Subsystem);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SubsystemFromSwitch", "Missing array entry:" + string3);
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2SubsystemFromSwitch", exception);
                }
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Subsystem", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Subsystem", sQLException);
                }
            }
        }
    }

    public void getTapeFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphTapeLibrary graphTapeLibrary = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_TAPE_FROM_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string2) + n3);
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getTapeFromSwitch", "Missing switch");
                    continue;
                }
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getTapeFromSwitch", "TAPE_LIBRARY_ID is NULL");
                    continue;
                }
                String string3 = String.valueOf(string) + n2;
                if (hashMap == null || hashMap.get(string3) == null) {
                    graphTapeLibrary = new GraphTapeLibrary(string3);
                    this.populator.populateTapeLibrary(resultSet, graphTapeLibrary);
                    if (graphModel != null) {
                        graphModel.put(graphTapeLibrary);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string3, graphTapeLibrary);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getTapeFromSwitch", "Duplicated Tape entry:" + string3);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getTape", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getTape", sQLException);
                }
            }
        }
    }

    public void getSwitch2TapeFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphTapeLibrary graphTapeLibrary = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2TAPE_FROM_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    String string = (String)resultSet.getObject("PREFIX_ID");
                    Integer n2 = (Integer)resultSet.getObject("TAPE_LIBRARY_ID");
                    Integer n3 = (Integer)resultSet.getObject("PORT2PORT_ID");
                    String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                    Integer n4 = (Integer)resultSet.getObject("SWITCH_ID");
                    GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string2) + n4);
                    if (graphSwitch == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SubsystemFromSwitch", "Missing switch");
                        continue;
                    }
                    if (n2 == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2TapeFromSwitch", "TAPE_LIBRARY_ID is NULL");
                        continue;
                    }
                    String string3 = String.valueOf(string) + n2;
                    graphTapeLibrary = (GraphTapeLibrary)hashMap.get(string3);
                    if (graphTapeLibrary != null) {
                        String string4 = "port2port:" + n3;
                        GraphSwitch2TapeLibrary graphSwitch2TapeLibrary = (GraphSwitch2TapeLibrary)hashMap.get(string4);
                        if (string4 == null) continue;
                        graphSwitch2TapeLibrary = new GraphSwitch2TapeLibrary(string4);
                        graphSwitch2TapeLibrary.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                        graphSwitch2TapeLibrary.setTapeLibraryID((GraphTapeLibrary.ID)graphTapeLibrary.getEntityID());
                        this.populator.populatePort2Port(resultSet, graphSwitch2TapeLibrary);
                        graphModel.put(graphSwitch2TapeLibrary);
                        hashMap.put(string4, graphSwitch2TapeLibrary);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2TapeFromSwitch", "Missing tape entry:" + string3);
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2TapeFromSwitch", exception);
                }
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Tape", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Tape", sQLException);
                }
            }
        }
    }

    public void getOtherFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphOther graphOther = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_OTHER_FROM_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("OTHER_ID");
                String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SWITCH_ID");
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string2) + n3);
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getOtherFromSwitch", "Missing switch");
                    continue;
                }
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getOtherFromSwitch", "OTHER_ID is NULL");
                    continue;
                }
                String string3 = String.valueOf(string) + n2;
                if (hashMap == null || hashMap.get(string3) == null) {
                    graphOther = new GraphOther(string3);
                    this.populator.populateOther(resultSet, graphOther);
                    if (graphModel != null) {
                        graphModel.put(graphOther);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string3, graphOther);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getOther", "Duplicated Other entry:" + string3);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getOther", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getOther", sQLException);
                }
            }
        }
    }

    public void getSwitch2OtherFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphOther graphOther = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2OTHER_FROM_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    String string = (String)resultSet.getObject("PREFIX_ID");
                    Integer n2 = (Integer)resultSet.getObject("OTHER_ID");
                    Integer n3 = (Integer)resultSet.getObject("PORT2PORT_ID");
                    String string2 = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                    Integer n4 = (Integer)resultSet.getObject("SWITCH_ID");
                    GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(String.valueOf(string2) + n4);
                    if (graphSwitch == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SubsystemFromSwitch", "Missing switch");
                        continue;
                    }
                    if (n2 == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2OtherFromSwitch", "OTHER_ID is NULL");
                        continue;
                    }
                    String string3 = String.valueOf(string) + n2;
                    graphOther = (GraphOther)hashMap.get(string3);
                    if (graphOther != null) {
                        String string4 = "port2port:" + n3;
                        GraphSwitch2Other graphSwitch2Other = (GraphSwitch2Other)hashMap.get(string4);
                        if (string4 == null) continue;
                        graphSwitch2Other = new GraphSwitch2Other(string4);
                        graphSwitch2Other.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                        graphSwitch2Other.setOtherID((GraphOther.ID)graphOther.getEntityID());
                        this.populator.populatePort2Port(resultSet, graphSwitch2Other);
                        graphModel.put(graphSwitch2Other);
                        hashMap.put(string4, graphSwitch2Other);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2OtherFromSwitch", "Missing other entry:" + string3);
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2OtherFromSwitch", exception);
                }
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Other", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Other", sQLException);
                }
            }
        }
    }

    public void getSwitch2SwitchFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSwitch graphSwitch = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH_FROM_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    String string = (String)resultSet.getObject("PREFIX_ID");
                    Integer n2 = (Integer)resultSet.getObject("SWITCH_ID");
                    Integer n3 = (Integer)resultSet.getObject("PORT2PORT_ID");
                    String string2 = (String)resultSet.getObject("FROM_SWITCH_PREFIX_ID");
                    Integer n4 = (Integer)resultSet.getObject("FROM_SWITCH_ID");
                    GraphSwitch graphSwitch2 = (GraphSwitch)hashMap.get(String.valueOf(string2) + n4);
                    if (graphSwitch2 == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SwitchFromSwitch", "Missing switch");
                        continue;
                    }
                    if (n2 == null) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SwitchFromSwitch", "SWITCH_ID is NULL");
                        continue;
                    }
                    String string3 = String.valueOf(string) + n2;
                    graphSwitch = (GraphSwitch)hashMap.get(string3);
                    if (graphSwitch == null) {
                        graphSwitch = new GraphSwitch(string3);
                        this.populator.populateSwitch(resultSet, graphSwitch, true);
                        if (graphModel != null) {
                            graphModel.put(graphSwitch);
                        }
                        if (hashMap != null) {
                            hashMap.put(string3, graphSwitch);
                        }
                    }
                    if (graphSwitch != null) {
                        String string4 = "port2port:" + n3;
                        GraphSwitch2Switch graphSwitch2Switch = (GraphSwitch2Switch)hashMap.get(string4);
                        if (string4 == null) continue;
                        graphSwitch2Switch = new GraphSwitch2Switch(string4);
                        graphSwitch2Switch.setSwitch1ID((GraphSwitch.ID)graphSwitch2.getEntityID());
                        graphSwitch2Switch.setSwitch2ID((GraphSwitch.ID)graphSwitch.getEntityID());
                        this.populator.populatePort2Port(resultSet, graphSwitch2Switch);
                        graphModel.put(graphSwitch2Switch);
                        hashMap.put(string4, graphSwitch2Switch);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSwitchL1.class.getName(), "getSwitch2SwitchFromSwitch", "Missing switch entry:" + string3);
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2SwitchFromSwitch", exception);
                }
            }
        }
        finally {
            block24: {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Switch", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block24;
                    TraceLogger.exception(ViewerSwitchL1.class.getName(), "getSwitch2Switch", sQLException);
                }
            }
        }
    }

    public void getSansFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSanL1.class.getName(), "getSansFromSwitch", "");
        }
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        System.currentTimeMillis();
        try {
            preparedStatement = connection.prepareStatement(SELECT_SANS_FROM_SWITCH);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n3 = (Integer)resultSet.getObject("FABRIC_ID");
                GraphSwitch graphSwitch = new GraphSwitch(String.valueOf(string) + n2);
                GraphFabric graphFabric = new GraphFabric("fabric:" + n3);
                this.populator.populateSan(resultSet, graphFabric);
                GraphFabric2Switch graphFabric2Switch = new GraphFabric2Switch("fabric2switch:" + n3 + ',' + n2);
                graphFabric2Switch.setFabricID((GraphFabric.ID)graphFabric.getEntityID());
                graphFabric2Switch.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                graphModel.put(graphFabric);
                graphModel.put(graphFabric2Switch);
            }
        }
        finally {
            block18: {
                block17: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!TraceLogger.enableTrace) break block17;
                        TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSwitch", exception);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    if (!TraceLogger.enableTrace) break block18;
                    TraceLogger.exception(ViewerSanL1.class.getName(), "getSansFromSwitch", exception);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSanL1.class.getName(), "getSansFromSwitch", "");
        }
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerSwitchL1.class.getName(), "commit", sQLException);
            }
        }
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getView", "");
        }
        GraphModelSwitchL1 graphModelSwitchL1 = null;
        GraphModel.MultiEntityID multiEntityID = (GraphModel.MultiEntityID)viewerRequest.getModelID();
        this.removeTmpHosts(connection, n);
        try {
            this.setTmpEntity(connection, multiEntityID.getChildFocusEntityIDs(), n);
            HashMap hashMap = new HashMap();
            Timestamp timestamp = viewerRequest.getTimestamp();
            Timestamp timestamp2 = null;
            if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
                graphModelSwitchL1 = new GraphModelSwitchL1((GraphModelSwitchL1.ID)viewerRequest.getModelID());
                if (this.getSwitch(connection, graphModelSwitchL1, hashMap, n) != null) {
                    this.getSwitch2SwitchFromSwitch(connection, graphModelSwitchL1, hashMap, n);
                    this.getHostFromSwitch(connection, graphModelSwitchL1, hashMap, n);
                    this.getSwitch2HostFromSwitch(connection, graphModelSwitchL1, hashMap, n);
                    this.getSubsystemFromSwitch(connection, graphModelSwitchL1, hashMap, n);
                    this.getSwitch2SubsystemFromSwitch(connection, graphModelSwitchL1, hashMap, n);
                    this.getTapeFromSwitch(connection, graphModelSwitchL1, hashMap, n);
                    this.getSwitch2TapeFromSwitch(connection, graphModelSwitchL1, hashMap, n);
                    this.getOtherFromSwitch(connection, graphModelSwitchL1, hashMap, n);
                    this.getSwitch2OtherFromSwitch(connection, graphModelSwitchL1, hashMap, n);
                    this.getSansFromSwitch(connection, graphModelSwitchL1, hashMap, n);
                    this.commit(connection);
                }
                graphModelSwitchL1.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
                viewerResponse.addResponse(0, graphModelSwitchL1);
            } else {
                viewerResponse.addResponse(0, null);
            }
        }
        finally {
            this.removeTmpHosts(connection, n);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getView", "");
        }
    }
}

