/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util;

import com.ibm.log.Level;
import com.ibm.log.util.MessageCatalog;
import java.util.Dictionary;
import java.util.Vector;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.util.resources.ServiceUtilMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ServiceUtil
implements IDisposable {
    private Vector<ServiceCacheEntry> serviceCache = new Vector();
    private static final String RESOURCE_BUNDLE = ServiceUtilMessages.class.getName();
    private static MessageCatalog messageCatalog;
    private static final String CLASS_NAME;
    private static final String MSG = "aperi.logger.message.ServiceUtil";
    private static final String TRACE = "aperi.logger.trace.ServiceUtil";
    private static ILogger msgLogger;
    private static ILogger traceLogger;

    static {
        CLASS_NAME = ServiceUtil.class.getName();
        msgLogger = LogManagerFactory.getMessageLogger(MSG);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE);
        msgLogger.setMessageFile(RESOURCE_BUNDLE);
        messageCatalog = new MessageCatalog(RESOURCE_BUNDLE);
    }

    public void addService(IService iService, Class clazz, Dictionary dictionary) {
        this.serviceCache.add(new ServiceCacheEntry(iService, clazz, dictionary));
    }

    public void start(BundleContext bundleContext) throws Exception {
        for (ServiceCacheEntry serviceCacheEntry : this.serviceCache) {
            try {
                if (!serviceCacheEntry._started) {
                    this.startService(serviceCacheEntry._serviceImpl);
                }
                serviceCacheEntry._serviceRegistration = this.registerService(bundleContext, serviceCacheEntry._serviceImpl, serviceCacheEntry._serviceInterface, serviceCacheEntry._serviceDictionary);
                serviceCacheEntry._started = true;
            }
            catch (Exception exception) {
                try {
                    msgLogger.message(Level.INFO, CLASS_NAME, "start", "STARTUP_FAILED_SHUTTING_DOWN");
                    this.stop();
                }
                catch (Exception exception2) {}
                throw exception;
            }
        }
    }

    public void stop() throws Exception {
        Exception exception = null;
        while (!this.serviceCache.isEmpty()) {
            ServiceCacheEntry serviceCacheEntry = this.serviceCache.lastElement();
            this.serviceCache.remove(serviceCacheEntry);
            try {
                if (!serviceCacheEntry._started) continue;
                this.unregisterService(serviceCacheEntry._serviceRegistration, serviceCacheEntry._serviceImpl.getName());
                this.stopService(serviceCacheEntry._serviceImpl);
                serviceCacheEntry._started = false;
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                traceLogger.exception(Level.ERROR, CLASS_NAME, "stop", exception2, "Failed to stop service " + serviceCacheEntry._serviceImpl.getName());
                exception = exception2;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void startService(IService iService) throws Exception {
        Exception exception = null;
        boolean bl = false;
        msgLogger.message(Level.INFO, (Object)CLASS_NAME, "startService", "STARTING_SERVICE", iService.getName());
        try {
            bl = iService.startup();
        }
        catch (Throwable throwable) {
            exception = new Exception(messageCatalog.getMessage("FAILED_STARTUP", (Object)iService.getName()), throwable);
            traceLogger.exception(Level.ERROR, CLASS_NAME, "startService", exception);
        }
        if (!bl) {
            msgLogger.message(Level.INFO, (Object)CLASS_NAME, "startService", "FAILED_STARTUP", iService.getName());
            if (exception == null) {
                exception = new Exception(messageCatalog.getMessage("FAILED_STARTUP", (Object)iService.getName()));
            }
            throw exception;
        }
        msgLogger.message(Level.INFO, (Object)CLASS_NAME, "startService", "STARTED_SERVICE", iService.getName());
    }

    private void stopService(IService iService) throws Exception {
        boolean bl = false;
        Exception exception = null;
        msgLogger.message(Level.INFO, (Object)CLASS_NAME, "stopService", "STOPPING_SERVICE", iService.getName());
        try {
            bl = iService.shutdown();
        }
        catch (Throwable throwable) {
            exception = new Exception(messageCatalog.getMessage("FAILED_STOP", (Object)iService.getName()), throwable);
            traceLogger.exception(Level.ERROR, CLASS_NAME, "stopService", exception);
        }
        if (!bl) {
            msgLogger.message(Level.INFO, (Object)CLASS_NAME, "stopService", "FAILED_STOP", iService.getName());
            if (exception != null) {
                exception = new Exception(messageCatalog.getMessage("FAILED_STOP", (Object)iService.getName()));
            }
            throw exception;
        }
        msgLogger.message(Level.INFO, (Object)CLASS_NAME, "stopService", "STOPPED_SERVICE", iService.getName());
    }

    private ServiceRegistration registerService(BundleContext bundleContext, IService iService, Class clazz, Dictionary dictionary) {
        ServiceRegistration serviceRegistration = null;
        traceLogger.text(Level.INFO, CLASS_NAME, "registerService", "Registering service: " + iService.getName());
        serviceRegistration = bundleContext.registerService(clazz.getName(), (Object)iService, dictionary);
        traceLogger.text(Level.INFO, CLASS_NAME, "registerService", "Registration completed for service: " + iService.getName());
        return serviceRegistration;
    }

    private void unregisterService(ServiceRegistration serviceRegistration, String string) {
        traceLogger.text(Level.INFO, CLASS_NAME, "unregisterService", "Unregistering service: " + string);
        Bundle[] bundleArray = serviceRegistration.getReference().getUsingBundles();
        if (bundleArray != null && bundleArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The service " + string + " is being unregistered" + " but it is still in use by the following bundles: \n");
            int n = 0;
            while (n < bundleArray.length) {
                stringBuffer.append("  ");
                stringBuffer.append(bundleArray[n].getLocation());
                if (n != bundleArray.length - 1) {
                    stringBuffer.append("\n");
                }
                ++n;
            }
            traceLogger.text(Level.WARN, CLASS_NAME, "unregisterService", stringBuffer.toString());
        }
        serviceRegistration.unregister();
        traceLogger.text(Level.INFO, CLASS_NAME, "unregisterService", "Unregistered service: " + string);
    }

    public void dispose() {
        this.serviceCache = null;
    }

    private class ServiceCacheEntry {
        private IService _serviceImpl = null;
        private Class _serviceInterface = null;
        private Dictionary _serviceDictionary = null;
        private ServiceRegistration _serviceRegistration = null;
        private boolean _started = false;

        public ServiceCacheEntry(IService iService, Class clazz, Dictionary dictionary) {
            this._serviceImpl = iService;
            this._serviceInterface = clazz;
            this._serviceDictionary = dictionary;
            this._serviceRegistration = null;
        }
    }
}

