/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.xmsg.IntlMessageFormat;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.LoggerRegistry;
import org.eclipse.aperi.xmsg.MessageBundleManager;
import org.eclipse.aperi.xmsg.MessageFormatter;
import org.eclipse.aperi.xmsg.MessageRegistry;
import org.eclipse.aperi.xmsg.MessageTextRenderer;
import org.eclipse.aperi.xmsg.OSException;
import org.eclipse.aperi.xmsg.TextRendererProvider;
import org.eclipse.aperi.xmsg.WrappedLogger;

public class MessageLog
extends TextRendererProvider
implements MessageTextRenderer,
WrappedLogger {
    public static final String TEXT_UNAVAILABLE = "<text unavailable>";
    public static final String INDENT = "                         ";
    public static final String TS_INDENT = "               ";
    public static final int TS_INDENT_LENGTH = 15;
    public static final String BUNDLE_SRC_EXTENSION_POINT_ID = "org.eclipse.aperi.common.messageSources";
    public static final String lineSeparator = System.getProperty("line.separator", "\n");
    public static final MessageFormatter messageFormatter;
    public static final DateFormat tsFormatter;
    private static final MessageBundleManager manager;
    private static final int PREPEND_NONE = 0;
    private static final int PREPEND_ID = 1;
    private static final int PREPEND_TS = 2;
    private static final String[] indents;

    static {
        MessageLog.setThreadLog(new PrintWriter(System.err, true));
        messageFormatter = new MyMessageFormatter();
        tsFormatter = MessageLog.getDateFormat();
        manager = new MessageBundleManager(BUNDLE_SRC_EXTENSION_POINT_ID);
        manager.initialize();
        MessageLog messageLog = new MessageLog();
        MessageRegistry.registerProvider(messageLog);
        LoggerRegistry.setDefaultLogger(messageLog);
        indents = new String[]{"", TS_INDENT, INDENT};
    }

    public static void setThreadLog(PrintWriter printWriter) {
        TSThread.setProperty("TSThread.key.messageLog", printWriter);
    }

    public static PrintWriter getThreadLog() {
        return (PrintWriter)TSThread.getProperty("TSThread.key.messageLog");
    }

    public static DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance(3, 2);
    }

    public static PrintWriter getDefaultLog() {
        return (PrintWriter)TSThread.getDefaultProperty("TSThread.key.messageLog");
    }

    public static void setDefaultLog(PrintWriter printWriter) {
        TSThread.setDefaultProperty("TSThread.key.messageLog", printWriter);
    }

    public static void redirectErrOut(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        System.setOut(printStream);
        System.setErr(printStream);
    }

    private static String renderMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        String string2 = TEXT_UNAVAILABLE;
        String string3 = null;
        if (resourceBundle != null) {
            try {
                string3 = resourceBundle.getString(string);
            }
            catch (Exception exception) {
                string3 = null;
            }
        }
        if (string3 != null) {
            try {
                string2 = IntlMessageFormat.format(string3, objectArray);
            }
            catch (Exception exception) {
                string2 = TEXT_UNAVAILABLE;
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(String string, String string2, Object[] objectArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(80);
        if (n > 0) {
            if (n == 2) {
                DateFormat dateFormat = tsFormatter;
                synchronized (dateFormat) {
                    stringBuffer.append(tsFormatter.format(new Date()));
                }
                stringBuffer.append(" ");
            }
            stringBuffer.append(string);
            stringBuffer.append(": ");
        }
        stringBuffer.append(string2);
        if (string2 == TEXT_UNAVAILABLE && objectArray != null) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                stringBuffer.append(lineSeparator);
                stringBuffer.append(indents[n]);
                stringBuffer.append(objectArray[n2]);
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    private static String getPieces(String string, Object[] objectArray, int n) {
        String string2 = MessageLog.renderMessage(manager.getBundle(string), string, objectArray);
        return MessageLog.format(string, string2, objectArray, n);
    }

    public static String getMessage(String string, Object[] objectArray) {
        return MessageLog.getPieces(string, objectArray, 2);
    }

    public static String getMessage(String string) {
        return MessageLog.getPieces(string, null, 2);
    }

    public static String getMessage(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return MessageLog.getPieces(string, objectArray, 2);
    }

    public static String getMessage(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return MessageLog.getPieces(string, objectArray, 2);
    }

    public static String getMessage(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return MessageLog.getPieces(string, objectArray, 2);
    }

    public static String getMessageNoTS(String string, Object[] objectArray) {
        return MessageLog.getPieces(string, objectArray, 1);
    }

    public static String getMessageNoTS(String string) {
        return MessageLog.getPieces(string, null, 1);
    }

    public static String getMessageNoTS(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return MessageLog.getPieces(string, objectArray, 1);
    }

    public static String getMessageNoTS(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return MessageLog.getPieces(string, objectArray, 1);
    }

    public static String getMessageNoTS(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return MessageLog.getPieces(string, objectArray, 1);
    }

    public static String getMessageNoID(String string, Object[] objectArray) {
        return MessageLog.getPieces(string, objectArray, 0);
    }

    public static String getMessageNoID(String string) {
        return MessageLog.getPieces(string, null, 0);
    }

    public static String getMessageNoID(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return MessageLog.getPieces(string, objectArray, 0);
    }

    public static String getMessageNoID(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return MessageLog.getPieces(string, objectArray, 0);
    }

    public static String getMessageNoID(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return MessageLog.getPieces(string, objectArray, 0);
    }

    public static void logMessage(String string, Object[] objectArray) {
        String string2 = MessageLog.getMessage(string, objectArray);
        PrintWriter printWriter = MessageLog.getThreadLog();
        printWriter.println(string2);
    }

    public static void logMessage(String string) {
        MessageLog.logMessage(string, null);
    }

    public static void logMessage(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        MessageLog.logMessage(string, objectArray);
    }

    public static void logMessage(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        MessageLog.logMessage(string, objectArray);
    }

    public static void logMessage(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        MessageLog.logMessage(string, objectArray);
    }

    public static String getMessageWithException(String string, Exception exception, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(160);
        stringBuffer.append(MessageLog.getMessage(string, objectArray));
        String string2 = exception.getMessage();
        if (string2 != null) {
            stringBuffer.append(lineSeparator);
            if (!(exception instanceof GeneralException) && !(exception instanceof LocalizableException)) {
                stringBuffer.append(INDENT);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String getMessageWithException(String string, Exception exception) {
        return MessageLog.getMessageWithException(string, exception, null);
    }

    public static String getMessageWithException(String string, Exception exception, Object object) {
        Object[] objectArray = new Object[]{object};
        return MessageLog.getMessageWithException(string, exception, objectArray);
    }

    public static String getMessageWithException(String string, Exception exception, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return MessageLog.getMessageWithException(string, exception, objectArray);
    }

    public static String getMessageWithException(String string, Exception exception, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return MessageLog.getMessageWithException(string, exception, objectArray);
    }

    public static void logException(String string, Exception exception, Object[] objectArray) {
        MessageLog.getThreadLog().println(MessageLog.getMessageWithException(string, exception, objectArray));
    }

    public static void logException(String string, Exception exception) {
        MessageLog.logException(string, exception, null);
    }

    public static void logException(String string, Exception exception, Object object) {
        Object[] objectArray = new Object[]{object};
        MessageLog.logException(string, exception, objectArray);
    }

    public static void logException(String string, Exception exception, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        MessageLog.logException(string, exception, objectArray);
    }

    public static void logException(String string, Exception exception, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        MessageLog.logException(string, exception, objectArray);
    }

    public static void logException(StorageException storageException) {
        MessageLog.getThreadLog().println(storageException.getMessage(messageFormatter));
    }

    private static native void init();

    public static void initNative() {
        StorageException.setDefaultFormatter(messageFormatter);
        OSException.load();
        MessageLog.init();
    }

    private MessageLog() {
    }

    public MessageTextRenderer lookUpRenderer(String string) {
        return this;
    }

    public String renderMessageText(String string, Object[] objectArray) {
        String string2 = MessageLog.renderMessage(manager.getBundle(string), string, objectArray);
        if (string2.equals(TEXT_UNAVAILABLE)) {
            string2 = null;
        }
        return string2;
    }

    public PrintWriter getPrintWriter() {
        return MessageLog.getThreadLog();
    }

    public String formatMessage(String string, String string2) {
        return MessageLog.format(string, string2, null, 2);
    }

    public String formatUnrecognizedMessage(String string, Object[] objectArray) {
        return MessageLog.format(string, TEXT_UNAVAILABLE, objectArray, 2);
    }

    private static class MyMessageFormatter
    implements MessageFormatter {
        private MyMessageFormatter() {
        }

        public String format(String string, Object[] objectArray) {
            return MessageLog.getMessage(string, objectArray);
        }

        public String formatSystemError(String string) {
            return MessageLog.INDENT + string;
        }
    }
}

