/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor;

import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.monitor.CIMOMEventProcessor;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;

public class CIMOMRegistrator
extends Thread {
    public static String queueName;
    private boolean shutdown = false;
    Thread thread = null;
    transient boolean busy;
    RegisteredCimom cimom;
    CIMOMEventProcessor cEvProcer = null;
    protected static String className;
    protected static ILogger msgLogger;
    protected static ILogger traceLogger;

    static {
        Class<?> clazz;
        queueName = "CIMOM Registrator";
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.CIMOMRegistrator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.SanEventCorrelatorFactory");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.SanEventCorrelatorFactory");
        msgLogger.setMessageFile(LogConstants.MSG_FILE);
    }

    public CIMOMRegistrator(CIMOMEventProcessor cIMOMEventProcessor) {
        this.setName(queueName);
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.cEvProcer = cIMOMEventProcessor;
        this.start();
    }

    public void run() {
        String string = "run";
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            this.busy = false;
            try {
                if (Configuration.debug) {
                    System.out.println(String.valueOf(queueName) + ": waiting for a job");
                }
                JobInfo jobInfo = QueueController.getInstance().getNextJob(queueName);
                if (this.shutdown) continue;
                if (jobInfo == null) {
                    System.out.println(String.valueOf(queueName) + ": Error - got a NULL job from the queue");
                    continue;
                }
                this.busy = true;
                try {
                    Object[] objectArray = (Object[])jobInfo.getRequest().getData();
                    String string2 = (String)objectArray[0];
                    this.cimom = (RegisteredCimom)objectArray[1];
                    boolean bl = false;
                    if (Configuration.debug) {
                        System.out.println(String.valueOf(queueName) + ": " + string2 + ", CIMOM: " + this.cimom.getServiceUrl());
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Executing " + string2 + " job for CIMOM " + this.cimom.getServiceUrl());
                    }
                    if (string2.equals("register")) {
                        bl = this.cEvProcer.registerIndicationListener(this.cimom);
                    } else if (string2.equals("deregister")) {
                        bl = this.cEvProcer.deregisterIndicationListener(this.cimom);
                    } else if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string, "ERROR - Invalid regType: " + string2);
                    }
                    if (Configuration.debug) {
                        System.out.println(String.valueOf(queueName) + ": completed " + string2 + " job " + (bl ? "successfully" : "with failure") + " for CIMOM at " + this.cimom.getServiceUrl());
                    }
                    if (bl) {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Successfully completed " + string2 + " job for CIMOM " + this.cimom.getServiceUrl());
                        }
                    } else if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "Failed to " + string2 + ", CIMOM: " + this.cimom.getServiceUrl());
                    }
                    jobInfo.setResponse((Response)new ObjectResponse(null, jobInfo));
                    jobInfo.setReturnCode(0);
                    jobInfo.complete(true);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    jobInfo.setReturnCode(103);
                    jobInfo.complete(false);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void shutdown() {
        String string = "shutdown";
        this.shutdown = true;
        if (this.thread != null) {
            try {
                if (this.busy) {
                    if (Configuration.debug) {
                        System.out.println(String.valueOf(queueName) + ": Still busy with CIMOM: " + this.cimom.getServiceUrl() + ", interrupting");
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string, "Still busy with CIMOM: " + this.cimom.getServiceUrl() + ", interrupting");
                    }
                }
                this.thread.interrupt();
                this.thread.join(30000L);
                this.thread = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public RegisteredCimom getCurrentCimom() {
        if (this.busy) {
            return this.cimom;
        }
        return null;
    }
}

