/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class Fabric2SwitchAlertPopulator
implements IPopulator {
    public static final String deviceType = "fabric2switch";
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.Fabric2SwitchAlertPopulator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public Fabric2SwitchAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String string) throws AlertCreationException {
        String string2 = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getFabric2SwitchData(string3, hashtable, hashtable2)) {
            short s;
            int n;
            short s2 = 114;
            int n2 = this.getResourceId(string3, hashtable);
            int n3 = EventDBAccessor.getAlertIDByResource(s2, n2, n = 117);
            if (n3 <= 0) {
                int n4 = -1;
                s = 114;
                n3 = EventDBAccessor.getAlertIDByResource(s, n4, n);
            }
            if (n3 > 0) {
                String string4;
                String string5;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n3;
                alertDefinition.aldProductID = 0;
                s = 1;
                int n5 = EventDBAccessor.getComputerId(s);
                int n6 = 106;
                int[] nArray = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] nArray2 = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string6 = "TPC_NEW_RELATIONSHIP_EVENT";
                hashtable.put("eventType", string6);
                hashtable2.put("eventType", string6);
                int n7 = 0;
                while (n7 < nArray2.length) {
                    String string7 = this.getPRValue(n7, hashtable);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable3.put(nArray2[n7], string7);
                    ++n7;
                }
                String string8 = "PhysicalRelationshipEvent";
                int n8 = 0;
                while (n8 < prTecSlotNames.length) {
                    string5 = (String)hashtable2.get(prTecSlotNames[n8]);
                    if (string5 == null) {
                        string5 = "";
                    }
                    hashtable4.put(prTecSlotNames[n8], string5);
                    ++n8;
                }
                String string9 = "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string9);
                string5 = "ALR4066I";
                Object[] objectArray = null;
                String string10 = (String)hashtable.get("fromObjectHLDLabel");
                if (string10 == null) {
                    string10 = "";
                }
                if ((string4 = (String)hashtable.get("toObjectHLDLabel")) == null) {
                    string4 = "";
                }
                objectArray = new Object[]{string4, string10};
                fabricAlert = new FabricAlert(n5, n2, s2, alertDefinition, nArray, n6, hashtable3, string8, hashtable4, string5, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: fabric2switch" + string3);
            }
        } else {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No data found in db for device: fabric2switch" + string3);
            }
            throw new AlertCreationException("No data found in db for device: fabric2switch" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateStateChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getFabric2SwitchData(string3, hashtable, hashtable2)) {
            short s;
            int n3;
            short s2 = 114;
            int n4 = this.getResourceId(string3, hashtable);
            int n5 = EventDBAccessor.getAlertIDByResource(s2, n4, n3 = 117);
            if (n5 <= 0) {
                int n6 = -1;
                s = 114;
                n5 = EventDBAccessor.getAlertIDByResource(s, n6, n3);
            }
            if (n5 > 0) {
                String string4;
                String string5;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n5;
                alertDefinition.aldProductID = 0;
                s = 1;
                int n7 = EventDBAccessor.getComputerId(s);
                int n8 = 103;
                if (n == 1) {
                    n8 = 114;
                }
                int[] nArray = MIBConstants.BTAphysicalRelationshipEvent;
                int[][] nArray2 = MIBConstants.physicalRelationshipVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string6 = n == 1 ? "TPC_NORMAL_RELATIONSHIP_EVENT" : "TPC_MISSING_RELATIONSHIP_EVENT";
                hashtable.put("eventType", string6);
                hashtable2.put("eventType", string6);
                int n9 = 0;
                while (n9 < nArray2.length) {
                    String string7 = this.getPRValue(n9, hashtable);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable3.put(nArray2[n9], string7);
                    ++n9;
                }
                String string8 = "PhysicalRelationshipEvent";
                int n10 = 0;
                while (n10 < prTecSlotNames.length) {
                    string5 = (String)hashtable2.get(prTecSlotNames[n10]);
                    if (string5 == null) {
                        string5 = "";
                    }
                    hashtable4.put(prTecSlotNames[n10], string5);
                    ++n10;
                }
                String string9 = n == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(hashtable4, string9);
                string5 = "ALR4067W";
                if (n == 1) {
                    string5 = "ALR4068I";
                }
                Object[] objectArray = null;
                String string10 = (String)hashtable.get("fromObjectHLDLabel");
                if (string10 == null) {
                    string10 = "";
                }
                if ((string4 = (String)hashtable.get("toObjectHLDLabel")) == null) {
                    string4 = "";
                }
                objectArray = new Object[]{string4, string10};
                fabricAlert = new FabricAlert(n7, n4, s2, alertDefinition, nArray, n8, hashtable3, string8, hashtable4, string5, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: fabric2switch" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: fabric2switch" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populatePropertyChange(String string, Hashtable hashtable, Hashtable hashtable2) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String string, int n, int n2) {
        Alert alert = null;
        return alert;
    }

    private int getResourceId(String string, Hashtable hashtable) {
        int n = -1;
        String string2 = (String)hashtable.get("fabricId");
        n = string2.equals("") ? Integer.parseInt(string) : Integer.parseInt(string2);
        return n;
    }

    private void addCommonTecAttributes(Hashtable hashtable, String string) {
        String string2 = "";
        String string3 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string3 = InetAddress.getByName(string2).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        hashtable.put("hostname", string3);
        hashtable.put("origin", string2);
        hashtable.put("severity", string);
    }

    private String getPRValue(int n, Hashtable hashtable) {
        if (prVarNames[n].equals("description")) {
            return prVarNames[n];
        }
        if (prVarNames[n].equals("messageId")) {
            return prVarNames[n];
        }
        return (String)hashtable.get(prVarNames[n]);
    }

    public Alert populateStateChange(String string, int n, int n2, HashMap hashMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

