/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class HbaAlertPopulator
implements IPopulator {
    public static final String deviceType = "hba";
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.HbaAlertPopulator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public HbaAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String string) throws AlertCreationException {
        String string2 = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getHbaData(string3, hashtable, hashtable2)) {
            short s;
            short s2 = 1;
            int n = this.determineResourceId(string3, hashtable);
            int n2 = this.getAlertId(s2, n, s = 174, string3);
            if (n2 > 0) {
                String string4;
                String string5;
                String string6;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n2;
                alertDefinition.aldProductID = 0;
                int n3 = 1;
                int n4 = EventDBAccessor.getComputerId(n3);
                int n5 = 104;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string7 = "TPC_NEW_DEVICE_EVENT";
                hashtable.put("eventType", string7);
                hashtable2.put("eventType", string7);
                int n6 = 0;
                while (n6 < nArray2.length) {
                    String string8 = this.getPEValue(n6, hashtable);
                    if (string8 == null) {
                        string8 = "";
                    }
                    System.out.println("value" + n6 + " = " + string8);
                    hashtable3.put(nArray2[n6], string8);
                    ++n6;
                }
                String string9 = "PhysicalEntityEvent";
                int n7 = 0;
                while (n7 < peTecSlotNames.length) {
                    string6 = (String)hashtable2.get(peTecSlotNames[n7]);
                    if (string6 == null) {
                        string6 = "";
                    }
                    hashtable4.put(peTecSlotNames[n7], string6);
                    ++n7;
                }
                String string10 = "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string10);
                string6 = "ALR4031I";
                Object[] objectArray = null;
                String string11 = (String)hashtable.get("label");
                if (string11 == null) {
                    string11 = "";
                }
                if ((string5 = (String)hashtable.get("HLDType")) == null) {
                    string5 = "";
                }
                if ((string4 = (String)hashtable.get("HLDLabel")) == null) {
                    string4 = "";
                }
                objectArray = new Object[]{string11, string4};
                fabricAlert = new FabricAlert(n4, n, s2, alertDefinition, nArray, n5, hashtable3, string9, hashtable4, string6, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined for device: hba" + string3);
            }
        } else {
            throw new AlertCreationException("No object found for device: hba" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateStateChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getHbaData(string3, hashtable, hashtable2)) {
            short s;
            short s2 = 1;
            int n3 = this.determineResourceId(string3, hashtable);
            int n4 = this.getAlertId(s2, n3, s = 174, string3);
            if (n4 > 0) {
                String string4;
                String string5;
                String string6;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n4;
                alertDefinition.aldProductID = 0;
                int n5 = 1;
                int n6 = EventDBAccessor.getComputerId(n5);
                int n7 = 101;
                if (n == 1) {
                    n7 = 112;
                }
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string7 = n == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                hashtable.put("eventType", string7);
                hashtable2.put("eventType", string7);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string8 = this.getPEValue(n8, hashtable);
                    if (string8 == null) {
                        string8 = "";
                    }
                    hashtable3.put(nArray2[n8], string8);
                    ++n8;
                }
                String string9 = "PhysicalEntityEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    string6 = (String)hashtable2.get(peTecSlotNames[n9]);
                    if (string6 == null) {
                        string6 = "";
                    }
                    hashtable4.put(peTecSlotNames[n9], string6);
                    ++n9;
                }
                String string10 = n == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(hashtable4, string10);
                string6 = "ALR4032W";
                if (n == 1) {
                    string6 = "ALR4033I";
                }
                Object[] objectArray = null;
                String string11 = (String)hashtable.get("label");
                if (string11 == null) {
                    string11 = "";
                }
                if ((string5 = (String)hashtable.get("HLDType")) == null) {
                    string5 = "";
                }
                if ((string4 = (String)hashtable.get("HLDLabel")) == null) {
                    string4 = "";
                }
                objectArray = new Object[]{string11, string4};
                fabricAlert = new FabricAlert(n6, n3, s2, alertDefinition, nArray, n7, hashtable3, string9, hashtable4, string6, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined for device: hba" + string3);
            }
        } else {
            throw new AlertCreationException("No object found for device: hba" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populatePropertyChange(String string, Hashtable hashtable, Hashtable hashtable2) throws AlertCreationException {
        String string2 = "populatePropertyChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        short s = -1;
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        String string4 = "DRIVER_VERSION";
        String string5 = (String)hashtable.get(string4);
        String string6 = (String)hashtable2.get(string4);
        if (string5 == null || string6 == null) {
            string4 = "FIRMWARE_VERSION";
            string5 = (String)hashtable.get(string4);
            string6 = (String)hashtable2.get(string4);
            if (string5 == null || string6 == null) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "Error populating HBA Properties, " + string4 + " value is null - old Value=" + string5 + ", new Value=" + string6);
                }
                return null;
            }
        }
        if (EventDBAccessor.getHbaData(string3, hashtable3, hashtable4)) {
            short s2 = 1;
            int n = this.determineResourceId(string3, hashtable3);
            int n2 = this.getAlertId(s2, n, s = string4.equals("DRIVER_VERSION") ? (short)175 : 176, string3);
            if (n2 > 0) {
                String string7;
                String string8;
                String string9;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n2;
                alertDefinition.aldProductID = 0;
                int n3 = 1;
                int n4 = EventDBAccessor.getComputerId(n3);
                int n5 = 102;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable5 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable6 = new Hashtable<String, String>();
                String string10 = "TPC_PROPERTY_CHANGE_EVENT";
                hashtable3.put("eventType", string10);
                hashtable4.put("eventType", string10);
                int n6 = 0;
                while (n6 < nArray2.length) {
                    String string11 = this.getPEValue(n6, hashtable3);
                    if (string11 == null) {
                        string11 = "";
                    }
                    System.out.println("value" + n6 + "=" + string11);
                    hashtable5.put(nArray2[n6], string11);
                    ++n6;
                }
                String string12 = "PEAttributeModifiedEvent";
                int n7 = 0;
                while (n7 < peTecSlotNames.length) {
                    string9 = (String)hashtable4.get(peTecSlotNames[n7]);
                    if (string9 == null) {
                        string9 = "";
                    }
                    hashtable6.put(peTecSlotNames[n7], string9);
                    ++n7;
                }
                String string13 = "MINOR";
                this.addCommonTecAttributes(hashtable6, string13);
                this.addAttributeData(hashtable5, hashtable6, string4, string5, string6);
                string9 = "ALR4034W";
                if (string4.equals("FIRMWARE_VERSION")) {
                    string9 = "ALR4035W";
                }
                Object[] objectArray = null;
                String string14 = (String)hashtable3.get("label");
                if (string14 == null) {
                    string14 = "";
                }
                if ((string8 = (String)hashtable3.get("HLDType")) == null) {
                    string8 = "";
                }
                if ((string7 = (String)hashtable3.get("HLDLabel")) == null) {
                    string7 = "";
                }
                objectArray = new Object[]{string14, string7, string5, string6};
                fabricAlert = new FabricAlert(n4, n, s2, alertDefinition, nArray, n5, hashtable5, string12, hashtable6, string9, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined for device: hba" + string3);
            }
        } else {
            throw new AlertCreationException("No object found for device: hba" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateOperationalStatusChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getHbaData(string3, hashtable, hashtable2)) {
            short s;
            short s2 = 1;
            int n3 = this.determineResourceId(string3, hashtable);
            int n4 = this.getAlertId(s2, n3, s = 174, string3);
            if (n4 > 0) {
                String string4;
                String string5;
                String string6;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n4;
                alertDefinition.aldProductID = 0;
                int n5 = 1;
                int n6 = EventDBAccessor.getComputerId(n5);
                int n7 = 116;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string7 = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
                hashtable.put("eventType", string7);
                hashtable2.put("eventType", string7);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string8 = this.getPEValue(n8, hashtable);
                    if (string8 == null) {
                        string8 = "";
                    }
                    hashtable3.put(nArray2[n8], string8);
                    ++n8;
                }
                String string9 = "PEOperationalStatusChangeEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    string6 = (String)hashtable2.get(peTecSlotNames[n9]);
                    if (string6 == null) {
                        string6 = "";
                    }
                    hashtable4.put(peTecSlotNames[n9], string6);
                    ++n9;
                }
                String string10 = "MINOR";
                this.addCommonTecAttributes(hashtable4, string10);
                this.addOperationalStatusData(hashtable3, hashtable4, n, n2);
                string6 = "ALR4036W";
                Object[] objectArray = null;
                String string11 = (String)hashtable.get("label");
                if (string11 == null) {
                    string11 = "";
                }
                if ((string5 = (String)hashtable.get("HLDType")) == null) {
                    string5 = "";
                }
                if ((string4 = (String)hashtable.get("HLDLabel")) == null) {
                    string4 = "";
                }
                String string12 = "" + n;
                String string13 = "" + n2;
                objectArray = new Object[]{string11, string4, string12, string13};
                fabricAlert = new FabricAlert(n6, n3, s2, alertDefinition, nArray, n7, hashtable3, string9, hashtable4, string6, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined for device: hba" + string3);
            }
        } else {
            throw new AlertCreationException("No object found for device: hba" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    private void addAttributeData(Hashtable hashtable, Hashtable hashtable2, String string, String string2, String string3) {
        hashtable.put(MIBConstants.BTAAttributeName, string);
        hashtable.put(MIBConstants.BTAOldAttributeValue, string2);
        hashtable.put(MIBConstants.BTANewAttributeValue, string3);
        hashtable2.put("attributeName", string);
        hashtable2.put("oldValue", string2);
        hashtable2.put("newValue", string3);
    }

    private void addOperationalStatusData(Hashtable hashtable, Hashtable hashtable2, int n, int n2) {
        hashtable.put(MIBConstants.BTAOldStatus, "" + n);
        hashtable.put(MIBConstants.BTANewStatus, "" + n2);
        hashtable2.put("oldStatus", "" + n);
        hashtable2.put("newStatus", "" + n2);
    }

    private void addCommonTecAttributes(Hashtable hashtable, String string) {
        String string2 = "";
        String string3 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string3 = InetAddress.getByName(string2).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        hashtable.put("hostname", string3);
        hashtable.put("origin", string2);
        hashtable.put("severity", string);
    }

    private int determineResourceId(String string, Hashtable hashtable) {
        int n = -1;
        String string2 = (String)hashtable.get("HLDUniqueId");
        n = string2 != null && !string2.equals("") ? Integer.parseInt(string2) : Integer.parseInt(string);
        return n;
    }

    private String getPEValue(int n, Hashtable hashtable) {
        if (peVarNames[n].equals("description")) {
            return peVarNames[n];
        }
        if (peVarNames[n].equals("messageId")) {
            return peVarNames[n];
        }
        return (String)hashtable.get(peVarNames[n]);
    }

    private int getAlertId(short s, int n, short s2, String string) {
        int n2 = -1;
        n2 = EventDBAccessor.getAlertIDByResource(s, n, s2);
        if (n2 <= 0) {
            String string2 = EventDBAccessor.getFabricIdForHBA(string);
            if (string2 != null && !string2.equals("")) {
                n2 = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(string2), s2);
            }
            if (n2 <= 0) {
                n2 = EventDBAccessor.getAlertIDByResource(s, -1, s2);
            }
        }
        return n2;
    }

    public Alert populateStateChange(String string, int n, int n2, HashMap hashMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

