/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class SwitchAlertPopulator
implements IPopulator {
    public static final String deviceType = "switch";
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.SwitchAlertPopulator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public SwitchAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String string) throws AlertCreationException {
        String string2 = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getSwitchData(string3, hashtable, hashtable2)) {
            int n = 107;
            int n2 = EventDBAccessor.getAlertIDByCondition(n);
            if (n2 > 0) {
                String string4;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n2;
                alertDefinition.aldProductID = 0;
                alertDefinition.aldType = (short)31;
                alertDefinition.aldCondition = (short)n;
                int n3 = 1;
                int n4 = EventDBAccessor.getComputerId(n3);
                int n5 = Integer.parseInt(string);
                short s = 121;
                int n6 = 104;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string5 = "TPC_NEW_DEVICE_EVENT";
                hashtable.put("eventType", string5);
                hashtable2.put("eventType", string5);
                int n7 = 0;
                while (n7 < nArray2.length) {
                    String string6 = this.getPEValue(n7, hashtable);
                    if (string6 == null) {
                        string6 = "";
                    }
                    hashtable3.put(nArray2[n7], string6);
                    ++n7;
                }
                String string7 = "PhysicalEntityEvent";
                int n8 = 0;
                while (n8 < peTecSlotNames.length) {
                    string4 = (String)hashtable2.get(peTecSlotNames[n8]);
                    if (string4 == null) {
                        string4 = "";
                    }
                    hashtable4.put(peTecSlotNames[n8], string4);
                    ++n8;
                }
                String string8 = "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string8);
                string4 = "ALR4020I";
                Object[] objectArray = null;
                String string9 = (String)hashtable.get("HLDLabel");
                if (string9 == null) {
                    string9 = "";
                }
                objectArray = new Object[]{string9};
                fabricAlert = new FabricAlert(n4, n5, s, alertDefinition, nArray, n6, hashtable3, string7, hashtable4, string4, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: switch" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: switch" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateStateChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getSwitchData(string3, hashtable, hashtable2)) {
            String string4;
            int n3;
            short s;
            int n4;
            short s2 = 121;
            int n5 = Integer.parseInt(string);
            int n6 = EventDBAccessor.getAlertIDByResource(s2, n5, n4 = 95);
            if (n6 <= 0 && (n6 = EventDBAccessor.getAlertIDByResource(s = 114, n3 = Integer.parseInt(string4 = EventDBAccessor.getFabricIDFromSwitch(string)), n4)) <= 0) {
                n3 = -1;
                s = 121;
                n6 = EventDBAccessor.getAlertIDByResource(s, n3, n4);
            }
            if (n6 > 0) {
                String string5;
                string4 = new AlertDefinition();
                ((AlertDefinition)string4).aldAlertID = n6;
                ((AlertDefinition)string4).aldProductID = 0;
                ((AlertDefinition)string4).aldCondition = (short)n4;
                n3 = 1;
                s = EventDBAccessor.getComputerId(n3);
                int n7 = 101;
                if (n == 1) {
                    n7 = 112;
                }
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string6 = n == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                hashtable.put("eventType", string6);
                hashtable2.put("eventType", string6);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string7 = this.getPEValue(n8, hashtable);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable3.put(nArray2[n8], string7);
                    ++n8;
                }
                String string8 = "PhysicalEntityEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    string5 = (String)hashtable2.get(peTecSlotNames[n9]);
                    if (string5 == null) {
                        string5 = "";
                    }
                    hashtable4.put(peTecSlotNames[n9], string5);
                    ++n9;
                }
                String string9 = n == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(hashtable4, string9);
                string5 = "ALR4021W";
                if (n == 1) {
                    string5 = "ALR4022I";
                }
                Object[] objectArray = null;
                String string10 = (String)hashtable.get("HLDLabel");
                if (string10 == null) {
                    string10 = "";
                }
                objectArray = new Object[]{string10};
                fabricAlert = new FabricAlert((int)s, n5, s2, (AlertDefinition)string4, nArray, n7, hashtable3, string8, hashtable4, string5, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: switch" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: switch" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populatePropertyChange(String string, Hashtable hashtable, Hashtable hashtable2) throws AlertCreationException {
        String string2 = "populatePropertyChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        String string4 = "VERSION";
        String string5 = (String)hashtable.get(string4);
        String string6 = (String)hashtable2.get(string4);
        if (string5 == null || string6 == null) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "Error populating Switch Properties, " + string4 + " value is null - old Value=" + string5 + ", new Value=" + string6);
            }
            return null;
        }
        if (EventDBAccessor.getSwitchData(string3, hashtable3, hashtable4)) {
            String string7;
            int n;
            short s;
            int n2;
            short s2 = 121;
            int n3 = Integer.parseInt(string);
            int n4 = EventDBAccessor.getAlertIDByResource(s2, n3, n2 = 126);
            if (n4 <= 0 && (n4 = EventDBAccessor.getAlertIDByResource(s = 114, n = Integer.parseInt(string7 = EventDBAccessor.getFabricIDFromSwitch(string)), n2)) <= 0) {
                n = -1;
                s = 121;
                n4 = EventDBAccessor.getAlertIDByResource(s, n, n2);
            }
            if (n4 > 0) {
                String string8;
                string7 = new AlertDefinition();
                ((AlertDefinition)string7).aldAlertID = n4;
                ((AlertDefinition)string7).aldProductID = 0;
                ((AlertDefinition)string7).aldCondition = (short)n2;
                n = 1;
                s = EventDBAccessor.getComputerId(n);
                int n5 = 102;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable5 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable6 = new Hashtable<String, String>();
                String string9 = "TPC_PROPERTY_CHANGE_EVENT";
                hashtable3.put("eventType", string9);
                hashtable4.put("eventType", string9);
                int n6 = 0;
                while (n6 < nArray2.length) {
                    String string10 = this.getPEValue(n6, hashtable3);
                    if (string10 == null) {
                        string10 = "";
                    }
                    hashtable5.put(nArray2[n6], string10);
                    ++n6;
                }
                String string11 = "PEAttributeModifiedEvent";
                int n7 = 0;
                while (n7 < peTecSlotNames.length) {
                    string8 = (String)hashtable4.get(peTecSlotNames[n7]);
                    if (string8 == null) {
                        string8 = "";
                    }
                    hashtable6.put(peTecSlotNames[n7], string8);
                    ++n7;
                }
                String string12 = "MINOR";
                this.addCommonTecAttributes(hashtable6, string12);
                this.addAttributeData(hashtable5, hashtable6, string4, string5, string6);
                string8 = "ALR4023W";
                Object[] objectArray = null;
                String string13 = (String)hashtable3.get("HLDLabel");
                if (string13 == null) {
                    string13 = "";
                }
                objectArray = new Object[]{string13, string5, string6};
                fabricAlert = new FabricAlert((int)s, n3, s2, (AlertDefinition)string7, nArray, n5, hashtable5, string11, hashtable6, string8, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: switch" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: switch" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateOperationalStatusChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getSwitchData(string3, hashtable, hashtable2)) {
            String string4;
            int n3;
            short s;
            int n4 = Integer.parseInt(string);
            short s2 = 121;
            int n5 = n2 == 0 ? 125 : 124;
            int n6 = EventDBAccessor.getAlertIDByResource(s2, n4, n5);
            if (n6 <= 0 && (n6 = EventDBAccessor.getAlertIDByResource(s = 114, n3 = Integer.parseInt(string4 = EventDBAccessor.getFabricIDFromSwitch(string)), n5)) <= 0) {
                n3 = -1;
                s = 121;
                n6 = EventDBAccessor.getAlertIDByResource(s, n3, n5);
            }
            if (n6 > 0) {
                String string5;
                string4 = new AlertDefinition();
                ((AlertDefinition)string4).aldAlertID = n6;
                ((AlertDefinition)string4).aldProductID = 0;
                ((AlertDefinition)string4).aldCondition = (short)n5;
                n3 = 1;
                s = EventDBAccessor.getComputerId(n3);
                int n7 = 116;
                int[] nArray = MIBConstants.BTAphysicalEntityEvent;
                int[][] nArray2 = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string6 = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
                hashtable.put("eventType", string6);
                hashtable2.put("eventType", string6);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string7 = this.getPEValue(n8, hashtable);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable3.put(nArray2[n8], string7);
                    ++n8;
                }
                String string8 = "PEOperationalStatusChangeEvent";
                int n9 = 0;
                while (n9 < peTecSlotNames.length) {
                    string5 = (String)hashtable2.get(peTecSlotNames[n9]);
                    if (string5 == null) {
                        string5 = "";
                    }
                    hashtable4.put(peTecSlotNames[n9], string5);
                    ++n9;
                }
                String string9 = "MINOR";
                this.addCommonTecAttributes(hashtable4, string9);
                this.addOperationalStatusData(hashtable3, hashtable4, n, n2);
                string5 = "ALR4024W";
                if (n2 == 0) {
                    string5 = "ALR4025I";
                }
                Object[] objectArray = null;
                String string10 = (String)hashtable.get("HLDLabel");
                if (string10 == null) {
                    string10 = "";
                }
                objectArray = new Object[]{string10};
                fabricAlert = new FabricAlert((int)s, n4, s2, (AlertDefinition)string4, nArray, n7, hashtable3, string8, hashtable4, string5, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for device: switch" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: switch" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    private void addAttributeData(Hashtable hashtable, Hashtable hashtable2, String string, String string2, String string3) {
        hashtable.put(MIBConstants.BTAAttributeName, string);
        hashtable.put(MIBConstants.BTAOldAttributeValue, string2);
        hashtable.put(MIBConstants.BTANewAttributeValue, string3);
        hashtable2.put("attributeName", string);
        hashtable2.put("oldValue", string2);
        hashtable2.put("newValue", string3);
    }

    private void addOperationalStatusData(Hashtable hashtable, Hashtable hashtable2, int n, int n2) {
        hashtable.put(MIBConstants.BTAOldStatus, "" + n);
        hashtable.put(MIBConstants.BTANewStatus, "" + n2);
        hashtable2.put("oldStatus", "" + n);
        hashtable2.put("newStatus", "" + n2);
    }

    private void addCommonTecAttributes(Hashtable hashtable, String string) {
        String string2 = "";
        String string3 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string3 = InetAddress.getByName(string2).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        hashtable.put("hostname", string3);
        hashtable.put("origin", string2);
        hashtable.put("severity", string);
    }

    private String getPEValue(int n, Hashtable hashtable) {
        if (peVarNames[n].equals("description")) {
            return peVarNames[n];
        }
        if (peVarNames[n].equals("messageId")) {
            return peVarNames[n];
        }
        return (String)hashtable.get(peVarNames[n]);
    }

    public Alert populateStateChange(String string, int n, int n2, HashMap hashMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

