/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class ZoneAlertPopulator
implements IPopulator {
    public static final String deviceType = "zone";
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.ZoneAlertPopulator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public ZoneAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String string) throws AlertCreationException {
        String string2 = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getZoneData(string3, hashtable, hashtable2)) {
            int n;
            short s;
            String string4 = "TPC_NEW_DEVICE_EVENT";
            short s2 = 127;
            int n2 = Integer.parseInt(string);
            int n3 = EventDBAccessor.getAlertIDByResource(s2, n2, s = this.determineAlertCondition(string4));
            if (n3 <= 0) {
                short s3 = -1;
                n = -1;
                String string5 = (String)hashtable.get("fabricId");
                if (string5 != null && !string5.equals("")) {
                    n = Integer.parseInt(string5);
                    s3 = 114;
                    n3 = EventDBAccessor.getAlertIDByResource(s3, n, s);
                }
                if (n3 <= 0) {
                    s3 = 114;
                    n3 = EventDBAccessor.getAlertIDByResource(s3, -1, s);
                }
                if (n3 <= 0) {
                    s3 = 127;
                    n3 = EventDBAccessor.getAlertIDByResource(s3, -1, s);
                }
            }
            if (n3 > 0) {
                String string6;
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n3;
                alertDefinition.aldProductID = 0;
                n = 1;
                int n4 = EventDBAccessor.getComputerId(n);
                int n5 = 104;
                int[] nArray = MIBConstants.BTAsanRegionEvent;
                int[][] nArray2 = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string8 = "TPC_NEW_DEVICE_EVENT";
                hashtable.put("eventType", string8);
                hashtable2.put("eventType", string8);
                int n6 = 0;
                while (n6 < nArray2.length) {
                    String string9 = this.getSRValue(n6, hashtable);
                    if (string9 == null) {
                        string9 = "";
                    }
                    hashtable3.put(nArray2[n6], string9);
                    ++n6;
                }
                String string10 = "SANRegionEvent";
                int n7 = 0;
                while (n7 < srTecSlotNames.length) {
                    string7 = (String)hashtable2.get(srTecSlotNames[n7]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(srTecSlotNames[n7], string7);
                    ++n7;
                }
                String string11 = "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string11);
                string7 = "ALR4051I";
                Object[] objectArray = null;
                String string12 = (String)hashtable.get("SANName");
                if (string12 == null) {
                    string12 = "";
                }
                if ((string6 = (String)hashtable.get("label")) == null) {
                    string6 = "";
                }
                objectArray = new Object[]{string6, string12};
                fabricAlert = new FabricAlert(n4, n2, s2, alertDefinition, nArray, n5, hashtable3, string10, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for new device: zone" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for new device: zone" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populateStateChange(String string, int n, int n2) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (EventDBAccessor.getZoneData(string3, hashtable, hashtable2)) {
            int n3;
            short s;
            String string4 = "TPC_DEVICE_STATE_CHANGE_EVENT";
            short s2 = 127;
            int n4 = Integer.parseInt(string);
            int n5 = EventDBAccessor.getAlertIDByResource(s2, n4, s = this.determineAlertCondition(string4));
            if (n5 <= 0) {
                short s3 = -1;
                n3 = -1;
                String string5 = (String)hashtable.get("fabricId");
                if (string5 != null && !string5.equals("")) {
                    n3 = Integer.parseInt(string5);
                    s3 = 114;
                    n5 = EventDBAccessor.getAlertIDByResource(s3, n3, s);
                }
                if (n5 <= 0) {
                    s3 = 114;
                    n5 = EventDBAccessor.getAlertIDByResource(s3, -1, s);
                }
                if (n5 <= 0) {
                    s3 = 127;
                    n5 = EventDBAccessor.getAlertIDByResource(s3, -1, s);
                }
            }
            if (n5 > 0) {
                String string6;
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n5;
                alertDefinition.aldProductID = 0;
                n3 = 1;
                int n6 = EventDBAccessor.getComputerId(n3);
                int n7 = 101;
                if (n == 1) {
                    n7 = 112;
                }
                int[] nArray = MIBConstants.BTAsanRegionEvent;
                int[][] nArray2 = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string8 = n == 0 ? "TPC_MISSING_DEVICE_EVENT" : "TPC_NORMAL_DEVICE_EVENT";
                hashtable.put("eventType", string8);
                hashtable2.put("eventType", string8);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string9 = this.getSRValue(n8, hashtable);
                    if (string9 == null) {
                        string9 = "";
                    }
                    hashtable3.put(nArray2[n8], string9);
                    ++n8;
                }
                String string10 = "SANRegionEvent";
                int n9 = 0;
                while (n9 < srTecSlotNames.length) {
                    string7 = (String)hashtable2.get(srTecSlotNames[n9]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(srTecSlotNames[n9], string7);
                    ++n9;
                }
                String string11 = n == 0 ? "CRITICAL" : "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string11);
                string7 = "ALR4053I";
                if (n == 0) {
                    string7 = "ALR4052W";
                }
                Object[] objectArray = null;
                String string12 = (String)hashtable.get("SANName");
                if (string12 == null) {
                    string12 = "";
                }
                if ((string6 = (String)hashtable.get("label")) == null) {
                    string6 = "";
                }
                objectArray = new Object[]{string6, string12};
                fabricAlert = new FabricAlert(n6, n4, s2, alertDefinition, nArray, n7, hashtable3, string10, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for changed device: zone" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for changed device: zone" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    public Alert populatePropertyChange(String string, Hashtable hashtable, Hashtable hashtable2) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String string, int n, int n2) {
        Alert alert = null;
        return alert;
    }

    private short determineAlertCondition(String string) {
        if (string.equals("TPC_NEW_DEVICE_EVENT")) {
            return 104;
        }
        return 118;
    }

    private short determineResourceType() {
        return 127;
    }

    private void addCommonTecAttributes(Hashtable hashtable, String string) {
        String string2 = "";
        String string3 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string3 = InetAddress.getByName(string2).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        hashtable.put("hostname", string3);
        hashtable.put("origin", string2);
        hashtable.put("severity", string);
    }

    private String getSRValue(int n, Hashtable hashtable) {
        if (srVarNames[n].equals("description")) {
            return srVarNames[n];
        }
        if (peVarNames[n].equals("messageId")) {
            return srVarNames[n];
        }
        return (String)hashtable.get(srVarNames[n]);
    }

    public Alert populateStateChange(String string, int n, int n2, HashMap hashMap) throws AlertCreationException {
        String string2 = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)(deviceType + string));
        }
        FabricAlert fabricAlert = null;
        String string3 = string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (this.getZoneData(string3, hashtable, hashtable2, hashMap)) {
            int n3;
            short s;
            String string4 = "TPC_DEVICE_STATE_CHANGE_EVENT";
            short s2 = 127;
            int n4 = Integer.parseInt(string);
            int n5 = EventDBAccessor.getAlertIDByResource(s2, n4, s = this.determineAlertCondition(string4));
            if (n5 <= 0) {
                short s3 = -1;
                n3 = -1;
                String string5 = (String)hashtable.get("fabricId");
                if (string5 != null && !string5.equals("")) {
                    n3 = Integer.parseInt(string5);
                    s3 = 114;
                    n5 = EventDBAccessor.getAlertIDByResource(s3, n3, s);
                }
                if (n5 <= 0) {
                    s3 = 114;
                    n5 = EventDBAccessor.getAlertIDByResource(s3, -1, s);
                }
                if (n5 <= 0) {
                    s3 = 127;
                    n5 = EventDBAccessor.getAlertIDByResource(s3, -1, s);
                }
            }
            if (n5 > 0) {
                String string6;
                String string7;
                AlertDefinition alertDefinition = new AlertDefinition();
                alertDefinition.aldAlertID = n5;
                alertDefinition.aldProductID = 0;
                n3 = 1;
                int n6 = EventDBAccessor.getComputerId(n3);
                int n7 = 101;
                if (n == 1) {
                    n7 = 112;
                }
                int[] nArray = MIBConstants.BTAsanRegionEvent;
                int[][] nArray2 = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> hashtable3 = new Hashtable<int[], String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                String string8 = n == 0 ? "TPC_MISSING_DEVICE_EVENT" : "TPC_NORMAL_DEVICE_EVENT";
                hashtable.put("eventType", string8);
                hashtable2.put("eventType", string8);
                int n8 = 0;
                while (n8 < nArray2.length) {
                    String string9 = this.getSRValue(n8, hashtable);
                    if (string9 == null) {
                        string9 = "";
                    }
                    hashtable3.put(nArray2[n8], string9);
                    ++n8;
                }
                String string10 = "SANRegionEvent";
                int n9 = 0;
                while (n9 < srTecSlotNames.length) {
                    string7 = (String)hashtable2.get(srTecSlotNames[n9]);
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable4.put(srTecSlotNames[n9], string7);
                    ++n9;
                }
                String string11 = n == 0 ? "CRITICAL" : "HARMLESS";
                this.addCommonTecAttributes(hashtable4, string11);
                string7 = "ALR4053I";
                if (n == 0) {
                    string7 = "ALR4052W";
                }
                Object[] objectArray = null;
                String string12 = (String)hashtable.get("SANName");
                if (string12 == null) {
                    string12 = "";
                }
                if ((string6 = (String)hashtable.get("label")) == null) {
                    string6 = "";
                }
                objectArray = new Object[]{string6, string12};
                fabricAlert = new FabricAlert(n6, n4, s2, alertDefinition, nArray, n7, hashtable3, string10, hashtable4, string7, objectArray);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string2, "No AlertDefinition defined in db for changed device: zone" + string3);
            }
        } else {
            throw new AlertCreationException("No data found in db for changed device: zone" + string3);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return fabricAlert;
    }

    private boolean getZoneData(String string, Hashtable hashtable, Hashtable hashtable2, HashMap hashMap) {
        boolean bl = false;
        HashMap hashMap2 = null;
        hashMap2 = (HashMap)hashMap.get(deviceType + string);
        if (hashMap2 != null) {
            hashtable.put("uniqueId", string);
            hashtable.put("entityName", this.getValue(hashMap2, "ZONE_NAME"));
            hashtable.put("zoneName", this.getValue(hashMap2, "ZONE_NAME"));
            hashtable.put("active", this.getValue(hashMap2, "ACTIVE"));
            hashtable.put("label", this.getValue(hashMap2, "ZONE_NAME"));
            hashtable.put("entityType", deviceType);
            hashtable.put("type", this.getValue(hashMap2, "ZONE_TYPE"));
            EventDBAccessor.setSelfAsHLD(hashtable);
            String string2 = this.getValue(hashMap2, "FABRIC_WWN");
            if (string2 != null && EventDBAccessor.getFabricDataFromFabricWWN(hashtable, string2)) {
                hashtable2.putAll(hashtable);
                bl = true;
            }
        }
        return bl;
    }

    private String getValue(HashMap hashMap, String string) {
        Object object = null;
        object = hashMap.get(string);
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

