/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.interfaces;

import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventXMLParser;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.DataManager;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.ExtractEventFailedException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.InvalidParameterException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartAction;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartEvent;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.Source;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class InbandChangeEventExtractor {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;

    static {
        Class<?> clazz;
        msgLogger = LogConstants.msgLogger;
        traceLogger = LogConstants.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.interfaces.InbandChangeEventExtractor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public SmartEvent[] extractEvent(DataManager dataManager, String string) throws ExtractEventFailedException {
        Object object;
        String string2 = "extractEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2, (Object)("Input Parameter= " + dataManager + " and " + string));
        }
        Vector<Object> vector = new Vector<Object>();
        XMLReader xMLReader = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        try {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "In InbandChangeEventExtractor Parsing Data from xml");
            }
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            object = sAXParserFactory.newSAXParser();
            xMLReader = ((SAXParser)object).getXMLReader();
            EventXMLParser eventXMLParser = new EventXMLParser();
            xMLReader.setContentHandler(eventXMLParser);
            xMLReader.setErrorHandler(eventXMLParser);
            xMLReader.parse(new InputSource(new StringReader(string)));
            stringArray = eventXMLParser.getEventIds();
            stringArray2 = eventXMLParser.getTimeStamps();
            stringArray3 = eventXMLParser.getSourceNames();
            stringArray4 = eventXMLParser.getSourceAddresses();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "In SnmpSanEventExtractor.extractEvent Parsing Data from xml-done");
            }
        }
        catch (Exception exception) {
            try {
                SmartEvent smartEvent = new SmartEvent("name", "address", "Specific Info", "ActionTarget", 0, "ActionDescription", 0, 0, "description", Calendar.getInstance());
                vector.add(smartEvent);
                Object[] objectArray = new SmartEvent[vector.size()];
                vector.copyInto(objectArray);
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
                }
                return objectArray;
            }
            catch (Exception exception2) {
                throw new ExtractEventFailedException();
            }
        }
        int n = 0;
        while (n < stringArray.length) {
            object = null;
            try {
                object = this.createSmartEvent(stringArray[n], stringArray2[n], stringArray3[n], stringArray4[n], dataManager);
            }
            catch (ExtractEventFailedException extractEventFailedException) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)extractEventFailedException);
                }
                try {
                    object = new SmartEvent("name", "address", "Specific Info", "ActionTarget", 0, "ActionDescription", 0, 0, "description", Calendar.getInstance());
                }
                catch (Exception exception) {
                    throw new ExtractEventFailedException();
                }
            }
            vector.add(object);
            ++n;
        }
        Object[] objectArray = new SmartEvent[vector.size()];
        vector.copyInto(objectArray);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return objectArray;
    }

    private SmartEvent createSmartEvent(String string, String string2, String string3, String string4, DataManager dataManager) throws ExtractEventFailedException {
        String string5 = "createSmartEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string5);
        }
        SmartEvent smartEvent = null;
        try {
            String string6 = String.valueOf(string) + "." + "Inband";
            String string7 = dataManager.getData(String.valueOf(string6) + ".SmartEvent.EventType");
            int n = Integer.parseInt(string7);
            String string8 = dataManager.getData(String.valueOf(string6) + ".SmartEvent.Priority");
            int n2 = Integer.parseInt(string8);
            String string9 = dataManager.getData(String.valueOf(string6) + ".SmartEvent.Description");
            String string10 = dataManager.getData(String.valueOf(string6) + ".SmartEvent.SmartAction.Target");
            String string11 = dataManager.getData(String.valueOf(string6) + ".SmartEvent.SmartAction.ActionType");
            int n3 = Integer.parseInt(string11);
            String string12 = dataManager.getData(String.valueOf(string6) + ".SmartEvent.SmartAction.ActionDescription");
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string5, "In InbandChangeEventExtractor.extractEvent Dot the descriptions");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss a zzz");
            Date date = new Date();
            try {
                date = simpleDateFormat.parse(string2);
            }
            catch (ParseException parseException) {}
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string5, "In InbandChangeEventExtractor.extractEvent Created the calendar");
            }
            try {
                Source source = new Source(string3, string4, null);
                SmartAction smartAction = new SmartAction(string10, n3, string12);
                smartEvent = new SmartEvent(source, smartAction, n, n2, string9, calendar);
            }
            catch (InvalidParameterException invalidParameterException) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string5, (Throwable)invalidParameterException);
                }
                throw new ExtractEventFailedException();
            }
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_MISC_DATA, (Object)this, string5, (Object)"In InbandChangeEventExtractor.extractEvent: Created SmartEvent");
            }
        }
        catch (RuntimeException runtimeException) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string5, (Throwable)runtimeException);
            }
            throw new ExtractEventFailedException();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5);
        }
        return smartEvent;
    }
}

