/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.interfaces;

import java.util.Calendar;
import org.eclipse.aperi.monitor.eventcorrelator.data.EventConstants;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.InvalidParameterException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.NotSupportedException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartAction;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.Source;
import org.eclipse.aperi.sanmgmt.event.data.SANEvent;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SmartEvent
extends SANEvent
implements EventConstants {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;
    private static String MSG_FILE;
    protected SmartAction smartAction;
    private Source source;
    private int eventType;
    private int priority = 0;
    private String description = "";
    private Calendar timeStamp;

    static {
        Class<?> clazz;
        msgLogger = LogConstants.msgLogger;
        traceLogger = LogConstants.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.EventCorrelatorFactory";
    }

    public int getPriority() {
        return 0;
    }

    public SmartEvent() {
    }

    public SmartEvent(Source source, SmartAction smartAction, int n, int n2, String string, Calendar calendar) throws InvalidParameterException {
        String string2 = "SmartEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string2, new Object[]{source, smartAction, new Integer(n2), string, calendar});
        }
        if (source == null || smartAction == null || calendar == null || n < 0 || n2 < 0) {
            throw new InvalidParameterException();
        }
        this.source = source;
        this.smartAction = smartAction;
        this.eventType = n;
        this.priority = n2;
        this.description = string;
        this.timeStamp = calendar;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public SmartEvent(String string, String string2, String string3, String string4, int n, String string5, int n2, int n3, String string6, Calendar calendar) throws InvalidParameterException {
        String string7 = "SmartEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string7, new Object[]{string, string2, string3, string4, new Integer(n), string5, new Integer(n3), string6, calendar});
        }
        if (calendar == null || n2 < 0 || n3 < 0) {
            throw new InvalidParameterException();
        }
        this.source = new Source(string, string2, string3);
        this.smartAction = new SmartAction(string4, n, string5);
        this.eventType = n2;
        this.priority = n3;
        this.description = string6;
        this.timeStamp = calendar;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string7);
        }
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getDescription() throws NotSupportedException {
        return this.description;
    }

    public Calendar getTimeStamp() {
        return this.timeStamp;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public String getSourceAddress() {
        return this.source.getAddress();
    }

    public String getSourceSpecificInfo() throws NotSupportedException {
        return this.source.getSpecificInfo();
    }

    public String getActionTarget() throws NotSupportedException {
        return this.smartAction.getTarget();
    }

    public int getActionType() throws NotSupportedException {
        return this.smartAction.getType();
    }

    public String getActionDescription() throws NotSupportedException {
        return this.smartAction.getDescription();
    }

    public String toString() {
        String string = " ";
        String string2 = " ";
        String string3 = " ";
        String string4 = " ";
        String string5 = " ";
        String string6 = " ";
        int n = 0;
        if (this.source != null) {
            string = this.source.getName();
            string2 = this.source.getAddress();
        }
        if (this.source != null && this.smartAction != null) {
            try {
                string3 = this.getSourceSpecificInfo();
                n = this.getActionType();
                string4 = this.getActionTarget();
                string5 = this.getActionDescription();
            }
            catch (NotSupportedException notSupportedException) {}
        }
        if (this.timeStamp != null) {
            string6 = this.timeStamp.getTime().toString();
        }
        String string7 = "Event Type:" + this.eventType + "\t" + "Event Priority:" + this.priority + "\t" + "Event Description:" + this.description + "\t" + "TimeStamp:" + string6 + "\t" + "Source Name:" + string + "\t" + "Source Address:" + string2 + "\t" + "Source Specific Information:" + string3 + "\t" + "Action Type:" + n + "\t" + "Action Target:" + string4 + "\t" + "Action Description:" + string5;
        return string7;
    }

    public boolean equals(Object object) {
        boolean bl;
        String string;
        block5: {
            string = "equals";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)("Input Parameter= " + object));
            }
            if (!(object instanceof SmartEvent)) {
                return false;
            }
            SmartEvent smartEvent = (SmartEvent)object;
            bl = false;
            try {
                bl = this.getSourceName().equals(smartEvent.getSourceName()) && this.getSourceAddress().equals(smartEvent.getSourceAddress()) && this.getActionTarget().equals(smartEvent.getActionTarget()) && this.getActionDescription().equals(smartEvent.getActionDescription()) && this.getDescription().equals(smartEvent.getDescription()) && this.getEventType() == smartEvent.getEventType() && this.getPriority() == smartEvent.getPriority() && this.getActionType() == smartEvent.getActionType();
                long l = smartEvent.getTimeStamp().getTime().getTime();
                long l2 = this.getTimeStamp().getTime().getTime();
                long l3 = 60000L;
                long l4 = l2 + l3;
                long l5 = l2 - l3;
                bl = bl && l5 <= l && l4 >= l;
            }
            catch (NotSupportedException notSupportedException) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "SmartEvent_NotSupportedException");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)notSupportedException);
                if (!traceLogger.isLogging()) break block5;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)notSupportedException);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }
}

