/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.snmp.ConnectionManager;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class PortListener
extends Thread {
    private DatagramSocket SNMPSocket = null;
    private boolean notStopped = true;
    private static int maxArrayLength = 16000;
    static ILogger msgLogger = EventCorrelatorFactory.msgLogger;
    static ILogger traceLogger = EventCorrelatorFactory.traceLogger;

    public PortListener(DatagramSocket datagramSocket) {
        this.SNMPSocket = datagramSocket;
    }

    private PortListener() {
    }

    public void requestStop() {
        this.notStopped = false;
    }

    public void run() {
        if (this.SNMPSocket != null) {
            block6: {
                try {
                    while (this.notStopped) {
                        DatagramPacket datagramPacket = new DatagramPacket(new byte[maxArrayLength], maxArrayLength);
                        this.SNMPSocket.receive(datagramPacket);
                        if (datagramPacket == null) continue;
                        byte[] byArray = datagramPacket.getData();
                        ConnectionManager.outputToListeners(byArray, datagramPacket.getLength());
                    }
                }
                catch (IOException iOException) {
                    if (!traceLogger.isLogging()) break block6;
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)this, "run", (Throwable)iOException, "An error occurred trying to listen for SNMP data: " + iOException.getMessage());
                }
            }
            try {
                this.SNMPSocket.close();
            }
            catch (Exception exception) {}
        }
    }
}

