/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.datafeed.StockEntry;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class Stock
extends AxesRenderer {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    static /* synthetic */ Class class$org$eclipse$birt$chart$event$InteractionEvent;
    static /* synthetic */ Class class$org$eclipse$birt$chart$event$PolygonRenderEvent;

    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        if (cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.dimension", new Object[]{cwa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)vex);
        }
        if (!srh.isCategoryScale()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.xvalue.scale.stock", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), new Integer(this.iSeriesIndex + 1), new Integer(this.iSeriesCount)}, this.getRunTimeContext().getULocale()));
        StockSeries ss = (StockSeries)this.getSeries();
        if (!ss.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{ss}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!ss.isVisible()) {
            return;
        }
        double dSeriesThickness = srh.getSeriesThickness();
        DataPointHints[] dpha = srh.getDataPoints();
        LineAttributes lia = ss.getLineAttributes();
        double dUnitSpacing = !cwa.isSetUnitSpacing() ? 50.0 : cwa.getUnitSpacing();
        double dX = 0.0;
        double dY = 0.0;
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dSpacing = 0.0;
        Location loStart = null;
        Location loEnd = null;
        Location loUpper = LocationImpl.create((double)0.0, (double)0.0);
        Location loLower = LocationImpl.create((double)0.0, (double)0.0);
        Location[] loaFrontFace = null;
        ColorDefinition TRANSPARENT = ColorDefinitionImpl.TRANSPARENT();
        SeriesDefinition sd = this.getSeriesDefinition();
        EList elPalette = sd.getSeriesPalette().getEntries();
        int iPaletteSize = elPalette.size();
        if (iPaletteSize == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{ss}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = cwa.getLegend().getItemType().getValue() == 1;
        int iThisSeriesIndex = -1;
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ss);
            if (iThisSeriesIndex < 0) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ss, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
            fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
        }
        double[] faX = new double[dpha.length];
        double[] faY = new double[dpha.length];
        for (int i = 0; i < dpha.length; ++i) {
            EList elTriggers;
            LineRenderEvent lre;
            double dClose;
            double dOpen;
            double dHigh;
            double dLow;
            StockEntry se = (StockEntry)dpha[i].getOrthogonalValue();
            if (!this.isValidEntry(se)) {
                faX[i] = Double.NaN;
                faY[i] = Double.NaN;
                continue;
            }
            if (bPaletteByCategory) {
                fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i % iPaletteSize)));
            }
            this.updateTranslucency(fPaletteEntry, (Series)ss);
            ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
            ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i]);
            this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
            Location lo = dpha[i].getLocation();
            dX = lo.getX();
            dY = lo.getY();
            try {
                dLow = srh.getLocationOnOrthogonal((Object)new Double(se.getLow()));
                dHigh = srh.getLocationOnOrthogonal((Object)new Double(se.getHigh()));
                dOpen = srh.getLocationOnOrthogonal((Object)new Double(se.getOpen()));
                dClose = srh.getLocationOnOrthogonal((Object)new Double(se.getClose()));
            }
            catch (Exception ex) {
                logger.log(ex);
                continue;
            }
            dSpacing = dpha[i].getSize() * dUnitSpacing / 200.0;
            if (loStart == null) {
                loStart = LocationImpl.create((double)0.0, (double)0.0);
                loEnd = LocationImpl.create((double)0.0, (double)0.0);
                loaFrontFace = new Location[4];
                for (int j = 0; j < 4; ++j) {
                    loaFrontFace[j] = LocationImpl.create((double)0.0, (double)0.0);
                }
            }
            if (ss.isShowAsBarStick()) {
                int stickLength = ss.getStickLength();
                Location loStart2 = LocationImpl.create((double)0.0, (double)0.0);
                Location loEnd2 = LocationImpl.create((double)0.0, (double)0.0);
                if (cwa.isTransposed()) {
                    dHeight = dpha[i].getSize();
                    loStart.set(dOpen, (dY += dHeight / 2.0) + (double)stickLength);
                    loEnd.set(dClose, dY - (double)stickLength);
                    loStart2.set(dOpen, dY);
                    loEnd2.set(dClose, dY);
                    loUpper.set(dHigh > dLow ? dLow : dHigh, dY);
                    loLower.set(dHigh < dLow ? dLow : dHigh, dY);
                    loaFrontFace[0].set(dHigh, dY - (double)stickLength);
                    loaFrontFace[1].set(dLow, dY - (double)stickLength);
                    loaFrontFace[2].set(dLow, dY + (double)stickLength);
                    loaFrontFace[3].set(dHigh, dY + (double)stickLength);
                } else {
                    dWidth = dpha[i].getSize();
                    loStart.set((dX += dWidth / 2.0) - (double)stickLength, dOpen);
                    loEnd.set(dX + (double)stickLength, dClose);
                    loStart2.set(dX, dOpen);
                    loEnd2.set(dX, dClose);
                    loUpper.set(dX, dHigh > dLow ? dHigh : dLow);
                    loLower.set(dX, dHigh < dLow ? dHigh : dLow);
                    loaFrontFace[0].set(dX - (double)stickLength, dHigh);
                    loaFrontFace[1].set(dX - (double)stickLength, dLow);
                    loaFrontFace[2].set(dX + (double)stickLength, dLow);
                    loaFrontFace[3].set(dX + (double)stickLength, dHigh);
                }
                lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)ss, (DataPointHints)dpha[i]), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? Stock.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                lre.setLineAttributes(lia);
                lre.setStart(loUpper);
                lre.setEnd(loLower);
                ipr.drawLine(lre);
                lre.setStart(loStart);
                lre.setEnd(loStart2);
                ipr.drawLine(lre);
                lre.setStart(loEnd);
                lre.setEnd(loEnd2);
                ipr.drawLine(lre);
            } else {
                if (cwa.isTransposed()) {
                    dHeight = dpha[i].getSize();
                    loStart.set(dLow, dY += dSpacing + (dHeight -= 2.0 * dSpacing) / 2.0);
                    loEnd.set(dHigh, dY);
                    loaFrontFace[0].set(dOpen, dY - dHeight / 2.0);
                    loaFrontFace[1].set(dClose, dY - dHeight / 2.0);
                    loaFrontFace[2].set(dClose, dY + dHeight / 2.0);
                    loaFrontFace[3].set(dOpen, dY + dHeight / 2.0);
                    loUpper.set(dOpen > dClose ? dClose : dOpen, dY);
                    loLower.set(dOpen < dClose ? dClose : dOpen, dY);
                } else {
                    dWidth = dpha[i].getSize();
                    loStart.set(dX += dSpacing + (dWidth -= 2.0 * dSpacing) / 2.0, dLow);
                    loEnd.set(dX, dHigh);
                    loaFrontFace[0].set(dX - dWidth / 2.0, dOpen);
                    loaFrontFace[1].set(dX - dWidth / 2.0, dClose);
                    loaFrontFace[2].set(dX + dWidth / 2.0, dClose);
                    loaFrontFace[3].set(dX + dWidth / 2.0, dOpen);
                    loUpper.set(dX, dOpen > dClose ? dOpen : dClose);
                    loLower.set(dX, dOpen < dClose ? dOpen : dClose);
                }
                lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)ss, (DataPointHints)dpha[i]), class$org$eclipse$birt$chart$event$LineRenderEvent == null ? Stock.class$("org.eclipse.birt.chart.event.LineRenderEvent") : class$org$eclipse$birt$chart$event$LineRenderEvent);
                lre.setLineAttributes(lia);
                lre.setStart(loStart);
                lre.setEnd(loUpper);
                ipr.drawLine(lre);
                lre.setStart(loLower);
                lre.setEnd(loEnd);
                ipr.drawLine(lre);
                this.renderPlane(ipr, WrappedStructureSource.createSeriesDataPoint((Series)ss, (DataPointHints)dpha[i]), loaFrontFace, (Fill)(dClose > dOpen && !cwa.isTransposed() || dClose < dOpen && cwa.isTransposed() ? TRANSPARENT : fPaletteEntry), lia, cwa.getDimension(), dSeriesThickness, false);
            }
            if (cwa.isTransposed()) {
                faX[i] = (loUpper.getX() + loLower.getX()) / 2.0;
                faY[i] = loUpper.getY();
            } else {
                faX[i] = loLower.getX();
                faY[i] = (loUpper.getY() + loLower.getY()) / 2.0;
            }
            if (this.isInteractivityEnabled() && !(elTriggers = ss.getTriggers()).isEmpty()) {
                StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)ss, (DataPointHints)dpha[i]);
                InteractionEvent iev = (InteractionEvent)((EventObjectCache)ipr).getEventObject((Object)iSource, class$org$eclipse$birt$chart$event$InteractionEvent == null ? Stock.class$("org.eclipse.birt.chart.event.InteractionEvent") : class$org$eclipse$birt$chart$event$InteractionEvent);
                for (int t = 0; t < elTriggers.size(); ++t) {
                    Trigger tg = TriggerImpl.copyInstance((Trigger)((Trigger)elTriggers.get(t)));
                    this.processTrigger(tg, iSource);
                    iev.addTrigger(tg);
                }
                PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)ss), class$org$eclipse$birt$chart$event$PolygonRenderEvent == null ? Stock.class$("org.eclipse.birt.chart.event.PolygonRenderEvent") : class$org$eclipse$birt$chart$event$PolygonRenderEvent);
                pre.setPoints(loaFrontFace);
                iev.setHotSpot((PrimitiveRenderEvent)pre);
                ipr.enableInteraction(iev);
            }
            ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i], (Object)fPaletteEntry);
            ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i]);
            this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
        }
        if (this.getSeries().getCurveFitting() != null) {
            Location[] larray = new Location[faX.length];
            for (int i = 0; i < larray.length; ++i) {
                larray[i] = LocationImpl.create((double)faX[i], (double)faY[i]);
            }
            larray = Stock.filterNull((Location[])larray);
            this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), false, true);
        }
    }

    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        ClientArea ca = lg.getClientArea();
        StockSeries ss = (StockSeries)this.getSeries();
        RectangleRenderEvent rre = (RectangleRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), RectangleRenderEvent.class);
        rre.setBackground(ca.getBackground());
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        LineAttributes lia = ss.getLineAttributes();
        if (!lia.isSetVisible() || !lia.isVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.stock.lineattr.visibility", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), LineRenderEvent.class);
        rre = (RectangleRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), RectangleRenderEvent.class);
        lre.setLineAttributes(lia);
        rre.setBackground(fPaletteEntry);
        rre.setOutline(lia);
        if (cwa.isTransposed()) {
            lre.setStart(LocationImpl.create((double)bo.getLeft(), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            lre.setEnd(LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            rre.setBounds(BoundsImpl.create((double)(bo.getLeft() + bo.getWidth() / 4.0), (double)(bo.getTop() + 1.0), (double)(bo.getWidth() / 2.0), (double)(bo.getHeight() - 2.0)));
        } else {
            lre.setStart(LocationImpl.create((double)(bo.getLeft() + bo.getWidth() / 2.0), (double)(bo.getTop() + bo.getHeight())));
            lre.setEnd(LocationImpl.create((double)(bo.getLeft() + bo.getWidth() / 2.0), (double)bo.getTop()));
            rre.setBounds(BoundsImpl.create((double)(bo.getLeft() + 1.0), (double)(bo.getTop() + bo.getHeight() / 4.0), (double)(bo.getWidth() - 2.0), (double)(bo.getHeight() / 2.0)));
        }
        ipr.drawLine(lre);
        ipr.fillRectangle(rre);
        ipr.drawRectangle(rre);
    }

    private boolean isValidEntry(StockEntry entry) {
        return entry != null && !Double.isNaN(entry.getHigh()) && !Double.isNaN(entry.getLow()) && !Double.isNaN(entry.getClose()) && !Double.isNaN(entry.getOpen());
    }

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }
}

