/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Formatter;
import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.util.MessageCatalog;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class PDXMLFormatter
extends Formatter {
    static final long serialVersionUID = 1448798864185043580L;
    private boolean singleComponent = false;
    private boolean singleProductId = false;
    private boolean singleProductInstance = false;
    private boolean singleServer = false;
    private boolean isFirstRecord = true;
    private boolean forceAsMessage = false;
    private boolean forceAsTrace = false;
    private static final int MIN_MSG_ID_LEN = 8;
    private static final int MAX_MSG_ID_LEN = 10;
    private static final String timeZone = TimeZone.getDefault().getDisplayName(false, 0);

    public PDXMLFormatter() {
    }

    public PDXMLFormatter(String string) {
        super(string);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("singleComponent", new Boolean(this.singleComponent).toString());
        properties.put("singleProductId", new Boolean(this.singleProductId).toString());
        properties.put("singleProductInstance", new Boolean(this.singleProductInstance).toString());
        properties.put("singleServer", new Boolean(this.singleServer).toString());
        properties.put("forceAsMessage", new Boolean(this.forceAsMessage).toString());
        properties.put("forceAsTrace", new Boolean(this.forceAsTrace).toString());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("singleComponent");
        if (string != null) {
            this.setSingleComponent(new Boolean(string));
        }
        if ((string = properties.getProperty("singleProductId")) != null) {
            this.setSingleProductId(new Boolean(string));
        }
        if ((string = properties.getProperty("singleProductInstance")) != null) {
            this.setSingleProductInstance(new Boolean(string));
        }
        if ((string = properties.getProperty("singleServer")) != null) {
            this.setSingleServer(new Boolean(string));
        }
        if ((string = properties.getProperty("forceAsMessage")) != null) {
            this.forceAsMessage = new Boolean(string);
        }
        if ((string = properties.getProperty("forceAsTrace")) != null) {
            this.forceAsTrace = new Boolean(string);
        }
    }

    public boolean isSingleComponent() {
        return this.singleComponent;
    }

    public void setSingleComponent(boolean bl) {
        this.singleComponent = bl;
    }

    public boolean isSingleProductId() {
        return this.singleProductId;
    }

    public void setSingleProductId(boolean bl) {
        this.singleProductId = bl;
    }

    public boolean isSingleProductInstance() {
        return this.singleProductInstance;
    }

    public void setSingleProductInstance(boolean bl) {
        this.singleProductInstance = bl;
    }

    public boolean isSingleServer() {
        return this.singleServer;
    }

    public void setSingleServer(boolean bl) {
        this.singleServer = bl;
    }

    public String format(LogEvent logEvent) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(256);
        if (this.isFirstRecord) {
            this.getProductInfo(stringBuffer, logEvent, this.singleComponent, this.singleProductId, this.singleProductInstance, this.singleServer);
            this.isFirstRecord = false;
        }
        boolean bl = this.forceAsMessage == this.forceAsTrace ? logEvent.getMessageFile() != null : this.forceAsMessage;
        String string = this.getMessage(logEvent);
        Level level = logEvent.getLevel();
        if (bl) {
            stringBuffer.append("<Message Id=\"");
            String string2 = logEvent.getMessageId();
            if (string2 == null) {
                string2 = this.getMessageId(string);
                if (string2 == null) {
                    string2 = "None";
                }
            } else if (string2.length() == 0) {
                string2 = "None";
            }
            stringBuffer.append(string2);
            if (level != null) {
                stringBuffer.append("\" Severity=\"");
                stringBuffer.append(this.getLevel(level.getValue()));
            }
            stringBuffer.append("\">\n");
        } else if (level != null) {
            stringBuffer.append("<Trace Level=\"");
            stringBuffer.append(this.getLevel(level.getValue()));
            stringBuffer.append("\">\n");
        } else {
            stringBuffer.append("<Trace>\n");
        }
        stringBuffer.append(" <Time Millis=\"");
        long l = logEvent.getTimeStamp();
        stringBuffer.append(l);
        stringBuffer.append("\"> ");
        stringBuffer.append(this.getDate(l));
        stringBuffer.append(" ");
        stringBuffer.append(this.getTime(l));
        stringBuffer.append("</Time>\n");
        this.getProductInfo(stringBuffer, logEvent, !this.singleComponent, !this.singleProductId, !this.singleProductInstance, !this.singleServer);
        stringBuffer.append(" <LogText><![CDATA[");
        stringBuffer.append(string);
        stringBuffer.append("]]></LogText>\n");
        Iterator iterator = logEvent.getKeysAndValues();
        if (iterator != null) {
            stringBuffer.append(" <LogAttribs>");
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                stringBuffer.append(" <Key>");
                stringBuffer.append(object.getKey());
                stringBuffer.append("</Key>");
                stringBuffer.append(" <Value>");
                stringBuffer.append(object.getValue());
                stringBuffer.append("</Value>\n");
            }
            stringBuffer.append(" </LogAttribs>\n");
        }
        if (bl) {
            this.getSource(stringBuffer, logEvent);
            this.getTranslationInfo(stringBuffer, logEvent, logEvent.getMessageFile());
        } else {
            if (!this.getSource(stringBuffer, logEvent)) {
                stringBuffer.append(" <Source FileName=\"None\" Method=\"None\"/>");
            }
            stringBuffer.append(" <Thread>");
            stringBuffer.append(logEvent.getThreadName());
            stringBuffer.append("</Thread>\n");
            object = logEvent.getStackTrace();
            if (object != null) {
                stringBuffer.append(" <Exception><![CDATA[");
                stringBuffer.append((String)object);
                stringBuffer.append("]]></Exception>\n");
            }
        }
        if (logEvent.getCorrelationId() != null) {
            stringBuffer.append(" <CorrelationId>");
            stringBuffer.append(logEvent.getCorrelationId());
            stringBuffer.append("</CorrelationId>\n");
        }
        if (logEvent.getClient() != null) {
            stringBuffer.append(" <Principal>");
            stringBuffer.append(logEvent.getClient());
            stringBuffer.append("</Principal>\n");
        }
        if (bl) {
            stringBuffer.append("</Message>\n");
        } else {
            stringBuffer.append("</Trace>\n");
        }
        return stringBuffer.toString();
    }

    private void getProductInfo(StringBuffer stringBuffer, LogEvent logEvent, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl4 && logEvent.getServer() != null) {
            stringBuffer.append(" <Server Format=\"");
            stringBuffer.append(logEvent.getServerFormat());
            stringBuffer.append("\">");
            stringBuffer.append(logEvent.getServer());
            stringBuffer.append("</Server>\n");
        }
        if (bl2 && logEvent.getProduct() != null) {
            stringBuffer.append(" <ProductId>");
            stringBuffer.append(logEvent.getProduct());
            stringBuffer.append("</ProductId>\n");
        }
        if (bl && logEvent.getComponent() != null) {
            stringBuffer.append(" <Component>");
            stringBuffer.append(logEvent.getComponent());
            stringBuffer.append("</Component>\n");
        }
        if (bl3 && logEvent.getProductInstance() != null) {
            stringBuffer.append(" <ProductInstance>");
            stringBuffer.append(logEvent.getProductInstance());
            stringBuffer.append("</ProductInstance>\n");
        }
        this.isFirstRecord = false;
    }

    private void getTranslationInfo(StringBuffer stringBuffer, LogEvent logEvent, String string) {
        stringBuffer.append(" <TranslationInfo Type=\"JAVA\"");
        stringBuffer.append(" Catalog=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" MsgKey=\"");
        stringBuffer.append(logEvent.getMessageKey());
        stringBuffer.append("\">");
        Object[] objectArray = logEvent.getInserts();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append("<Param><![CDATA[");
                if (objectArray[n] != null) {
                    stringBuffer.append(objectArray[n].toString());
                }
                stringBuffer.append("]]></Param>");
                ++n;
            }
        }
        stringBuffer.append("</TranslationInfo>\n");
    }

    private boolean getSource(StringBuffer stringBuffer, LogEvent logEvent) {
        boolean bl = true;
        if (logEvent.getLoggingClass() != null) {
            stringBuffer.append(" <Source FileName=\"");
            stringBuffer.append(logEvent.getLoggingClass());
            stringBuffer.append("\" Method=\"");
            stringBuffer.append(logEvent.getLoggingMethod());
            stringBuffer.append("\"/>\n");
        } else {
            bl = false;
        }
        return bl;
    }

    public String getHeader() {
        this.isFirstRecord = true;
        return null;
    }

    public String getTrailer() {
        return null;
    }

    public String getMessageId(String string) {
        String string2 = null;
        if (string == null || string.length() < 8) {
            return string2;
        }
        char[] cArray = new char[10];
        int[] nArray = new int[10];
        boolean bl = false;
        int n = 0;
        while (n < string.length() && n < 10 && !bl) {
            char c = string.charAt(n);
            if (c >= 'A' && c <= 'Z') {
                cArray[n] = c;
                nArray[n] = 1;
            } else if (c >= 'a' && c <= 'z') {
                cArray[n] = c;
                nArray[n] = 2;
            } else if (c >= '0' && c <= '9') {
                cArray[n] = c;
                nArray[n] = 4;
            } else {
                bl = true;
            }
            ++n;
        }
        if (cArray[0] < 'A' || cArray[0] > 'Z') {
            return string2;
        }
        if (nArray[1] != 1 || nArray[2] != 1) {
            return string2;
        }
        if (nArray[3] == 4 && (nArray[4] != 4 || nArray[5] != 4)) {
            return string2;
        }
        if (nArray[4] == 4 && nArray[5] != 4) {
            return string2;
        }
        if (nArray[6] != 4) {
            return string2;
        }
        if (nArray[4] != 4 && nArray[7] != 4) {
            return string2;
        }
        if (nArray[5] != 4 && nArray[8] != 4) {
            return string2;
        }
        if (nArray[7] != 4) {
            if ("IWEADF".indexOf(cArray[7]) != -1) {
                return new String(cArray, 0, 8);
            }
            return string2;
        }
        if (nArray[8] != 4) {
            if ("IWEADF".indexOf(cArray[8]) != -1) {
                return new String(cArray, 0, 9);
            }
            return string2;
        }
        if ("IWEADF".indexOf(cArray[9]) != -1) {
            return new String(cArray, 0, 10);
        }
        return string2;
    }

    private String getLevel(int n) {
        switch (n) {
            case 7000: {
                return "ERROR";
            }
            case 6000: {
                return "ERROR";
            }
            case 5000: {
                return "WARN";
            }
            case 4000: {
                return "INFO";
            }
            case 3000: {
                return "MIN";
            }
            case 2000: {
                return "MID";
            }
            case 1000: {
                return "MAX";
            }
        }
        return "OTHER";
    }

    public String cacheMessageId(LogEvent logEvent) {
        String string = logEvent.getMessageId();
        if (string != null) {
            return string;
        }
        String string2 = logEvent.getMessageKey();
        String string3 = logEvent.getMessageFile();
        if (string2 != null && string3 != null) {
            String string4 = null;
            MessageCatalog messageCatalog = this.getMessageCatalog(string3);
            string4 = messageCatalog.getUnformattedMessage(string2);
            if (string4 != null) {
                string = this.getMessageId(string4);
            }
        }
        if (string == null) {
            logEvent.setMessageId("");
        } else {
            logEvent.setMessageId(string);
        }
        return string;
    }
}

