/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogEvent;
import com.ibm.log.StreamHandler;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class SocketHandler
extends StreamHandler {
    static final long serialVersionUID = -2130683178667213483L;
    private static final String DEFAULT_SERVER = "localhost";
    private int port = 9991;
    private transient ObjectOutputStream objectOutput = null;
    private String server = "localhost";
    private transient Socket socket = null;

    public SocketHandler() {
    }

    public SocketHandler(String string) {
        super(string);
    }

    public SocketHandler(String string, String string2, int n) {
        super(string);
        this.setServerAndPort(string2, n);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("socketPort", new Integer(this.getPort()).toString());
        properties.put("socketServer", this.getServer());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        int n = 9991;
        String string = DEFAULT_SERVER;
        String string2 = properties.getProperty("socketPort");
        if (string2 != null) {
            n = new Integer(string2.trim());
        }
        if ((string2 = properties.getProperty("socketServer")) != null) {
            string = string2;
        }
        this.setServerAndPort(string, n);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) throws SecurityException {
        if (n > 1024 && n != 9991) {
            this.setServerAndPort(this.getServer(), n);
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) throws SecurityException {
        if (string != null && !string.equals(DEFAULT_SERVER)) {
            this.setServerAndPort(string, this.getPort());
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setServer");
            LogUtil.errorMsg(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception, AccessControlException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager == null) {
                    this.socket = new Socket(this.getServer(), this.getPort());
                } else {
                    try {
                        this.socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return new Socket(SocketHandler.this.getServer(), SocketHandler.this.getPort());
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                }
                this.objectOutput = new ObjectOutputStream(this.socket.getOutputStream());
                this.setOutputStream(this.objectOutput);
                this.open = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            try {
                if (this.objectOutput != null) {
                    this.objectOutput.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {}
            this.objectOutput = null;
            this.socket = null;
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent logEvent) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open();
            }
            this.objectOutput.writeObject(logEvent);
            this.objectOutput.flush();
        }
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", server=" + this.getServer() + ", port=" + this.getPort();
    }

    public void setServerAndPort(String string, int n) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            SocketPermission socketPermission = new SocketPermission(String.valueOf(string) + ":" + n, "connect");
            securityManager.checkPermission(socketPermission);
        }
        this.server = string;
        this.port = n;
    }
}

