/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;

public class StreamHandler
extends Handler {
    static final long serialVersionUID = -6390988184944454386L;
    protected static boolean addLineSep = true;
    protected static String lineSeparator = System.getProperty("line.separator");
    protected static int lineSeparatorLength = lineSeparator.length();
    protected transient BufferedWriter bWriter = null;
    private transient OutputStream outputStream = null;

    public StreamHandler() {
    }

    public StreamHandler(String string) {
        super(string);
    }

    public StreamHandler(String string, OutputStream outputStream) {
        super(string);
        this.setOutputStream(outputStream);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("addLineSeparator", new Boolean(addLineSep).toString());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("addLineSeparator");
        if (string != null) {
            this.setAddLineSeparator(new Boolean(string));
        }
    }

    public boolean getAddLineSeparator() {
        return addLineSep;
    }

    public void setAddLineSeparator(boolean bl) {
        addLineSep = bl;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            this.outputStream = outputStream;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setOutputStream");
            LogUtil.errorMsg(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.getOutputStream());
                this.bWriter = new BufferedWriter(outputStreamWriter);
                this.open = true;
                this.writeHeader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.open) {
                try {
                    this.writeTrailer();
                }
                catch (Exception exception) {}
                try {
                    this.bWriter.flush();
                    this.bWriter.close();
                }
                catch (IOException iOException) {}
            }
            this.bWriter = null;
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent logEvent) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open();
            }
            String string = this.getFormatter().format(logEvent);
            this.bWriter.write(string, 0, string.length());
            if (addLineSep) {
                this.bWriter.write(lineSeparator, 0, lineSeparatorLength);
            }
            this.bWriter.flush();
        }
    }

    protected void writeHeader() throws Exception {
        String string = this.getFormatter().getHeader();
        if (string != null) {
            this.bWriter.write(string, 0, string.length());
            this.bWriter.flush();
        }
    }

    protected void writeTrailer() throws Exception {
        String string = this.getFormatter().getTrailer();
        if (string != null) {
            this.bWriter.write(string, 0, string.length());
            this.bWriter.flush();
        }
    }
}

