/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.ssl;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.IKeyStoreMgr;
import org.eclipse.aperi.connector.internal.ssl.KeyStoreMgr;

public class SSLManager {
    private static SSLContext sslContext = null;

    public static SSLSocketFactory getSSLSocketFactory() {
        SSLSocketFactory sSLSocketFactory = SSLManager.getSSLContext().getSocketFactory();
        return sSLSocketFactory;
    }

    public static SSLServerSocketFactory getSSLServerSocketFactory() {
        SSLServerSocketFactory sSLServerSocketFactory = SSLManager.getSSLContext().getServerSocketFactory();
        return sSLServerSocketFactory;
    }

    protected static SSLContext getSSLContext() {
        if (sslContext == null) {
            try {
                sslContext = SSLContext.getInstance("TLS");
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(Config.getProperty("connector.ssl.algorithm"));
                IKeyStoreMgr iKeyStoreMgr = KeyStoreMgr.getIKeyStoreMgr();
                KeyStore keyStore = iKeyStoreMgr.getKeyStore();
                keyManagerFactory.init(keyStore, iKeyStoreMgr.getPassword());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(Config.getProperty("connector.ssl.algorithm"));
                trustManagerFactory.init(keyStore);
                TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                try {
                    sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, new SecureRandom());
                }
                catch (KeyManagementException keyManagementException) {
                    keyManagementException.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return sslContext;
    }
}

