/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespAgent;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentAdjuster
extends CustomReportDataAdjuster {
    private static final String TRELLISOFT_NAME = MessageLog.getMessageNoID("ADG0201L");
    private static final String STATE = MessageLog.getMessageNoID("ADG0295T");
    private static final String OS_TYPE = MessageLog.getMessageNoID("ADG0244L");
    private static final String VERSION = MessageLog.getMessageNoID("DBG0013L");
    private static final String PORT_NUMBER = MessageLog.getMessageNoID("ADG0121L");
    private static final String HOST_ADDRESS = MessageLog.getMessageNoID("ADG0204L");
    private static final String TIMESTAMP = MessageLog.getMessageNoID("ADG0205L");
    private static final String TIMEZONE = MessageLog.getMessageNoID("ADG0206L");
    private static final String CONNECTION_ERRORS = MessageLog.getMessageNoID("ADG0207L");
    private static final String CONSECUTIVE_ERRORS = MessageLog.getMessageNoID("ADG0208L");
    private static final String CPU_ARCHITECTURE = MessageLog.getMessageNoID("GEN0218T");
    public static final String AGENT_UP = MessageLog.getMessageNoID("STG5550L");
    public static final String AGENT_DOWN = MessageLog.getMessageNoID("STG5551L");
    public static final String AGENT_UNREACHABLE = MessageLog.getMessageNoID("STG5554L");
    public static final String AGENT_UPGRADE_NEEDED = MessageLog.getMessageNoID("STG5555L");
    public static final String AGENT_UPGRADING = MessageLog.getMessageNoID("STG5553L");
    public static final String AGENT_DEFECTED = MessageLog.getMessageNoID("STG5552L");
    public static final String AGENT_DELETED = MessageLog.getMessageNoID("DBG0550L");
    public String[] colNames = new String[]{TRELLISOFT_NAME, " ", " ", " ", PORT_NUMBER, HOST_ADDRESS, TIMESTAMP, TIMEZONE, CONNECTION_ERRORS, CONSECUTIVE_ERRORS, CPU_ARCHITECTURE};
    public static final int TRELLISOFT_NAME_COL = 0;
    public final int STATE_COL;
    public final int OS_TYPE_COL;
    public final int VERSION_COL;
    public static final int PORT_NUMBER_COL = 4;
    public static final int HOST_ADDRESS_COL = 5;
    public static final int TIMESTAMP_COL = 6;
    public static final int TIMEZONE_COL = 7;
    public static final int CONNECTION_ERRORS_COL = 8;
    public static final int CONSECUTIVE_ERRORS_COL = 9;
    public static final int CPU_ARCHITECTURE_COL = 10;
    private GuiReportReq grr;
    private RespAgent[] data;
    private Comparator sorter;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private int[] rendererArray;
    private boolean batch;
    private int rows;

    public AgentAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        switch (guiReportReq.reportSubtype) {
            case 86: {
                this.frozenColumns = 2;
                this.sorter = new StatusSorter();
                this.colNames[1] = STATE;
                this.colNames[2] = OS_TYPE;
                this.colNames[3] = VERSION;
                this.STATE_COL = 1;
                this.OS_TYPE_COL = 2;
                this.VERSION_COL = 3;
                break;
            }
            case 87: {
                this.frozenColumns = 2;
                this.sorter = new OsTypeSorter();
                this.colNames[1] = OS_TYPE;
                this.colNames[2] = STATE;
                this.colNames[3] = VERSION;
                this.STATE_COL = 2;
                this.OS_TYPE_COL = 1;
                this.VERSION_COL = 3;
                break;
            }
            default: {
                this.frozenColumns = 1;
                this.sorter = new NameSorter();
                this.colNames[1] = STATE;
                this.colNames[2] = OS_TYPE;
                this.colNames[3] = VERSION;
                this.STATE_COL = 1;
                this.OS_TYPE_COL = 2;
                this.VERSION_COL = 3;
            }
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[6] = 1;
        this.rendererArray[8] = 5;
        this.rendererArray[9] = 5;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
        Arrays.sort(this.data, 0, this.data.length, this.sorter);
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.data = (RespAgent[])objectArray;
        this.rows = this.data.length;
        this.mDate = new Date[this.rows];
        this.mInt = new MutableInteger[this.rows];
        int n = 0;
        while (n < this.rows) {
            this.mDate[n] = new Date();
            this.mInt[n] = new MutableInteger();
            ++n;
        }
    }

    public void adjustData() {
        int n = 0;
        while (n < this.rows) {
            this.data[n].raDisplayState = this.data[n].raState == 1 ? AGENT_UP : (this.data[n].raState == 0 ? AGENT_DOWN : (this.data[n].raState == 4 ? AGENT_UNREACHABLE : (this.data[n].raState == 5 ? AGENT_UPGRADE_NEEDED : (this.data[n].raState == 3 ? AGENT_UPGRADING : (this.data[n].raState == 77 ? AGENT_DELETED : AGENT_DEFECTED)))));
            this.data[n].raDisplayOsType = MessageLog.getMessageNoID(Constants.OSTYPES[this.data[n].raOsType]);
            this.data[n].raDisplayCpuArchitecture = Constants.getCPUArchDisplayName(this.data[n].raCpuArchitecture);
            ++n;
        }
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        int[] nArray = new int[]{52, 53, 54, 55, 56, 57};
        columnDescriptorArray[this.STATE_COL].cdValidValue = nArray;
        columnDescriptorArray[this.OS_TYPE_COL].cdValidValue = ColumnDescriptor.OS_TYPES;
        columnDescriptorArray[10].cdValidValue = ColumnDescriptor.CPU_ARCHITECTURES;
    }

    public Object getArray() {
        return this.data;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public Object getCellData(int n, int n2) {
        Object object = null;
        if (n2 == 0) {
            object = this.data[n].raTsName;
        } else if (n2 == this.STATE_COL) {
            object = this.data[n].raDisplayState;
        } else if (n2 == this.OS_TYPE_COL) {
            object = this.data[n].raDisplayOsType;
        } else if (n2 == this.VERSION_COL) {
            object = this.data[n].raProductVersions;
        } else if (n2 == 4) {
            object = Integer.toString(this.data[n].raPortNumber);
        } else if (n2 == 5) {
            object = this.data[n].raHostAddress;
        } else if (n2 == 6) {
            this.mDate[n].setTime(this.data[n].raTimestamp);
            object = Util.formatDateTime(this.mDate[n]);
        } else if (n2 == 7) {
            object = this.data[n].raTimezone;
        } else if (n2 == 8) {
            this.mInt[n].value = this.data[n].raConnectionErrors;
            object = this.mInt[n];
        } else if (n2 == 9) {
            this.mInt[n].value = this.data[n].raConsecutiveErrors;
            object = this.mInt[n];
        } else if (n2 == 10) {
            object = this.data[n].raDisplayCpuArchitecture;
        }
        return object;
    }

    private class StatusSorter
    implements Comparator {
        private StatusSorter() {
        }

        public int compare(Object object, Object object2) {
            RespAgent respAgent = (RespAgent)object;
            RespAgent respAgent2 = (RespAgent)object2;
            int n = respAgent.raDisplayState.compareTo(respAgent2.raDisplayState);
            if (n != 0) {
                return n;
            }
            return respAgent.raTsName.compareTo(respAgent2.raTsName);
        }
    }

    private class OsTypeSorter
    implements Comparator {
        private OsTypeSorter() {
        }

        public int compare(Object object, Object object2) {
            RespAgent respAgent = (RespAgent)object;
            RespAgent respAgent2 = (RespAgent)object2;
            int n = respAgent.raDisplayOsType.compareTo(respAgent2.raDisplayOsType);
            if (n != 0) {
                return n;
            }
            return respAgent.raTsName.compareTo(respAgent2.raTsName);
        }
    }

    private class VersionSorter
    implements Comparator {
        private VersionSorter() {
        }

        public int compare(Object object, Object object2) {
            RespAgent respAgent = (RespAgent)object;
            RespAgent respAgent2 = (RespAgent)object2;
            int n = respAgent.raProductVersions.compareTo(respAgent2.raProductVersions);
            if (n != 0) {
                return n;
            }
            return respAgent.raTsName.compareTo(respAgent2.raTsName);
        }
    }

    private class NameSorter
    implements Comparator {
        private NameSorter() {
        }

        public int compare(Object object, Object object2) {
            RespAgent respAgent = (RespAgent)object;
            RespAgent respAgent2 = (RespAgent)object2;
            return respAgent.raTsName.compareTo(respAgent2.raTsName);
        }
    }
}

