/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.DiskAdjuster;
import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskGrapher
extends Grapher {
    public String actionCommand;
    public static final String SELECTED_HIST = "STG3207L";
    public static final String ALL_HIST = "STG7556L";

    public String getChartType(GuiReportReq guiReportReq, ReportDataAdjuster reportDataAdjuster) {
        return MessageLog.getMessageNoID(SELECTED_HIST);
    }

    public int graphsPerPage(GuiReportReq guiReportReq) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, GuiChartSettingsReq guiChartSettingsReq) {
        DiskAdjuster diskAdjuster = (DiskAdjuster)reportDataAdjuster;
        AperiChart aperiChart = null;
        GuiReportReq guiReportReq2 = this.createHistory(guiReportReq, objectArray, nArray, diskAdjuster, "bogus");
        aperiChart = (AperiChart)new SpaceHistChart().batch(guiReportReq2, guiChartSettingsReq);
        return aperiChart;
    }

    public GuiReportReq createHistory(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, DiskAdjuster diskAdjuster, String string) {
        Share[] shareArray = (Share[])objectArray;
        GuiReportReq guiReportReq2 = guiReportReq.explode(-1);
        guiReportReq2.reportSubtype = guiReportReq.reportSubtype;
        guiReportReq2.idSubtype = -1;
        SpaceHistChart.initLegend(guiReportReq2);
        guiReportReq2.selectedResources = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            Share share = shareArray[nArray[n]];
            guiReportReq2.selectedResources[n] = share.shResourceID;
            SpaceHistChart.addLegend(guiReportReq2, GuiUtil.formatFilesystem(share.shComputerName, diskAdjuster.daArray[nArray[n]].daPath), null, share.shResourceID);
            ++n;
        }
        guiReportReq2.histSubtype = string == ALL_HIST ? (byte)3 : (byte)8;
        guiReportReq2.reportSubtypeOrig = guiReportReq.reportSubtype;
        if (guiReportReq.reportSubtype == 24) {
            guiReportReq2.reportSubtype = -24;
            guiReportReq2.chartLabelType = (byte)6;
            guiReportReq2.historyTitle = "STG1287T";
        } else if (guiReportReq.reportSubtype == 25) {
            guiReportReq2.reportSubtype = -25;
            guiReportReq2.chartLabelType = (byte)6;
            guiReportReq2.historyTitle = "STG7524T";
        } else if (guiReportReq.reportSubtype == 26) {
            guiReportReq2.reportSubtype = -26;
            guiReportReq2.chartLabelType = (byte)6;
            guiReportReq2.historyTitle = "STG7525T";
        } else if (guiReportReq.reportSubtype == 39) {
            guiReportReq2.reportSubtype = -39;
            guiReportReq2.chartLabelType = 1;
            guiReportReq2.historyTitle = "STG7526T";
        } else {
            guiReportReq2.reportSubtype = -23;
            guiReportReq2.chartLabelType = (byte)6;
            guiReportReq2.historyTitle = "STG7523T";
        }
        return guiReportReq2;
    }
}

