/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class EmailAddressFactory {
    private static String rules;
    public static EmailAddressFactory factory;
    public EmailAddressFactory next;
    public boolean substring;
    public short substringStart;
    public short substringEnd;
    public String literal;
    public short sourceType;
    public static final short USERID = 0;
    public static final short LASTNAME = 1;
    public static final short FIRSTNAME = 2;
    public static final short LITERAL = 3;
    public static final String USERNAME_STRING;

    static {
        USERNAME_STRING = MessageLog.getMessageNoID("STG6074L");
    }

    public static synchronized EmailAddressFactory getFactory(Settings settings) throws LocalizableException {
        if (!(factory != null && settings.seEmailAddrRules.equals(rules) || (factory = EmailAddressFactory.parseRules(rules = settings.seEmailAddrRules)) != null)) {
            factory = EmailAddressFactory.makeDefaultFactory();
        }
        return factory;
    }

    public static EmailAddressFactory parseRules(String string) throws LocalizableException {
        EmailAddressFactory emailAddressFactory;
        StringReader stringReader = new StringReader(string);
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(97, 122);
            streamTokenizer.wordChars(65, 90);
            streamTokenizer.wordChars(48, 57);
            streamTokenizer.wordChars(47, 47);
            streamTokenizer.wordChars(92, 92);
            streamTokenizer.wordChars(46, 46);
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.quoteChar(34);
            streamTokenizer.quoteChar(39);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.slashStarComments(false);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.lowerCaseMode(false);
            emailAddressFactory = EmailAddressFactory.tokenize(streamTokenizer);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                ((Reader)stringReader).close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            ((Reader)stringReader).close();
        }
        catch (Exception exception) {}
        return emailAddressFactory;
    }

    public static EmailAddressFactory makeDefaultFactory() {
        return new EmailAddressFactory(0, null, false, 0, 0);
    }

    private static EmailAddressFactory tokenize(StreamTokenizer streamTokenizer) throws LocalizableException {
        EmailAddressFactory emailAddressFactory = null;
        EmailAddressFactory emailAddressFactory2 = null;
        EmailAddressFactory emailAddressFactory3 = null;
        while (EmailAddressFactory.nextToken(streamTokenizer, false, 0) != -1) {
            if (streamTokenizer.ttype == -3) {
                if (streamTokenizer.sval.equalsIgnoreCase("substring") || streamTokenizer.sval.equals(MessageLog.getMessageNoID("STG6079L"))) {
                    emailAddressFactory3 = EmailAddressFactory.substring(streamTokenizer);
                } else {
                    short s = EmailAddressFactory.getSourceType(streamTokenizer.sval);
                    String string = null;
                    if (s == 3) {
                        string = streamTokenizer.sval;
                    }
                    emailAddressFactory3 = new EmailAddressFactory(s, string, false, 0, 0);
                }
            } else {
                if (streamTokenizer.ttype == 43) continue;
                EmailAddressFactory.badTokenException(streamTokenizer);
            }
            if (emailAddressFactory2 == null) {
                emailAddressFactory = emailAddressFactory3;
            } else {
                emailAddressFactory2.next = emailAddressFactory3;
            }
            emailAddressFactory2 = emailAddressFactory3;
        }
        return emailAddressFactory;
    }

    private static EmailAddressFactory substring(StreamTokenizer streamTokenizer) throws LocalizableException {
        int n = Short.MAX_VALUE;
        EmailAddressFactory.nextToken(streamTokenizer, true, 40);
        EmailAddressFactory.nextToken(streamTokenizer, true, -3);
        short s = EmailAddressFactory.getSourceType(streamTokenizer.sval);
        if (s == 3) {
            EmailAddressFactory.badTokenException(streamTokenizer);
        }
        EmailAddressFactory.nextToken(streamTokenizer, true, 44);
        EmailAddressFactory.nextToken(streamTokenizer, true, -3);
        int n2 = EmailAddressFactory.stringToInt(streamTokenizer);
        EmailAddressFactory.nextToken(streamTokenizer, true, 0);
        if (streamTokenizer.ttype == 44) {
            EmailAddressFactory.nextToken(streamTokenizer, true, -3);
            n = EmailAddressFactory.stringToInt(streamTokenizer);
            EmailAddressFactory.nextToken(streamTokenizer, true, 41);
        } else if (streamTokenizer.ttype != 41) {
            EmailAddressFactory.badTokenException(streamTokenizer);
        }
        if (n2 >= n) {
            throw new LocalizableException("STS0071E", null);
        }
        return new EmailAddressFactory(s, null, true, n2, n);
    }

    private static short getSourceType(String string) {
        int n = string.equalsIgnoreCase("firstname") || string.equals(MessageLog.getMessageNoID("STG6075L")) ? 2 : (string.equalsIgnoreCase("lastname") || string.equals(MessageLog.getMessageNoID("STG6076L")) ? 1 : (string.equalsIgnoreCase("userid") || string.equals(MessageLog.getMessageNoID("STG6074L")) ? 0 : 3));
        return (short)n;
    }

    private static int nextToken(StreamTokenizer streamTokenizer, boolean bl, int n) throws LocalizableException {
        if (streamTokenizer.ttype != -1) {
            try {
                streamTokenizer.nextToken();
            }
            catch (IOException iOException) {
                throw new NestableException("STS0068E", null, iOException);
            }
        }
        if (streamTokenizer.ttype == -1) {
            if (bl) {
                throw new LocalizableException("STS0069E", null);
            }
        } else {
            if (streamTokenizer.ttype == 34 || streamTokenizer.ttype == 39) {
                streamTokenizer.ttype = -3;
            }
            if (n != 0 && n != streamTokenizer.ttype) {
                EmailAddressFactory.badTokenException(streamTokenizer);
            }
        }
        return streamTokenizer.ttype;
    }

    private static int stringToInt(StreamTokenizer streamTokenizer) throws LocalizableException {
        try {
            return Integer.parseInt(streamTokenizer.sval);
        }
        catch (NumberFormatException numberFormatException) {
            EmailAddressFactory.badTokenException(streamTokenizer);
            return -1;
        }
    }

    private static void badTokenException(StreamTokenizer streamTokenizer) throws LocalizableException {
        Object[] objectArray = new Object[]{streamTokenizer.toString()};
        throw new LocalizableException("STS0070E", objectArray);
    }

    private EmailAddressFactory(short s, String string, boolean bl, int n, int n2) {
        this.sourceType = s;
        this.literal = string;
        this.substring = bl;
        this.substringStart = (short)n;
        this.substringEnd = (short)n2;
    }

    private void appendSubstring(String string, StringBuffer stringBuffer) {
        if (this.substringStart >= string.length()) {
            return;
        }
        int n = this.substringEnd > string.length() ? string.length() : (int)this.substringEnd;
        int n2 = this.substringStart;
        while (n2 < n) {
            stringBuffer.append(string.charAt(n2));
            ++n2;
        }
    }
}

