/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class ProbePing
extends ScheduleHeader {
    static final long serialVersionUID = -2817533105300124997L;
    public static final int PING_PINGS = 0;
    public static final int PING_MINUTES = 1;
    public static final int PING_HOURS = 2;
    public static final int PING_DAYS = 3;
    public NameList pbComputers;
    public NameList pbComputerGroups;
    public NameList pbClusters;
    public NameList pbDiskArrays;
    public NameList pbDiskArrayGroups;
    public NameList pbFabrics;
    public NameList pbFabricGroups;
    public NameList pbLibraries;
    public NameList pbLibrariesGroups;
    public boolean pbAllLibraries;
    public boolean pbAllComputers;
    public boolean pbAllDiskArrays;
    public boolean pbAllFabrics;
    public NameList pbSnmpCommunities;
    public AlertDefinition pbAlert;
    public NameList pbManualSlpDAs;
    public NameList pbSnmpIPAddresses;
    public String pbBrocadeUserName;
    public String pbBrocadePassword;
    public boolean validateIPs = false;

    public ProbePing(short s) {
        this.jobType = s;
    }

    private boolean communitiesEqual(ProbePing probePing) {
        NameList nameList;
        int n = 0;
        boolean bl = true;
        NameList nameList2 = this.pbSnmpCommunities;
        while (bl && nameList2 != null) {
            String string = nameList2.nlName;
            nameList = probePing.pbSnmpCommunities;
            while (nameList != null && !string.equals(nameList.nlName)) {
                nameList = nameList.nlNext;
            }
            if (nameList == null) {
                bl = false;
                continue;
            }
            ++n;
            nameList2 = nameList2.nlNext;
        }
        if (bl) {
            nameList = probePing.pbSnmpCommunities;
            while (nameList != null) {
                --n;
                nameList = nameList.nlNext;
            }
            if (n != 0) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ProbePing probePing = (ProbePing)object;
        return AlertDefinition.alertDefsEqual(this.pbAlert, probePing.pbAlert) && NameList.nameListsEqual(this.pbComputers, probePing.pbComputers) && NameList.nameListsEqual(this.pbComputerGroups, probePing.pbComputerGroups) && this.pbAllComputers == probePing.pbAllComputers && NameList.nameListsEqual(this.pbDiskArrays, probePing.pbDiskArrays) && NameList.nameListsEqual(this.pbDiskArrayGroups, probePing.pbDiskArrayGroups) && this.pbAllDiskArrays == probePing.pbAllDiskArrays && NameList.nameListsEqual(this.pbFabrics, probePing.pbFabrics) && NameList.nameListsEqual(this.pbFabricGroups, probePing.pbFabricGroups) && this.pbAllFabrics == probePing.pbAllFabrics && NameList.nameListsEqual(this.pbLibraries, probePing.pbLibraries) && NameList.nameListsEqual(this.pbLibrariesGroups, probePing.pbLibrariesGroups) && this.pbAllLibraries == probePing.pbAllLibraries && this.communitiesEqual(probePing) && Util.stringsEqual(this.pbBrocadeUserName, probePing.pbBrocadeUserName) && Util.stringsEqual(this.pbBrocadePassword, probePing.pbBrocadePassword) && NameList.nameMasksListsEqual(this.pbManualSlpDAs, probePing.pbManualSlpDAs) && NameList.nameMasksListsEqual(this.pbSnmpIPAddresses, probePing.pbSnmpIPAddresses) && NameList.nameListsEqual(this.pbClusters, probePing.pbClusters);
    }

    public Object clone() {
        ProbePing probePing = (ProbePing)super.clone();
        probePing.pbComputers = NameList.cloneNameList(this.pbComputers);
        probePing.pbComputerGroups = NameList.cloneNameList(this.pbComputerGroups);
        probePing.pbClusters = NameList.cloneNameList(this.pbClusters);
        probePing.pbDiskArrays = NameList.cloneNameList(this.pbDiskArrays);
        probePing.pbDiskArrayGroups = NameList.cloneNameList(this.pbDiskArrayGroups);
        probePing.pbFabrics = NameList.cloneNameList(this.pbFabrics);
        probePing.pbFabricGroups = NameList.cloneNameList(this.pbFabricGroups);
        probePing.pbLibraries = NameList.cloneNameList(this.pbLibraries);
        probePing.pbLibrariesGroups = NameList.cloneNameList(this.pbLibrariesGroups);
        probePing.pbSnmpCommunities = NameList.cloneNameList(this.pbSnmpCommunities);
        probePing.pbManualSlpDAs = NameList.cloneNameList(this.pbManualSlpDAs);
        probePing.pbSnmpIPAddresses = NameList.cloneNameList(this.pbSnmpIPAddresses);
        if (this.pbAlert != null) {
            probePing.pbAlert = (AlertDefinition)this.pbAlert.clone();
        }
        return probePing;
    }

    public boolean isEmpty() {
        return this.pbComputers == null && this.pbComputerGroups == null && this.pbClusters == null && !this.pbAllComputers && this.pbDiskArrays == null && this.pbDiskArrayGroups == null && !this.pbAllDiskArrays && this.pbFabrics == null && this.pbFabricGroups == null && !this.pbAllFabrics && this.pbManualSlpDAs == null && this.pbSnmpIPAddresses == null && this.pbBrocadeUserName == null && this.pbBrocadePassword == null && this.pbLibraries == null && this.pbLibrariesGroups == null && !this.pbAllLibraries;
    }
}

