/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.San.gui.HostPathTable;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.gui.DiskDDI;
import org.eclipse.aperi.TStorm.gui.DiskHistTable;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeData;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.TStorm.server.guireq.GuiUpdateRequest;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskData
extends JTabbedPane
implements ChangeListener,
GuiRequestor,
ActionListener,
ItemListener {
    private static GridBagLayout gridBag = new GridBagLayout();
    private static GridBagConstraints gbcFill_1 = new GridBagConstraints();
    private static GridBagConstraints gbcFill_2 = new GridBagConstraints();
    private static GridBagConstraints gbcLabel = new GridBagConstraints();
    private static GridBagConstraints gbcLast = new GridBagConstraints();
    private static final Dimension DIM11 = new Dimension(1, 1);
    private static String MB = MessageLog.getMessageNoID("GEN0189T");
    private JPanel hTab = new JPanel(new BorderLayout());
    private String INFO = "  " + MessageLog.getMessageNoID("STG1140L") + "  ";
    private String PATHS = "  " + MessageLog.getMessageNoID("STG6055L") + "  ";
    private String PROBE = "  " + MessageLog.getMessageNoID("STG1141L") + "  ";
    private String HISTORY = "  " + MessageLog.getMessageNoID("STG1142L") + "  ";
    private String LUN = "  " + MessageLog.getMessageNoID("SAG0512L") + "  ";
    private String TRUE = MessageLog.getMessageNoID("GUI0119T");
    private String FALSE = MessageLog.getMessageNoID("GUI0120T");
    private String YES = MessageLog.getMessageNoID("GUI0121T");
    private String NO = MessageLog.getMessageNoID("GUI0122T");
    private String ON = MessageLog.getMessageNoID("GUI0123T");
    private String OFF = MessageLog.getMessageNoID("GUI0124T");
    private String READ = MessageLog.getMessageNoID("GUI0125T");
    private String WRITE = MessageLog.getMessageNoID("GUI0126T");
    private String BOTH = MessageLog.getMessageNoID("GUI0127T");
    private String NONE = MessageLog.getMessageNoID("GUI0128T");
    private String UNKNOWN = MessageLog.getMessageNoID("GUI0129T");
    private int currentIndex = 0;
    protected static final int INFO_INDEX = 0;
    protected static final int PATH_INDEX = 1;
    protected static final int PROBE_INDEX = 2;
    protected static final int HISTORY_INDEX = 3;
    protected static final int LUN_INDEX = 4;
    private boolean pathTabCreated = false;
    private JPanel pathPanel = new JPanel(new BorderLayout());
    private JScrollPane pathTab = new JScrollPane(this.pathPanel);
    private int serverRequestType;
    private static final int CHANGE_DESIRED_SETTINGS = 101;
    private boolean histTabCreated = false;
    private boolean isLodestoneCluster = false;
    private boolean isFAStT = false;
    private int diskID;
    private Disk disk;
    private String path;
    private int computerID;
    private DiskDDI myDDI;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();
    private boolean tabReset = false;
    private boolean infoTabCreated = false;
    private JPanel iTab = new JPanel(new BorderLayout());
    private boolean probeTabCreated = false;
    private JPanel pPanel = new JPanel(gridBag);
    private JScrollPane pTab = new JScrollPane(this.pPanel);
    private static final String APPLY = "STG1153L";
    private static final String RESET = "STG1154L";
    private TComboBox pdDskDesiredAWRE;
    private TComboBox pdDskDesiredARRE;
    private TComboBox pdDskDesiredNoErrRcvry;
    protected JButton applyButton = new JButton(MessageLog.getMessageNoID("STG1153L"));
    private JButton resetButton = new JButton(MessageLog.getMessageNoID("STG1154L"));
    protected byte oldAWRE;
    protected byte oldARRE;
    protected byte oldNER;
    protected byte newAWRE;
    protected byte newARRE;
    protected byte newNER;
    private boolean lunTabCreated = false;
    private JPanel lTab;
    private DecimalFormat d0Fmt = new DecimalFormat();

    public DiskData(int n, String string, int n2, byte by, byte by2, byte by3, DiskDDI diskDDI) {
        this.diskID = n;
        this.path = string;
        this.computerID = n2;
        this.newAWRE = by;
        this.newARRE = by2;
        this.newNER = by3;
        this.myDDI = diskDDI;
        Object[] objectArray = new String[Disk.STATES.length - 1];
        System.arraycopy(Disk.STATES, 1, objectArray, 0, objectArray.length);
        this.pdDskDesiredAWRE = new TComboBox(objectArray);
        this.pdDskDesiredARRE = new TComboBox(objectArray);
        this.pdDskDesiredNoErrRcvry = new TComboBox(objectArray);
        this.isLodestoneCluster(diskDDI.diskArrayType);
        this.getInfo();
        this.setPreferredSize(DIM11);
        this.addTab(this.INFO, this.iTab);
        this.addTab(this.PATHS, this.pathTab);
        this.addTab(this.PROBE, this.pTab);
        this.addTab(this.HISTORY, this.hTab);
        if (GuiUtil.isAnyDiskArrayInstalled()) {
            this.lTab = new JPanel(new BorderLayout());
            this.addTab(this.LUN, this.lTab);
            this.setEnabledAt(4, diskDDI.logicalDiskID > 0);
        }
        this.hTab.setPreferredSize(DIM11);
        this.addChangeListener(this);
        DiskData.gbcFill_1.gridheight = 40;
        DiskData.gbcFill_1.weighty = 1.0;
        DiskData.gbcFill_1.ipadx = 60;
        DiskData.gbcFill_2.gridwidth = 4;
        DiskData.gbcFill_2.weightx = 1.0;
        DiskData.gbcLabel.anchor = 17;
        DiskData.gbcLabel.ipadx = 30;
        DiskData.gbcLast.anchor = 17;
        DiskData.gbcLast.gridwidth = 0;
        this.applyButton.setEnabled(false);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        block15: {
            block14: {
                if (this.tabReset) break block14;
                this.myDDI.tabDisplayed = this.currentIndex = this.getSelectedIndex();
                switch (this.currentIndex) {
                    case 0: {
                        if (!this.infoTabCreated) {
                            this.getInfo();
                            break;
                        }
                        break block15;
                    }
                    case 1: {
                        if (!this.pathTabCreated) {
                            this.getPathInfo();
                            break;
                        }
                        break block15;
                    }
                    case 2: {
                        if (!this.probeTabCreated) {
                            this.getProbeInfo();
                            break;
                        }
                        break block15;
                    }
                    case 3: {
                        if (!this.histTabCreated) {
                            this.getProbeHistInfo();
                            break;
                        }
                        break block15;
                    }
                    case 4: {
                        if (this.lunTabCreated) break block15;
                        this.getLunInfo();
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block15;
            }
            this.tabReset = true;
            this.setSelectedIndex(2);
            this.tabReset = false;
        }
    }

    private boolean isLodestoneCluster(short s) {
        if (s == 21) {
            this.isLodestoneCluster = true;
        }
        return this.isLodestoneCluster;
    }

    private void getInfo() {
        this.serverRequestType = 0;
        Request request = new Request();
        GuiRequest.diskInfo(request, this.diskID);
        GuiClient.doRequest(this, request);
    }

    private void getPathInfo() {
        boolean bl;
        JPanel jPanel = null;
        boolean bl2 = bl = this.disk.dskHostPaths != null;
        if (bl) {
            HostPathTable hostPathTable = new HostPathTable(this.disk.dskHostPaths);
            jPanel = hostPathTable;
        } else {
            String string = MessageLog.getMessageNoID("STG0020M");
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(Color.black);
            jLabel.setFont(BaseTree.boldFont);
            jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)jLabel, new GridBagConstraints());
        }
        this.pathPanel.add((Component)jPanel, "Center");
        this.pathTabCreated = true;
    }

    private void getProbeInfo() {
        this.serverRequestType = 2;
        Request request = new Request();
        GuiRequest.diskProbeInfo(request, this.diskID);
        GuiClient.doRequest(this, request);
    }

    private void getLunInfo() {
        this.serverRequestType = 4;
        Request request = new Request();
        GuiRequest.lunInfo(request, this.myDDI.logicalDiskID);
        GuiClient.doRequest(this, request);
    }

    private void getProbeHistInfo() {
        this.serverRequestType = 3;
        Request request = new Request();
        GuiRequest.diskHistory(request, this.diskID);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            if (this.serverRequestType == 0) {
                DevAccess devAccess = (DevAccess)response.responseData;
                if (devAccess != null && devAccess.daDevice instanceof Disk) {
                    this.disk = (Disk)devAccess.daDevice;
                    if (this.getTabCount() > 4) {
                        this.myDDI.logicalDiskID = this.disk.dskLogicalDiskID;
                        this.setEnabledAt(4, this.disk.dskLogicalDiskID > 0);
                    }
                }
                this.createInfoTab(devAccess);
            } else if (this.serverRequestType == 2) {
                Disk disk = (Disk)response.responseData;
                this.createProbeTab(disk);
            } else if (this.serverRequestType == 3) {
                DiskHistory[] diskHistoryArray = (DiskHistory[])response.responseData;
                this.createProbeHistTab(diskHistoryArray);
            } else if (this.serverRequestType == 4) {
                this.createLunTab((Lun)response.responseData);
            } else if (this.serverRequestType == 101) {
                this.oldAWRE = this.newAWRE;
                this.oldARRE = this.newARRE;
                this.oldNER = this.newNER;
                this.applyButton.setEnabled(false);
                this.resetButton.setEnabled(false);
            }
            this.validate();
        }
    }

    private void createInfoTab(DevAccess devAccess) {
        JPanel jPanel = GuiUtil.getBorderedPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.iTab.add((Component)jPanel, "North");
        this.iTab.add((Component)jScrollPane, "Center");
        String string = this.myDDI.inDiskArray ? (this.isLodestoneCluster ? "STG4500L" : "STG4201L") : "STG1102L";
        JLabel jLabel = new JLabel(MessageLog.getMessageNoID(string));
        JLabel jLabel2 = new JLabel(MessageLog.getMessageNoID("STG1219L"));
        JLabel jLabel3 = new JLabel(MessageLog.getMessageNoID("STG1144L"));
        JLabel jLabel4 = new JLabel(MessageLog.getMessageNoID("STG1145L"));
        JLabel jLabel5 = new JLabel(MessageLog.getMessageNoID("STG1105L"));
        JLabel jLabel6 = new JLabel(MessageLog.getMessageNoID("STG1106L"));
        JLabel jLabel7 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1146L")) + "    ");
        JLabel jLabel8 = new JLabel(MessageLog.getMessageNoID("STG1107L"));
        JLabel jLabel9 = new JLabel(MessageLog.getMessageNoID("STG1147L"));
        JLabel jLabel10 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1148L")) + "    ");
        JLabel jLabel11 = new JLabel(MessageLog.getMessageNoID("STG1150L"));
        JLabel jLabel12 = new JLabel(MessageLog.getMessageNoID("STG1151L"));
        JLabel jLabel13 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1134L")) + "    ");
        JLabel jLabel14 = new JLabel();
        JLabel jLabel15 = new JLabel();
        JLabel jLabel16 = new JLabel();
        JLabel jLabel17 = new JLabel();
        JLabel jLabel18 = new JLabel();
        JLabel jLabel19 = new JLabel();
        JLabel jLabel20 = new JLabel();
        JLabel jLabel21 = new JLabel();
        JLabel jLabel22 = new JLabel();
        JLabel jLabel23 = new JLabel();
        JLabel jLabel24 = new JLabel();
        JLabel jLabel25 = new JLabel();
        JLabel jLabel26 = new JLabel();
        JLabel jLabel27 = new JLabel(" ");
        JLabel jLabel28 = new JLabel(" ");
        JLabel jLabel29 = new JLabel(" ");
        JLabel jLabel30 = new JLabel(" ");
        JLabel jLabel31 = new JLabel("                  ");
        this.infoTabCreated = true;
        Disk disk = (Disk)devAccess.daDevice;
        disk.unpack();
        jLabel14.setText(this.myDDI.enclosure);
        jLabel15.setText(devAccess.daPath);
        jLabel16.setText(this.numFormat(devAccess.daTarget));
        jLabel17.setText(this.numFormat(devAccess.daLUN));
        if ((disk.devFlags & 1) != 0) {
            jLabel18.setText(this.UNKNOWN);
        } else if (disk.devManufacturer.toLowerCase().equals("unknown")) {
            jLabel18.setText(this.UNKNOWN);
        } else {
            jLabel18.setText(disk.devManufacturer);
        }
        if (Util.isEmpty(disk.devModel)) {
            jLabel19.setText(this.UNKNOWN);
        } else {
            jLabel19.setText(disk.devModel);
        }
        if (Util.isEmpty(disk.devFirmwareRev)) {
            jLabel20.setText(this.UNKNOWN);
        } else {
            jLabel20.setText(disk.devFirmwareRev);
        }
        if ((disk.devFlags & 2) != 0) {
            jLabel21.setText(this.UNKNOWN);
        } else if (Util.isEmpty(disk.devSubsystemSerialNumber)) {
            jLabel21.setText(disk.devSerialNumber);
        } else {
            jLabel21.setText(String.valueOf(disk.devSubsystemSerialNumber) + "/" + disk.devSerialNumber);
        }
        jLabel22.setText(disk.devManufactureDate < 86400000L ? this.UNKNOWN : DateFormat.getDateTimeInstance().format(new Date(disk.devManufactureDate)));
        jLabel23.setText(this.numFormat(disk.devUseCount));
        jLabel24.setText(disk.devMultiPort ? this.TRUE : this.FALSE);
        jLabel25.setText(disk.devUnsupportedModel ? this.TRUE : this.FALSE);
        jLabel26.setText(DateFormat.getDateTimeInstance().format(new Date(disk.devDiscoveredTime)));
        jPanel.add((Component)jLabel29, gbcFill_1);
        jPanel.add((Component)jLabel30, gbcFill_2);
        jPanel.add((Component)jLabel31, gbcLast);
        jPanel.add((Component)jLabel27, gbcLast);
        jPanel.add((Component)jLabel, gbcLabel);
        jPanel.add((Component)jLabel14, gbcLast);
        jPanel.add((Component)jLabel2, gbcLabel);
        jPanel.add((Component)jLabel15, gbcLast);
        jPanel.add((Component)jLabel3, gbcLabel);
        jPanel.add((Component)jLabel16, gbcLast);
        jPanel.add((Component)jLabel4, gbcLabel);
        jPanel.add((Component)jLabel17, gbcLast);
        jPanel.add((Component)jLabel10, gbcLabel);
        jPanel.add((Component)jLabel23, gbcLast);
        jPanel.add((Component)jLabel27, gbcLast);
        jPanel.add((Component)jLabel5, gbcLabel);
        jPanel.add((Component)jLabel18, gbcLast);
        jPanel.add((Component)jLabel6, gbcLabel);
        jPanel.add((Component)jLabel19, gbcLast);
        jPanel.add((Component)jLabel7, gbcLabel);
        jPanel.add((Component)jLabel20, gbcLast);
        jPanel.add((Component)jLabel8, gbcLabel);
        jPanel.add((Component)jLabel21, gbcLast);
        jPanel.add((Component)jLabel9, gbcLabel);
        jPanel.add((Component)jLabel22, gbcLast);
        jPanel.add((Component)jLabel13, gbcLabel);
        jPanel.add((Component)jLabel26, gbcLast);
        jPanel.add((Component)jLabel28, gbcLast);
        jPanel.add((Component)jLabel11, gbcLabel);
        jPanel.add((Component)jLabel24, gbcLast);
        jPanel.add((Component)jLabel12, gbcLabel);
        jPanel.add((Component)jLabel25, gbcLast);
        jPanel.add((Component)new JLabel(" "), gbcLast);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.path);
        JTree jTree = new JTree(defaultMutableTreeNode);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        Chunk chunk = disk.dskChunk;
        while (chunk != null) {
            String string2;
            String string3;
            if (this.isLodestoneCluster) {
                string3 = Util.formatBytes(chunk.chkOffset * 0x100000L);
                string2 = Util.formatBytes(chunk.chkSize * 0x100000L);
            } else {
                string3 = Util.formatBytes(chunk.chkOffset * (long)chunk.chkUnitSize);
                string2 = Util.formatBytes(chunk.chkSize * (long)chunk.chkUnitSize);
            }
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(MessageLog.getMessageNoID("STG1242L", new Object[]{string3, string2})));
            chunk = chunk.chkNextOnDisk;
        }
        jScrollPane.setViewportView(jTree);
        defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
    }

    private static byte truncate(byte by) {
        if (by < 1) {
            by = 1;
        }
        return (byte)(by - 1);
    }

    private void createProbeTab(Disk disk) {
        JLabel jLabel = new JLabel(MessageLog.getMessageNoID("STG1155L"));
        JLabel jLabel2 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1156L")) + "    ");
        JLabel jLabel3 = new JLabel(MessageLog.getMessageNoID("STG1157L"));
        JLabel jLabel4 = new JLabel(MessageLog.getMessageNoID("STG1158L"));
        JLabel jLabel5 = new JLabel(MessageLog.getMessageNoID("STG1159L"));
        JLabel jLabel6 = new JLabel(MessageLog.getMessageNoID("STG1160L"));
        JLabel jLabel7 = new JLabel(MessageLog.getMessageNoID("STG1161L"));
        JLabel jLabel8 = new JLabel(MessageLog.getMessageNoID("STG1162L"));
        JLabel jLabel9 = new JLabel(MessageLog.getMessageNoID("STG1163L"));
        JLabel jLabel10 = new JLabel(MessageLog.getMessageNoID("STG1164L"));
        JLabel jLabel11 = new JLabel(MessageLog.getMessageNoID("STG1165L"));
        JLabel jLabel12 = new JLabel(MessageLog.getMessageNoID("STG1166L"));
        JLabel jLabel13 = new JLabel(MessageLog.getMessageNoID("STG1167L"));
        JLabel jLabel14 = new JLabel(MessageLog.getMessageNoID("STG1168L"));
        JLabel jLabel15 = new JLabel(MessageLog.getMessageNoID("STG1169L"));
        JLabel jLabel16 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1170L")) + "    ");
        JLabel jLabel17 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1171L")) + "    ");
        JLabel jLabel18 = new JLabel(MessageLog.getMessageNoID("STG1172L"));
        JLabel jLabel19 = new JLabel(MessageLog.getMessageNoID("STG1173L"));
        JLabel jLabel20 = new JLabel(MessageLog.getMessageNoID("STG1174L"));
        JLabel jLabel21 = new JLabel(MessageLog.getMessageNoID("STG1175L"));
        JLabel jLabel22 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1152L")) + "             ");
        JLabel jLabel23 = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1176L")) + "              ");
        JLabel jLabel24 = new JLabel(MessageLog.getMessageNoID("STG1177L"));
        JLabel jLabel25 = new JLabel(MessageLog.getMessageNoID("STG1178L"));
        JLabel jLabel26 = new JLabel(MessageLog.getMessageNoID("STG1179L"));
        JLabel jLabel27 = new JLabel(MessageLog.getMessageNoID("STG1180L"));
        JLabel jLabel28 = new JLabel(MessageLog.getMessageNoID("STG1181L"));
        JLabel jLabel29 = new JLabel(MessageLog.getMessageNoID("STG1182L"));
        JLabel jLabel30 = new JLabel(MessageLog.getMessageNoID("STG1183L"));
        JLabel jLabel31 = new JLabel(MessageLog.getMessageNoID("STG4131L"));
        JLabel jLabel32 = new JLabel();
        JLabel jLabel33 = new JLabel();
        JLabel jLabel34 = new JLabel();
        JLabel jLabel35 = new JLabel();
        JLabel jLabel36 = new JLabel();
        JLabel jLabel37 = new JLabel();
        JLabel jLabel38 = new JLabel();
        JLabel jLabel39 = new JLabel();
        JLabel jLabel40 = new JLabel();
        JLabel jLabel41 = new JLabel();
        JLabel jLabel42 = new JLabel();
        JLabel jLabel43 = new JLabel();
        JLabel jLabel44 = new JLabel();
        JLabel jLabel45 = new JLabel();
        JLabel jLabel46 = new JLabel();
        JLabel jLabel47 = new JLabel();
        JLabel jLabel48 = new JLabel();
        JLabel jLabel49 = new JLabel();
        JLabel jLabel50 = new JLabel();
        JLabel jLabel51 = new JLabel();
        JLabel jLabel52 = new JLabel();
        JLabel jLabel53 = new JLabel();
        JLabel jLabel54 = new JLabel();
        JLabel jLabel55 = new JLabel();
        JLabel jLabel56 = new JLabel();
        JLabel jLabel57 = new JLabel();
        JLabel jLabel58 = new JLabel();
        JLabel jLabel59 = new JLabel();
        JLabel jLabel60 = new JLabel();
        JLabel jLabel61 = new JLabel();
        JLabel jLabel62 = new JLabel();
        this.pdDskDesiredAWRE.setEditable(false);
        this.pdDskDesiredARRE.setEditable(false);
        this.pdDskDesiredNoErrRcvry.setEditable(false);
        this.pdDskDesiredAWRE.addItemListener(this);
        this.pdDskDesiredARRE.addItemListener(this);
        this.pdDskDesiredNoErrRcvry.addItemListener(this);
        this.applyButton.setToolTipText(MessageLog.getMessageNoID("STG1185T"));
        this.applyButton.addActionListener(this);
        this.applyButton.setActionCommand(APPLY);
        this.resetButton.setToolTipText(MessageLog.getMessageNoID("STG1186T"));
        this.resetButton.addActionListener(this);
        this.resetButton.setActionCommand(RESET);
        this.applyButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_APPLY"));
        GuiUtil.setAccessible(this.applyButton, this.applyButton.getText(), this.applyButton.getText());
        this.resetButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_RESET"));
        GuiUtil.setAccessible(this.resetButton, this.resetButton.getText(), this.resetButton.getText());
        JLabel jLabel63 = new JLabel(" ");
        JLabel jLabel64 = new JLabel(" ");
        JLabel jLabel65 = new JLabel(" ");
        new JLabel(" ");
        new JLabel(" ");
        this.probeTabCreated = true;
        DiskHistory diskHistory = disk.dskHistory;
        jLabel32.setText(this.numFormat(disk.dskSectorSize));
        jLabel33.setText(this.numFormat(disk.dskSectorsPerAvgTrack));
        jLabel34.setText(this.numFormat(disk.dskSectorsPerOuterTrack));
        jLabel35.setText(this.numFormat(disk.dskSectorsPerInnerTrack));
        jLabel36.setText(this.numFormat(disk.dskHeads));
        jLabel37.setText(this.numFormat(disk.dskCylinders));
        jLabel38.setText(this.numFormat(disk.dskLogicalBlockSize));
        if (disk.dskCapacity == 0L) {
            jLabel39.setText(MessageLog.getMessageNoID("BTM0570L"));
        } else {
            jLabel39.setText(Util.formatBytes(disk.dskCapacity * 512L));
        }
        jLabel40.setText(this.numFormat(disk.dskRPM));
        jLabel41.setText(GuiUtil.formatElapsed(disk.dskMinutesPoweredOn));
        jLabel42.setText(this.numFormat(disk.dskSpareBlocks));
        jLabel43.setText(disk.dskWriteProtected ? this.ON : this.OFF);
        String string = disk.dskReadCacheDisabled ? (disk.dskWriteCacheEnabled ? this.WRITE : this.NONE) : (disk.dskWriteCacheEnabled ? this.BOTH : this.READ);
        jLabel44.setText(string);
        jLabel45.setText(disk.dskAutoWriteRealloc ? this.ON : this.OFF);
        jLabel46.setText(disk.dskAutoReadRealloc ? this.ON : this.OFF);
        jLabel47.setText(disk.dskNoErrorRecovery ? this.ON : this.OFF);
        jLabel48.setText(disk.dskFailurePredicted ? this.YES : this.NO);
        this.oldAWRE = disk.dskDesiredAWRE;
        this.oldARRE = disk.dskDesiredARRE;
        this.oldNER = disk.dskDesiredNoErrRcvry;
        if (this.newAWRE != -1 && (this.oldAWRE != this.newAWRE || this.oldARRE != this.newARRE || this.oldNER != this.newNER)) {
            disk.dskDesiredARRE = this.newARRE;
            disk.dskDesiredAWRE = this.newAWRE;
            disk.dskDesiredNoErrRcvry = this.newNER;
            this.applyButton.setEnabled(this.capabilities.isAnyAdmin());
            this.resetButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
        this.pdDskDesiredAWRE.setSelectedIndex(DiskData.truncate(disk.dskDesiredAWRE));
        this.pdDskDesiredARRE.setSelectedIndex(DiskData.truncate(disk.dskDesiredARRE));
        this.pdDskDesiredNoErrRcvry.setSelectedIndex(DiskData.truncate(disk.dskDesiredNoErrRcvry));
        jLabel49.setText(this.numFormat(diskHistory.dkhPrimaryDefects));
        jLabel50.setText(this.numFormat(diskHistory.dkhGrownDefects));
        jLabel51.setText(this.numFormat(diskHistory.dkhRecoveredWriteErrors));
        jLabel52.setText(this.numFormat(diskHistory.dkhUnrecoveredWriteErrors));
        jLabel53.setText(String.valueOf(Util.formatBytes(diskHistory.dkhBytesWritten)) + "      ");
        jLabel54.setText(this.numFormat(diskHistory.dkhRecoveredReadErrors));
        jLabel55.setText(this.numFormat(diskHistory.dkhUnrecoveredReadErrors));
        jLabel56.setText(String.valueOf(Util.formatBytes(diskHistory.dkhBytesRead)) + "      ");
        jLabel57.setText(this.numFormat(diskHistory.dkhRecoveredVerifyErrors));
        jLabel58.setText(this.numFormat(diskHistory.dkhUnrecoveredVerifyErrors));
        jLabel59.setText(this.numFormat(diskHistory.dkhNonMediumErrors));
        jLabel60.setText(DateFormat.getDateTimeInstance().format(new Date(diskHistory.dkhTimestamp)));
        jLabel61.setText(this.numFormat(diskHistory.dkhTemperature));
        jLabel62.setText(Util.formatBytes(diskHistory.dkhFreeSpace * 512L));
        this.pPanel.add((Component)jLabel63, gbcFill_1);
        this.pPanel.add((Component)jLabel64, gbcFill_2);
        this.pPanel.add((Component)jLabel65, gbcLast);
        this.pPanel.add((Component)jLabel, gbcLabel);
        this.pPanel.add((Component)jLabel32, gbcLast);
        this.pPanel.add((Component)jLabel2, gbcLabel);
        this.pPanel.add((Component)jLabel33, gbcLast);
        this.pPanel.add((Component)jLabel3, gbcLabel);
        this.pPanel.add((Component)jLabel34, gbcLast);
        this.pPanel.add((Component)jLabel4, gbcLabel);
        this.pPanel.add((Component)jLabel35, gbcLast);
        this.pPanel.add((Component)jLabel5, gbcLabel);
        this.pPanel.add((Component)jLabel36, gbcLast);
        this.pPanel.add((Component)jLabel6, gbcLabel);
        this.pPanel.add((Component)jLabel37, gbcLast);
        this.pPanel.add((Component)jLabel7, gbcLabel);
        this.pPanel.add((Component)jLabel38, gbcLast);
        this.pPanel.add((Component)jLabel8, gbcLabel);
        this.pPanel.add((Component)jLabel39, gbcLast);
        this.pPanel.add((Component)jLabel9, gbcLabel);
        this.pPanel.add((Component)jLabel40, gbcLast);
        this.pPanel.add((Component)jLabel10, gbcLabel);
        this.pPanel.add((Component)jLabel41, gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)jLabel11, gbcLabel);
        this.pPanel.add((Component)jLabel42, gbcLast);
        this.pPanel.add((Component)jLabel12, gbcLabel);
        this.pPanel.add((Component)jLabel43, gbcLast);
        this.pPanel.add((Component)jLabel13, gbcLabel);
        this.pPanel.add((Component)jLabel44, gbcLast);
        this.pPanel.add((Component)jLabel19, gbcLabel);
        this.pPanel.add((Component)jLabel48, gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)jLabel29, gbcLabel);
        this.pPanel.add((Component)jLabel60, gbcLast);
        this.pPanel.add((Component)jLabel31, gbcLabel);
        this.pPanel.add((Component)jLabel62, gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)jLabel20, gbcLabel);
        this.pPanel.add((Component)jLabel49, gbcLast);
        this.pPanel.add((Component)jLabel21, gbcLabel);
        this.pPanel.add((Component)jLabel50, gbcLast);
        this.pPanel.add((Component)jLabel28, gbcLabel);
        this.pPanel.add((Component)jLabel59, gbcLast);
        this.pPanel.add((Component)jLabel30, gbcLabel);
        this.pPanel.add((Component)jLabel61, gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLabel);
        this.pPanel.add((Component)jLabel22, gbcLabel);
        this.pPanel.add((Component)jLabel23, gbcLabel);
        this.pPanel.add((Component)jLabel24, gbcLast);
        this.pPanel.add((Component)jLabel25, gbcLabel);
        this.pPanel.add((Component)jLabel51, gbcLabel);
        this.pPanel.add((Component)jLabel54, gbcLabel);
        this.pPanel.add((Component)jLabel57, gbcLast);
        this.pPanel.add((Component)jLabel26, gbcLabel);
        this.pPanel.add((Component)jLabel52, gbcLabel);
        this.pPanel.add((Component)jLabel55, gbcLabel);
        this.pPanel.add((Component)jLabel58, gbcLast);
        this.pPanel.add((Component)jLabel27, gbcLabel);
        this.pPanel.add((Component)jLabel53, gbcLabel);
        this.pPanel.add((Component)jLabel56, gbcLabel);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLabel);
        this.pPanel.add((Component)jLabel17, gbcLabel);
        this.pPanel.add((Component)jLabel18, gbcLast);
        this.pPanel.add((Component)jLabel14, gbcLabel);
        this.pPanel.add((Component)jLabel45, gbcLabel);
        this.pPanel.add((Component)this.pdDskDesiredAWRE, gbcLast);
        this.pPanel.add((Component)jLabel15, gbcLabel);
        this.pPanel.add((Component)jLabel46, gbcLabel);
        this.pPanel.add((Component)this.pdDskDesiredARRE, gbcLast);
        this.pPanel.add((Component)jLabel16, gbcLabel);
        this.pPanel.add((Component)jLabel47, gbcLabel);
        this.pPanel.add((Component)this.pdDskDesiredNoErrRcvry, gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLast);
        this.pPanel.add((Component)new JLabel(" "), gbcLabel);
        this.pPanel.add((Component)new JLabel(" "), gbcLabel);
        this.pPanel.add((Component)this.applyButton, gbcLabel);
        this.pPanel.add((Component)this.resetButton, gbcLast);
    }

    private void createProbeHistTab(DiskHistory[] diskHistoryArray) {
        DiskHistTable diskHistTable = new DiskHistTable(this.diskID, this.myDDI.diskArrayType, diskHistoryArray);
        this.hTab.add((Component)diskHistTable, "Center");
        this.histTabCreated = true;
    }

    private void createLunTab(Lun lun) {
        JPanel jPanel = GuiUtil.getBorderedPanel();
        JLabel jLabel = new JLabel(MessageLog.getMessageNoID("SAG0514L"));
        JLabel jLabel2 = new JLabel(MessageLog.getMessageNoID("SAG0513L"));
        JLabel jLabel3 = new JLabel(MessageLog.getMessageNoID("STG1105L"));
        JLabel jLabel4 = new JLabel(MessageLog.getMessageNoID("STG1106L"));
        JLabel jLabel5 = new JLabel(MessageLog.getMessageNoID("SAG0502L"));
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        JLabel jLabel11 = new JLabel(" ");
        JLabel jLabel12 = new JLabel(" ");
        JLabel jLabel13 = new JLabel(" ");
        JLabel jLabel14 = new JLabel(" ");
        JLabel jLabel15 = new JLabel("                  ");
        this.lunTabCreated = true;
        jLabel6.setText(lun.lunName);
        jLabel7.setText(lun.lunDaAlias);
        if (lun.lunDaManufacturer.toLowerCase().equals("unknown")) {
            jLabel8.setText(MessageLog.getMessageNoID("STG1020L"));
        } else {
            jLabel8.setText(lun.lunDaManufacturer);
        }
        jLabel9.setText(lun.lunDaModel);
        jLabel10.setText(lun.lunDaSerialNumber);
        int n = DiskData.gbcLabel.insets.right;
        DiskData.gbcLabel.insets.right = 16;
        jPanel.add((Component)jLabel13, gbcFill_1);
        jPanel.add((Component)jLabel14, gbcFill_2);
        jPanel.add((Component)jLabel15, gbcLast);
        jPanel.add((Component)jLabel, gbcLabel);
        jPanel.add((Component)jLabel6, gbcLast);
        if (!Util.isEmpty(lun.lunWWN)) {
            JLabel jLabel16 = new JLabel(MessageLog.getMessageNoID("SAG0620L"));
            JLabel jLabel17 = new JLabel();
            jLabel17.setText(lun.lunWWN);
            jPanel.add((Component)jLabel16, gbcLabel);
            jPanel.add((Component)jLabel17, gbcLast);
        }
        jPanel.add((Component)jLabel11, gbcLast);
        jPanel.add((Component)jLabel2, gbcLabel);
        jPanel.add((Component)jLabel7, gbcLast);
        jPanel.add((Component)jLabel3, gbcLabel);
        jPanel.add((Component)jLabel8, gbcLast);
        jPanel.add((Component)jLabel4, gbcLabel);
        jPanel.add((Component)jLabel9, gbcLast);
        jPanel.add((Component)jLabel5, gbcLabel);
        jPanel.add((Component)jLabel10, gbcLast);
        jPanel.add((Component)jLabel12, gbcLast);
        DiskData.gbcLabel.insets.right = n;
        lun.lunLogicalDisk.ldPath = lun.lunName;
        this.lTab.add((Component)jPanel, "North");
        this.lTab.add((Component)LogicalVolumeData.getLvTree(lun.lunLogicalDisk, this.myDDI.diskArrayType), "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == APPLY) {
            this.disk.dskDesiredAWRE = this.newAWRE;
            this.disk.dskDesiredARRE = this.newARRE;
            this.disk.dskDesiredNoErrRcvry = this.newNER;
            this.serverRequestType = 101;
            Request request = new Request();
            GuiUpdateRequest.updateDisk(request, this.disk);
            GuiClient.doRequest(this, request);
        } else if (string == RESET) {
            this.pdDskDesiredAWRE.setSelectedIndex(DiskData.truncate(this.oldAWRE));
            this.pdDskDesiredARRE.setSelectedIndex(DiskData.truncate(this.oldARRE));
            this.pdDskDesiredNoErrRcvry.setSelectedIndex(DiskData.truncate(this.oldNER));
            this.newAWRE = this.oldAWRE;
            this.newARRE = this.oldARRE;
            this.newNER = this.oldNER;
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
    }

    private static byte translateSetting(JComboBox jComboBox) {
        byte by = (byte)jComboBox.getSelectedIndex();
        if (by != 0) {
            by = (byte)(by + 1);
        }
        return by;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.newAWRE = DiskData.translateSetting(this.pdDskDesiredAWRE);
        this.newARRE = DiskData.translateSetting(this.pdDskDesiredARRE);
        this.newNER = DiskData.translateSetting(this.pdDskDesiredNoErrRcvry);
        if (this.oldAWRE != this.newAWRE || this.oldARRE != this.newARRE || this.oldNER != this.newNER) {
            this.applyButton.setEnabled(this.capabilities.isAnyAdmin());
            this.resetButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
    }

    private String numFormat(int n) {
        return this.numFormat((long)n);
    }

    private String numFormat(short s) {
        return this.numFormat((long)s);
    }

    private String numFormat(long l) {
        this.d0Fmt.setMaximumFractionDigits(2);
        return l < 0L ? MessageLog.getMessageNoID("STG0019T") : this.d0Fmt.format(l);
    }
}

