/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.ReportingTableDDI;
import org.eclipse.aperi.TStorm.gui.ReportingTreeLabel;
import org.eclipse.aperi.TStorm.gui.ReportingTreeNode;
import org.eclipse.aperi.TStorm.gui.UnTabbedReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiSavedReportReq;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiDelete;
import org.eclipse.aperi.gui.GuiRename;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class SavedReportNode
extends ReportingTreeNode
implements ActionListener,
GuiRequestor {
    private NameList name;
    private String actionCmd;
    private static final String GENERATE = "G";
    private static final String DELETE = "D";
    private static final String RENAME = "R";
    public JPopupMenu menu = null;

    public SavedReportNode(NameList nameList) {
        this.name = nameList;
        this.setUserObject(nameList);
        this.setAllowsChildren(false);
    }

    public void setUserObject(Object object) {
        if (object instanceof NameList) {
            this.name = (NameList)object;
        }
        super.setUserObject(object);
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        this.generateReport();
    }

    public JPopupMenu getPopupMenuForButtons() {
        this.showPopupMenu(null);
        return this.menu;
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        this.menu = this.getPopupMenu();
        this.addMenuItem(this.menu, "STG5053L", GENERATE, true, "REGENERATE_REPORT");
        this.addMenuItem(this.menu, "GUI0106L", DELETE, this.name.nlID > 299, null);
        this.addMenuItem(this.menu, "GUI0047L", RENAME, this.name.nlID > 299, null);
        if (mouseEvent != null) {
            this.showPopupMenu(this.menu, mouseEvent);
        }
    }

    private void addMenuItem(JPopupMenu jPopupMenu, String string, String string2, boolean bl, String string3) {
        String string4 = string3 == null ? MessageLog.getMessageNoID(string) : Util.getString(string3);
        JMenuItem jMenuItem = new JMenuItem(string4);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(bl);
        jMenuItem.setName(string4);
        jPopupMenu.add(jMenuItem);
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        defaultTreeCellRenderer.setIcon(NameListTreeCellRenderer.iconForObject(this.name));
        defaultTreeCellRenderer.setFont(BaseTree.plainFont);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.actionCmd = actionEvent.getActionCommand();
        if (this.actionCmd == GENERATE) {
            this.generateReport();
        } else if (this.actionCmd == DELETE) {
            if (!GuiUtil.confirmDelete(BaseTree.pBaseTree, this.getDescription())) {
                return;
            }
            new GuiDelete().delete(this.name);
        } else if (this.actionCmd == RENAME) {
            StringBuffer stringBuffer = new StringBuffer(65);
            stringBuffer.append(GuiUtil.getUserName());
            stringBuffer.append('.');
            stringBuffer.append(this.name.nlName);
            NameList nameList = (NameList)this.name.clone();
            nameList.nlName = stringBuffer.toString();
            new GuiRename(nameList, this.getDescription()).rename();
        }
    }

    private String getDescription() {
        return MessageLog.getMessageNoID("STG4154L", this.name.nlName);
    }

    private void generateReport() {
        GuiSavedReportReq guiSavedReportReq = new GuiSavedReportReq();
        guiSavedReportReq.ID = this.name.nlID;
        guiSavedReportReq.enabled = true;
        SavedReportNode.doRequest(this, guiSavedReportReq);
    }

    public static void doRequest(GuiRequestor guiRequestor, GuiSavedReportReq guiSavedReportReq) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.SavedReportHndlr";
        request.userName = GuiUtil.getUserName();
        request.flags = (byte)4;
        request.requestData = guiSavedReportReq;
        GuiClient.doRequest(guiRequestor, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4 || response.responseData == null) {
            return;
        }
        GuiSavedReportReq guiSavedReportReq = (GuiSavedReportReq)response.responseData;
        this.selectionServices = ReportingTreeLabel.selectionServiceArray[guiSavedReportReq.grr.reportType];
        this.productCode = guiSavedReportReq.productCode;
        if (this.selectionServices == -1) {
            new ReportingTableDDI(guiSavedReportReq, (BaseTreeNode)this);
        } else if (this.selectionServices == -2) {
            new UnTabbedReportingDDI(guiSavedReportReq, (BaseTreeNode)this).reDisplay();
        } else {
            new ReportingDDI(guiSavedReportReq, (BaseTreeNode)this).reDisplay();
        }
    }
}

