/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.gui.RemovedResourceSettingsEditor;
import org.eclipse.aperi.TStorm.gui.ResourceHistorySettingsEditor;
import org.eclipse.aperi.TStorm.gui.SettingsEditor;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class SettingsDDI
extends DataDisplayInfo
implements GuiRequestor,
ActionListener {
    private static final String[] descriptions = new String[]{"STG3233T", "STG3234T", "STG3235T"};
    private static final String[] tooltips = new String[]{"STG3237T", "STG3238T", "STG3239T"};
    private static final String[] helpMsgs = new String[]{"asco20", "asco10", "asco15"};
    private static String[] subTypes = new String[]{"org.eclipse.aperi.server.handler.gui.SettingsHndlr.Email", "org.eclipse.aperi.server.handler.gui.SettingsHndlr.History", "org.eclipse.aperi.server.handler.gui.SettingsHndlr.Removed"};
    public int badField;
    private int type;
    private GeneralException validationError;
    private Settings saved;
    private Settings settings;
    private SettingsEditor editor;
    private boolean notifyValidationError;
    private boolean closing;
    private String tooltipText;

    public SettingsDDI(int n) {
        this.type = n;
        this.setDescription(MessageLog.getMessageNoID(descriptions[this.type]));
        this.tooltipText = MessageLog.getMessageNoID(tooltips[this.type]);
        this.helpID = helpMsgs[this.type];
        this.settings = null;
        this.validationError = null;
        this.closing = false;
    }

    private void getDataAndValidate() {
        this.editor.getData(this.settings);
        this.validationError = null;
        try {
            this.editor.validate(this.settings);
        }
        catch (GeneralException generalException) {
            this.validationError = generalException;
        }
    }

    public void panelToBeNulled() {
        this.getDataAndValidate();
        this.editor = null;
    }

    public void losingFocus() {
        guiMain.setSaveActionEnabled(false, false);
        guiMain.setSaveActionToolTip(null);
        guiMain.removeSaveActionListener(this);
    }

    public boolean isEditable() {
        return true;
    }

    public boolean changesPending() {
        if (this.saved == null) {
            return true;
        }
        if (this.editor != null) {
            this.editor.getData(this.settings);
        }
        return !Util.stringsEqual(this.settings.seEmailAddrRules, this.saved.seEmailAddrRules) || this.settings.seFSDailyHist != this.saved.seFSDailyHist || this.settings.seFSWeeklyHist != this.saved.seFSWeeklyHist || this.settings.seFSMonthlyHist != this.saved.seFSMonthlyHist || this.settings.seDiskDailyHist != this.saved.seDiskDailyHist || this.settings.seDiskWeeklyHist != this.saved.seDiskWeeklyHist || this.settings.seDiskMonthlyHist != this.saved.seDiskMonthlyHist || this.settings.sePingDailyHist != this.saved.sePingDailyHist || this.settings.sePingWeeklyHist != this.saved.sePingWeeklyHist || this.settings.sePingMonthlyHist != this.saved.sePingMonthlyHist || this.settings.seCompDailyHist != this.saved.seCompDailyHist || this.settings.seCompWeeklyHist != this.saved.seCompWeeklyHist || this.settings.seCompMonthlyHist != this.saved.seCompMonthlyHist || this.settings.seKeepRemovedFS != this.saved.seKeepRemovedFS || this.settings.seKeepRemovedDev != this.saved.seKeepRemovedDev || this.settings.seKeepRemovedFilers != this.saved.seKeepRemovedFilers || this.settings.seKeepRemovedSubsystems != this.saved.seKeepRemovedSubsystems || this.settings.seKeepRemovedFabric != this.saved.seKeepRemovedFabric || this.settings.seKeepRemovedTape != this.saved.seKeepRemovedTape;
    }

    private void showAndAddListeners() {
        this.show();
        guiMain.setSaveActionEnabled(true, false);
        guiMain.setSaveActionToolTip(this.tooltipText);
        guiMain.addSaveActionListener(this);
    }

    public void sendRequest() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = subTypes[this.type];
        request.requestData = this.settings;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void buildEditor() {
        switch (this.type) {
            case 1: {
                this.editor = new ResourceHistorySettingsEditor(this);
                break;
            }
            case 2: {
                this.editor = new RemovedResourceSettingsEditor(this);
            }
        }
        this.panel = this.editor.getComponent(this.settings);
    }

    public void reDisplay() {
        if (this.settings == null) {
            this.sendRequest();
            return;
        }
        if (this.editor == null) {
            this.buildEditor();
            if (this.notifyValidationError) {
                this.editor.selectField(false);
                this.notifyValidationError = false;
            }
        }
        this.showAndAddListeners();
    }

    private void save() {
        boolean bl;
        boolean bl2 = bl = this.editor != null;
        if (bl) {
            this.getDataAndValidate();
        }
        if (this.validationError == null) {
            this.sendRequest();
        } else {
            this.closing = false;
            GuiUtil.displayException(this.validationError);
            if (bl) {
                this.editor.selectField(SettingsDDI.getCurrent() == this);
            } else {
                this.notifyValidationError = true;
            }
            this.reDisplay();
        }
    }

    public void saveAndClose() {
        this.closing = true;
        this.save();
    }

    public void handleResponse(short s, Response response) {
        boolean bl = this.closing;
        this.closing = false;
        if (s > 4) {
            return;
        }
        if (bl) {
            this.remove();
            return;
        }
        boolean bl2 = true;
        Settings settings = (Settings)response.responseData;
        if (this.settings == null) {
            this.settings = settings;
            if (this.settings == null) {
                bl2 = false;
                this.settings = new Settings(true);
                this.settings.seDiskDesiredAWRE = 1;
                this.settings.seDiskDesiredARRE = 1;
                this.settings.seDiskDesiredNoErrRcvry = 1;
            }
            this.buildEditor();
            this.showAndAddListeners();
        }
        if (bl2) {
            this.saved = (Settings)this.settings.clone();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.save();
    }
}

