/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.PrimitiveConditionEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.TableDataSource;
import org.eclipse.aperi.gui.BaseTree;

public class SimpleMindedTable
extends JPanel {
    private static final int SPACE_ABOVE_SEPARATOR = 2;
    private static final int SPACE_BELOW_SEPARATOR = 4;
    private static final int HORIZONTAL_POOCH = 1;
    private static final int VERTICAL_POOCH = 1;
    private static final int SIDE_INSETS = 10;
    private static final int TOP_INSET = 10;
    private static final int BOTTOM_INSET = 3;
    private TableDataSource dataSource;
    private JComponent[][] cells;
    private Component[][] nullComponents;
    private int nColumns;
    private int weightedColumn;
    private Dimension[] sizes;

    public SimpleMindedTable(TableDataSource tableDataSource, String[] stringArray, int n, Dimension[] dimensionArray, int n2) {
        super(new GridBagLayout());
        Serializable serializable;
        this.dataSource = tableDataSource;
        this.sizes = dimensionArray;
        this.weightedColumn = n2;
        int n3 = 0;
        this.nColumns = stringArray.length;
        if (dimensionArray.length != this.nColumns) {
            throw new RuntimeException();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 2;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 1;
        gridBagConstraints.anchor = 10;
        JLabel[] jLabelArray = new JLabel[this.nColumns];
        int n4 = 0;
        while (n4 < this.nColumns) {
            if (n3 < dimensionArray[n4].height) {
                n3 = dimensionArray[n4].height;
            }
            jLabelArray[n4] = new JLabel(stringArray[n4], 0);
            jLabelArray[n4].setFont(BaseTree.boldFont);
            serializable = jLabelArray[n4].getPreferredSize();
            if (serializable.width < dimensionArray[n4].width) {
                serializable.width = dimensionArray[n4].width;
                jLabelArray[n4].setPreferredSize((Dimension)serializable);
            }
            gridBagConstraints.weightx = n4 == this.weightedColumn ? 1.0 : 0.0;
            if (n4 == this.nColumns - 1) {
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets.right = 10;
            }
            this.add((Component)jLabelArray[n4], gridBagConstraints);
            gridBagConstraints.insets.left = 1;
            ++n4;
        }
        gridBagConstraints.weightx = 0.0;
        Color color = this.getBackground();
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 1;
        gridBagConstraints.fill = 2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets.left = 10;
        gridBagConstraints2.insets.right = 10;
        gridBagConstraints2.insets.bottom = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 0;
        this.cells = new JComponent[n][];
        this.nullComponents = new Component[n][];
        int n5 = 0;
        while (n5 < n) {
            serializable = new PrimitiveConditionEditor.HorizontalSeparator(color);
            this.add((Component)serializable, gridBagConstraints2);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.insets.right = 1;
            this.cells[n5] = new JComponent[this.nColumns];
            this.nullComponents[n5] = new Component[this.nColumns];
            int n6 = 0;
            while (n6 < this.nColumns) {
                this.cells[n5][n6] = new JPanel(new BorderLayout());
                if (n6 == this.nColumns - 1) {
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.insets.right = 10;
                }
                this.add((Component)this.cells[n5][n6], gridBagConstraints);
                this.nullComponents[n5][n6] = Box.createVerticalStrut(n3);
                ++n6;
            }
            ++n5;
        }
        gridBagConstraints2.gridheight = 0;
        gridBagConstraints2.weighty = 1.0;
        this.add(Box.createVerticalStrut(3), gridBagConstraints2);
        this.refresh();
    }

    public void refresh() {
        int n;
        int n2 = this.dataSource.getRowCount();
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < this.nColumns) {
                Component component = this.dataSource.getComponentAt(n3, n);
                if (component == null) {
                    component = this.nullComponents[n3][n];
                }
                this.cells[n3][n].removeAll();
                this.cells[n3][n].add(component, "Center");
                ++n;
            }
            ++n3;
        }
        while (n3 < this.cells.length) {
            n = 0;
            while (n < this.nColumns) {
                this.cells[n3][n].removeAll();
                this.cells[n3][n].add(this.nullComponents[n3][n], "Center");
                ++n;
            }
            ++n3;
        }
        this.validate();
        this.repaint();
    }

    public void fixNonWeighted() {
        int n = 0;
        while (n < this.nColumns) {
            JComponent jComponent = this.cells[0][n];
            Component component = jComponent.getComponent(0);
            if (component != this.nullComponents[0][n]) {
                this.sizes[n] = component.getSize();
            }
            ++n;
        }
        n = 0;
        while (n < this.cells.length) {
            int n2 = 0;
            while (n2 < this.nColumns) {
                if (n2 != this.weightedColumn) {
                    this.cells[n][n2].setPreferredSize(this.sizes[n2]);
                    this.cells[n][n2].setMinimumSize(this.sizes[n2]);
                    this.cells[n][n2].setMaximumSize(this.sizes[n2]);
                }
                ++n2;
            }
            ++n;
        }
        this.sizes = null;
    }
}

