/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class SaferServerSocket
extends ServerSocket {
    public SaferServerSocket(int n) throws IOException {
        super(n);
    }

    public SaferServerSocket(int n, int n2) throws IOException {
        super(n, n2);
    }

    public SaferServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
    }

    public Socket accept() throws IOException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SaferServerSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "accept", "");
        }
        Socket socket = null;
        int n = 0;
        Object[] objectArray = null;
        while (socket == null && !this.isClosed()) {
            try {
                socket = super.accept();
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.backend.SaferServerSocket");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception(clazz.getName(), "accept", iOException);
                }
                if (objectArray == null) {
                    objectArray = new Object[]{iOException.getMessage()};
                }
                MessageLog.logMessage("GEN0004E", objectArray);
                if (++n < 10) continue;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.backend.SaferServerSocket");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit(clazz.getName(), "accept");
                }
                throw iOException;
            }
        }
        Socket socket2 = socket;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SaferServerSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "accept", socket2);
        }
        return socket2;
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException iOException) {}
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.SaferServerSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "close");
        }
    }
}

