/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.eclipse.aperi.xmsg.MessageFormatter;

public class StorageException
extends Exception
implements Serializable {
    static final long serialVersionUID = 1090083897006496166L;
    public String messageID;
    public Object[] args;
    public String systemError;
    public Exception exception;
    public StorageException nextException;
    private static MessageFormatter defaultFormatter;

    public StorageException(String string, Object[] objectArray) {
        this(string, objectArray, null, null);
    }

    public StorageException(String string, Object[] objectArray, String string2) {
        this(string, objectArray, string2, null);
    }

    public StorageException(String string, Object[] objectArray, String string2, Exception exception) {
        this.messageID = string;
        this.args = objectArray;
        this.systemError = string2;
        this.exception = exception;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getSystemError() {
        return this.systemError;
    }

    public void addException(StorageException storageException) {
        StorageException storageException2 = this;
        while (storageException2.nextException != null) {
            storageException2 = storageException2.nextException;
        }
        storageException2.nextException = storageException;
    }

    public static void setDefaultFormatter(MessageFormatter messageFormatter) {
        defaultFormatter = messageFormatter;
    }

    public String getMessage(MessageFormatter messageFormatter) {
        PrintWriter printWriter = null;
        CharArrayWriter charArrayWriter = null;
        StringBuffer stringBuffer = new StringBuffer();
        StorageException storageException = this;
        while (storageException != null) {
            stringBuffer.append(messageFormatter.format(storageException.messageID, storageException.args));
            stringBuffer.append('\n');
            if (storageException.systemError != null) {
                stringBuffer.append(messageFormatter.formatSystemError(storageException.systemError));
                stringBuffer.append('\n');
            }
            if (storageException.exception != null) {
                if (printWriter != null) {
                    charArrayWriter.reset();
                } else {
                    charArrayWriter = new CharArrayWriter();
                    printWriter = new PrintWriter((Writer)charArrayWriter, true);
                }
                storageException.exception.printStackTrace(printWriter);
                stringBuffer.append(charArrayWriter.toCharArray());
            }
            storageException = storageException.nextException;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public Iterator getIterator() {
        return new ExceptionIterator(this);
    }

    public String getMessage() {
        if (defaultFormatter == null) {
            throw new RuntimeException("Illegal call to StorageException.getMessage()");
        }
        return this.getMessage(defaultFormatter);
    }

    public String toString() {
        String string = this.getClass().getName();
        return this.messageID != null ? String.valueOf(string) + ": " + this.messageID : string;
    }

    private class ExceptionIterator
    implements Iterator {
        private StorageException next;

        ExceptionIterator(StorageException storageException2) {
            this.next = storageException2;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            StorageException storageException = this.next;
            this.next = this.next.nextException;
            return storageException;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

